/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;

@Deprecated
public class LogSource {
    protected static Hashtable<String, Log> logs = new Hashtable();
    protected static boolean log4jIsAvailable;
    @Deprecated
    protected static boolean jdk14IsAvailable;
    protected static Constructor<?> logImplctor;
    private static final String[] EMPTY_STRING_ARRAY;

    public static Log getInstance(Class<?> clazz) {
        return LogSource.getInstance(clazz.getName());
    }

    public static Log getInstance(String name) {
        return logs.computeIfAbsent(name, k -> LogSource.makeNewLogInstance(name));
    }

    public static String[] getLogNames() {
        return logs.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    private static boolean isClassForName(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Log makeNewLogInstance(String name) {
        Log log;
        try {
            Object[] args2 = new Object[]{name};
            log = (Log)logImplctor.newInstance(args2);
        }
        catch (Throwable t2) {
            log = null;
        }
        if (null == log) {
            log = new NoOpLog(name);
        }
        return log;
    }

    public static void setLogImplementation(Class<?> logClass) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException {
        logImplctor = logClass.getConstructor(String.class);
    }

    public static void setLogImplementation(String className) throws LinkageError, SecurityException {
        try {
            Class<?> logClass = Class.forName(className);
            logImplctor = logClass.getConstructor(String.class);
        }
        catch (Throwable t2) {
            logImplctor = null;
        }
    }

    private LogSource() {
    }

    static {
        jdk14IsAvailable = true;
        EMPTY_STRING_ARRAY = new String[0];
        log4jIsAvailable = LogSource.isClassForName("org.apache.log4j.Logger");
        String name = null;
        try {
            name = System.getProperty("org.apache.commons.logging.log");
            if (name == null) {
                name = System.getProperty("org.apache.commons.logging.Log");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (name != null) {
            try {
                LogSource.setLogImplementation(name);
            }
            catch (Throwable t2) {
                try {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable) {}
            }
        } else {
            try {
                if (log4jIsAvailable) {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.Log4JLogger");
                } else {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.Jdk14Logger");
                }
            }
            catch (Throwable t3) {
                try {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

