/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.io.PrintStream;
import org.apache.commons.configuration2.tree.ImmutableNode;

public final class TreeUtils {
    public static void printTree(PrintStream stream, ImmutableNode result2) {
        if (stream != null) {
            TreeUtils.printTree(stream, "", result2);
        }
    }

    private static void printTree(PrintStream stream, String indent, ImmutableNode result2) {
        StringBuilder buffer = new StringBuilder(indent).append("<").append(result2.getNodeName());
        result2.getAttributes().forEach((k, v) -> buffer.append(' ').append((String)k).append("='").append(v).append("'"));
        buffer.append(">");
        stream.print(buffer.toString());
        if (result2.getValue() != null) {
            stream.print(result2.getValue());
        }
        boolean newline = false;
        if (!result2.getChildren().isEmpty()) {
            stream.print("\n");
            result2.forEach(child -> TreeUtils.printTree(stream, indent + "  ", child));
            newline = true;
        }
        if (newline) {
            stream.print(indent);
        }
        stream.println("</" + result2.getNodeName() + ">");
    }

    private TreeUtils() {
    }
}

