/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeCombiner;

public class OverrideCombiner
extends NodeCombiner {
    protected void addAttributes(ImmutableNode.Builder result2, ImmutableNode node1, ImmutableNode node2) {
        result2.addAttributes(node1.getAttributes());
        node2.getAttributes().keySet().forEach(attr -> {
            if (!node1.getAttributes().containsKey(attr)) {
                result2.addAttribute((String)attr, HANDLER.getAttributeValue(node2, (String)attr));
            }
        });
    }

    protected ImmutableNode canCombine(ImmutableNode node1, ImmutableNode node2, ImmutableNode child) {
        if (HANDLER.getChildrenCount(node2, child.getNodeName()) == 1 && HANDLER.getChildrenCount(node1, child.getNodeName()) == 1 && !this.isListNode(child)) {
            return HANDLER.getChildren(node2, child.getNodeName()).get(0);
        }
        return null;
    }

    @Override
    public ImmutableNode combine(ImmutableNode node1, ImmutableNode node2) {
        ImmutableNode.Builder result2 = new ImmutableNode.Builder();
        result2.name(node1.getNodeName());
        node1.forEach(child -> {
            ImmutableNode child2 = this.canCombine(node1, node2, (ImmutableNode)child);
            result2.addChild(child2 != null ? this.combine((ImmutableNode)child, child2) : child);
        });
        node2.stream().filter(child -> HANDLER.getChildrenCount(node1, child.getNodeName()) < 1).forEach(result2::addChild);
        this.addAttributes(result2, node1, node2);
        result2.value(node1.getValue() != null ? node1.getValue() : node2.getValue());
        return result2.create();
    }
}

