/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.LinkedList;
import org.apache.commons.configuration2.tree.ConfigurationNodeVisitor;
import org.apache.commons.configuration2.tree.NodeHandler;

public class NodeTreeWalker {
    public static final NodeTreeWalker INSTANCE = new NodeTreeWalker();

    private static <T> void bfs(T root, ConfigurationNodeVisitor<T> visitor2, NodeHandler<T> handler) {
        LinkedList<T> pendingNodes = new LinkedList<T>();
        pendingNodes.add(root);
        boolean cancel = false;
        while (!pendingNodes.isEmpty() && !cancel) {
            Object node = pendingNodes.remove(0);
            visitor2.visitBeforeChildren(node, handler);
            cancel = visitor2.terminate();
            pendingNodes.addAll(handler.getChildren(node));
        }
    }

    private static <T> boolean checkParameters(T root, ConfigurationNodeVisitor<T> visitor2, NodeHandler<T> handler) {
        if (visitor2 == null) {
            throw new IllegalArgumentException("Visitor must not be null!");
        }
        if (handler == null) {
            throw new IllegalArgumentException("NodeHandler must not be null!");
        }
        return root != null;
    }

    private static <T> void dfs(T node, ConfigurationNodeVisitor<T> visitor2, NodeHandler<T> handler) {
        if (!visitor2.terminate()) {
            visitor2.visitBeforeChildren(node, handler);
            handler.getChildren(node).forEach(c -> NodeTreeWalker.dfs(c, visitor2, handler));
            if (!visitor2.terminate()) {
                visitor2.visitAfterChildren(node, handler);
            }
        }
    }

    public <T> void walkBFS(T root, ConfigurationNodeVisitor<T> visitor2, NodeHandler<T> handler) {
        if (NodeTreeWalker.checkParameters(root, visitor2, handler)) {
            NodeTreeWalker.bfs(root, visitor2, handler);
        }
    }

    public <T> void walkDFS(T root, ConfigurationNodeVisitor<T> visitor2, NodeHandler<T> handler) {
        if (NodeTreeWalker.checkParameters(root, visitor2, handler)) {
            NodeTreeWalker.dfs(root, visitor2, handler);
        }
    }
}

