/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeCombiner;

public class MergeCombiner
extends NodeCombiner {
    private static boolean matchAttributes(Map<String, Object> attrs1, ImmutableNode node) {
        Map<String, Object> attrs2 = node.getAttributes();
        for (Map.Entry<String, Object> e : attrs1.entrySet()) {
            if (!attrs2.containsKey(e.getKey()) || Objects.equals(e.getValue(), attrs2.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    protected void addAttributes(ImmutableNode.Builder result2, ImmutableNode node1, ImmutableNode node2) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(node1.getAttributes());
        node2.getAttributes().forEach(attributes::putIfAbsent);
        result2.addAttributes(attributes);
    }

    protected ImmutableNode canCombine(ImmutableNode node2, ImmutableNode child, List<ImmutableNode> children2) {
        Map<String, Object> attrs1 = child.getAttributes();
        ArrayList nodes = new ArrayList();
        List<ImmutableNode> children3 = HANDLER.getChildren(node2, child.getNodeName());
        children3.forEach(node -> {
            if (MergeCombiner.matchAttributes(attrs1, node)) {
                nodes.add(node);
            }
        });
        if (nodes.size() == 1) {
            return (ImmutableNode)nodes.get(0);
        }
        if (nodes.size() > 1 && !this.isListNode(child)) {
            nodes.forEach(children2::remove);
        }
        return null;
    }

    @Override
    public ImmutableNode combine(ImmutableNode node1, ImmutableNode node2) {
        ImmutableNode.Builder result2 = new ImmutableNode.Builder();
        result2.name(node1.getNodeName());
        result2.value(node1.getValue());
        this.addAttributes(result2, node1, node2);
        LinkedList<ImmutableNode> children2 = new LinkedList<ImmutableNode>(node2.getChildren());
        node1.forEach(child1 -> {
            ImmutableNode child2 = this.canCombine(node2, (ImmutableNode)child1, (List<ImmutableNode>)children2);
            if (child2 != null) {
                result2.addChild(this.combine((ImmutableNode)child1, child2));
                children2.remove(child2);
            } else {
                result2.addChild((ImmutableNode)child1);
            }
        });
        children2.forEach(result2::addChild);
        return result2.create();
    }
}

