/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.convert.AbstractListDelimiterHandler;
import org.apache.commons.configuration2.convert.ValueTransformer;
import org.apache.commons.lang3.StringUtils;

public class LegacyListDelimiterHandler
extends AbstractListDelimiterHandler {
    private static final String ESCAPE = "\\";
    private static final String DOUBLE_ESC = "\\\\";
    private static final String QUAD_ESC = "\\\\\\\\";
    private final char delimiter;

    private static int countTrailingBS(String line) {
        int bsCount = 0;
        for (int idx = line.length() - 1; idx >= 0 && line.charAt(idx) == '\\'; --idx) {
            ++bsCount;
        }
        return bsCount;
    }

    public LegacyListDelimiterHandler(char listDelimiter) {
        this.delimiter = listDelimiter;
    }

    @Override
    public Object escape(Object value, ValueTransformer transformer) {
        return this.escapeValue(value, false, transformer);
    }

    protected String escapeBackslashs(Object value, boolean inList) {
        String strValue = String.valueOf(value);
        if (inList && strValue.contains(DOUBLE_ESC)) {
            strValue = StringUtils.replace(strValue, DOUBLE_ESC, QUAD_ESC);
        }
        return strValue;
    }

    @Override
    public Object escapeList(List<?> values2, ValueTransformer transformer) {
        if (!values2.isEmpty()) {
            Iterator<?> it = values2.iterator();
            String lastValue = this.escapeValue(it.next(), true, transformer);
            StringBuilder buf = new StringBuilder(lastValue);
            while (it.hasNext()) {
                if (lastValue.endsWith(ESCAPE) && LegacyListDelimiterHandler.countTrailingBS(lastValue) / 2 % 2 != 0) {
                    buf.append(ESCAPE).append(ESCAPE);
                }
                buf.append(this.getDelimiter());
                lastValue = this.escapeValue(it.next(), true, transformer);
                buf.append(lastValue);
            }
            return buf.toString();
        }
        return null;
    }

    @Override
    protected String escapeString(String s2) {
        return null;
    }

    protected String escapeValue(Object value, boolean inList, ValueTransformer transformer) {
        String escapedValue = String.valueOf(transformer.transformValue(this.escapeBackslashs(value, inList)));
        if (this.getDelimiter() != '\u0000') {
            escapedValue = StringUtils.replace(escapedValue, String.valueOf(this.getDelimiter()), ESCAPE + this.getDelimiter());
        }
        return escapedValue;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    @Override
    protected Collection<String> splitString(String s2, boolean trim) {
        if (s2.indexOf(this.getDelimiter()) < 0) {
            return Collections.singleton(s2);
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder token2 = new StringBuilder();
        boolean inEscape = false;
        char esc = ESCAPE.charAt(0);
        for (int begin = 0; begin < s2.length(); ++begin) {
            char c = s2.charAt(begin);
            if (inEscape) {
                if (c != this.getDelimiter() && c != esc) {
                    token2.append(esc);
                }
                token2.append(c);
                inEscape = false;
                continue;
            }
            if (c == this.getDelimiter()) {
                String t2 = token2.toString();
                if (trim) {
                    t2 = t2.trim();
                }
                list.add(t2);
                token2 = new StringBuilder();
                continue;
            }
            if (c == esc) {
                inEscape = true;
                continue;
            }
            token2.append(c);
        }
        if (inEscape) {
            token2.append(esc);
        }
        String t3 = token2.toString();
        if (trim) {
            t3 = t3.trim();
        }
        list.add(t3);
        return list;
    }
}

