/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.convert;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration2.convert.AbstractListDelimiterHandler;
import org.apache.commons.configuration2.convert.ValueTransformer;
import org.apache.commons.lang3.StringUtils;

public class DefaultListDelimiterHandler
extends AbstractListDelimiterHandler {
    private static final char ESCAPE = '\\';
    private static final int BUF_SIZE = 16;
    private final char delimiter;

    public DefaultListDelimiterHandler(char listDelimiter) {
        this.delimiter = listDelimiter;
    }

    @Override
    public Object escapeList(List<?> values2, ValueTransformer transformer) {
        Object[] escapedValues = new Object[values2.size()];
        int idx = 0;
        for (Object v : values2) {
            escapedValues[idx++] = this.escape(v, transformer);
        }
        return StringUtils.join(escapedValues, this.getDelimiter());
    }

    @Override
    protected String escapeString(String s2) {
        StringBuilder buf = new StringBuilder(s2.length() + 16);
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == this.getDelimiter() || c == '\\') {
                buf.append('\\');
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    @Override
    protected Collection<String> splitString(String s2, boolean trim) {
        LinkedList<String> list = new LinkedList<String>();
        StringBuilder token2 = new StringBuilder();
        boolean inEscape = false;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (inEscape) {
                if (c != this.getDelimiter() && c != '\\') {
                    token2.append('\\');
                }
                token2.append(c);
                inEscape = false;
                continue;
            }
            if (c == this.getDelimiter()) {
                String t2 = token2.toString();
                if (trim) {
                    t2 = t2.trim();
                }
                list.add(t2);
                token2 = new StringBuilder();
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            token2.append(c);
        }
        if (inEscape) {
            token2.append('\\');
        }
        String t3 = token2.toString();
        if (trim) {
            t3 = t3.trim();
        }
        list.add(t3);
        return list;
    }
}

