/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.configuration2.tree.ImmutableNode;

public class AbstractYAMLBasedConfiguration
extends BaseHierarchicalConfiguration {
    private static void addEntry(Map<String, Object> map2, String key, Object value) {
        Object oldValue = map2.get(key);
        if (oldValue == null) {
            map2.put(key, value);
        } else if (oldValue instanceof Collection) {
            Collection values2 = (Collection)oldValue;
            values2.add(value);
        } else {
            ArrayList<Object> values3 = new ArrayList<Object>();
            values3.add(oldValue);
            values3.add(value);
            map2.put(key, values3);
        }
    }

    private static List<ImmutableNode> constructHierarchy(String key, Object elem) {
        if (elem instanceof Map) {
            return AbstractYAMLBasedConfiguration.parseMap((Map)elem, key);
        }
        if (elem instanceof Collection) {
            return AbstractYAMLBasedConfiguration.parseCollection((Collection)elem, key);
        }
        return Collections.singletonList(new ImmutableNode.Builder().name(key).value(elem).create());
    }

    private static List<ImmutableNode> parseCollection(Collection<Object> col, String key) {
        return col.stream().flatMap(elem -> AbstractYAMLBasedConfiguration.constructHierarchy(key, elem).stream()).collect(Collectors.toList());
    }

    private static List<ImmutableNode> parseMap(Map<String, Object> map2, String key) {
        ImmutableNode.Builder subtree = new ImmutableNode.Builder().name(key);
        map2.forEach((k, v) -> AbstractYAMLBasedConfiguration.constructHierarchy(k, v).forEach(subtree::addChild));
        return Collections.singletonList(subtree.create());
    }

    static void rethrowException(Exception e) throws ConfigurationException {
        if (e instanceof ClassCastException) {
            throw new ConfigurationException("Error parsing", e);
        }
        throw new ConfigurationException("Unable to load the configuration", e);
    }

    protected AbstractYAMLBasedConfiguration() {
        this.initLogger(new ConfigurationLogger(this.getClass()));
    }

    protected AbstractYAMLBasedConfiguration(HierarchicalConfiguration<ImmutableNode> c) {
        super(c);
        this.initLogger(new ConfigurationLogger(this.getClass()));
    }

    protected Map<String, Object> constructMap(ImmutableNode node) {
        HashMap<String, Object> map2 = new HashMap<String, Object>(node.getChildren().size());
        node.forEach(cNode -> AbstractYAMLBasedConfiguration.addEntry(map2, cNode.getNodeName(), cNode.getChildren().isEmpty() ? cNode.getValue() : this.constructMap((ImmutableNode)cNode)));
        return map2;
    }

    protected void load(Map<String, Object> map2) {
        List<ImmutableNode> roots2 = AbstractYAMLBasedConfiguration.constructHierarchy("", map2);
        this.getNodeModel().setRootNode(roots2.get(0));
    }
}

