/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.keyvalue.AbstractMapEntryDecorator;
import org.apache.commons.collections.map.AbstractMapDecorator;
import org.apache.commons.collections.set.AbstractSetDecorator;

abstract class AbstractInputCheckedMapDecorator
extends AbstractMapDecorator {
    protected AbstractInputCheckedMapDecorator() {
    }

    protected AbstractInputCheckedMapDecorator(Map map2) {
        super(map2);
    }

    protected abstract Object checkSetValue(Object var1);

    protected boolean isSetValueChecking() {
        return true;
    }

    public Set entrySet() {
        if (this.isSetValueChecking()) {
            return new EntrySet(this.map.entrySet(), this);
        }
        return this.map.entrySet();
    }

    static class MapEntry
    extends AbstractMapEntryDecorator {
        private final AbstractInputCheckedMapDecorator parent;

        protected MapEntry(Map.Entry entry, AbstractInputCheckedMapDecorator parent) {
            super(entry);
            this.parent = parent;
        }

        public Object setValue(Object value) {
            value = this.parent.checkSetValue(value);
            return this.entry.setValue(value);
        }
    }

    static class EntrySetIterator
    extends AbstractIteratorDecorator {
        private final AbstractInputCheckedMapDecorator parent;

        protected EntrySetIterator(Iterator iterator2, AbstractInputCheckedMapDecorator parent) {
            super(iterator2);
            this.parent = parent;
        }

        public Object next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            return new MapEntry(entry, this.parent);
        }
    }

    static class EntrySet
    extends AbstractSetDecorator {
        private final AbstractInputCheckedMapDecorator parent;

        protected EntrySet(Set set, AbstractInputCheckedMapDecorator parent) {
            super(set);
            this.parent = parent;
        }

        public Iterator iterator() {
            return new EntrySetIterator(this.collection.iterator(), this.parent);
        }

        public Object[] toArray() {
            Object[] array = this.collection.toArray();
            for (int i = 0; i < array.length; ++i) {
                array[i] = new MapEntry((Map.Entry)array[i], this.parent);
            }
            return array;
        }

        public Object[] toArray(Object[] array) {
            Object[] result2 = array;
            if (array.length > 0) {
                result2 = (Object[])Array.newInstance(array.getClass().getComponentType(), 0);
            }
            result2 = this.collection.toArray(result2);
            for (int i = 0; i < result2.length; ++i) {
                result2[i] = new MapEntry((Map.Entry)result2[i], this.parent);
            }
            if (result2.length > array.length) {
                return result2;
            }
            System.arraycopy(result2, 0, array, 0, result2.length);
            if (array.length > result2.length) {
                array[result2.length] = null;
            }
            return array;
        }
    }
}

