/*
 * Decompiled with CFR 0.152.
 */
package it.krzeminski.snakeyaml.engine.kmp.serializer;

import it.krzeminski.snakeyaml.engine.kmp.api.DumpSettings;
import it.krzeminski.snakeyaml.engine.kmp.comments.CommentLine;
import it.krzeminski.snakeyaml.engine.kmp.common.Anchor;
import it.krzeminski.snakeyaml.engine.kmp.emitter.Emitable;
import it.krzeminski.snakeyaml.engine.kmp.events.AliasEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.CommentEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.DocumentEndEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.DocumentStartEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.ImplicitTuple;
import it.krzeminski.snakeyaml.engine.kmp.events.MappingEndEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.MappingStartEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.ScalarEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.SequenceEndEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.SequenceStartEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.StreamEndEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.StreamStartEvent;
import it.krzeminski.snakeyaml.engine.kmp.nodes.AnchorNode;
import it.krzeminski.snakeyaml.engine.kmp.nodes.MappingNode;
import it.krzeminski.snakeyaml.engine.kmp.nodes.Node;
import it.krzeminski.snakeyaml.engine.kmp.nodes.NodeTuple;
import it.krzeminski.snakeyaml.engine.kmp.nodes.NodeType;
import it.krzeminski.snakeyaml.engine.kmp.nodes.ScalarNode;
import it.krzeminski.snakeyaml.engine.kmp.nodes.SequenceNode;
import it.krzeminski.snakeyaml.engine.kmp.nodes.Tag;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0018\u0010\u0015\u001a\u00020\u000f2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/serializer/Serializer;", "", "settings", "Lit/krzeminski/snakeyaml/engine/kmp/api/DumpSettings;", "emitable", "Lit/krzeminski/snakeyaml/engine/kmp/emitter/Emitable;", "<init>", "(Lit/krzeminski/snakeyaml/engine/kmp/api/DumpSettings;Lit/krzeminski/snakeyaml/engine/kmp/emitter/Emitable;)V", "serializedNodes", "", "Lit/krzeminski/snakeyaml/engine/kmp/nodes/Node;", "anchors", "", "Lit/krzeminski/snakeyaml/engine/kmp/common/Anchor;", "serializeDocument", "", "node", "emitStreamStart", "emitStreamEnd", "anchorNode", "serializeNode", "serializeComments", "comments", "", "Lit/krzeminski/snakeyaml/engine/kmp/comments/CommentLine;", "snakeyaml-engine-kmp"})
@SourceDebugExtension(value={"SMAP\nSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Serializer.kt\nit/krzeminski/snakeyaml/engine/kmp/serializer/Serializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,203:1\n381#2,7:204\n*S KotlinDebug\n*F\n+ 1 Serializer.kt\nit/krzeminski/snakeyaml/engine/kmp/serializer/Serializer\n*L\n76#1:204,7\n*E\n"})
public final class Serializer {
    @NotNull
    private final DumpSettings settings;
    @NotNull
    private final Emitable emitable;
    @NotNull
    private final Set<Node> serializedNodes;
    @NotNull
    private final Map<Node, Anchor> anchors;

    public Serializer(@NotNull DumpSettings settings, @NotNull Emitable emitable) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(emitable, "emitable");
        this.settings = settings;
        this.emitable = emitable;
        this.serializedNodes = new LinkedHashSet();
        this.anchors = new LinkedHashMap();
    }

    public final void serializeDocument(@NotNull Node node) {
        Intrinsics.checkNotNullParameter(node, "node");
        this.emitable.emit(new DocumentStartEvent(this.settings.isExplicitStart(), this.settings.yamlDirective, this.settings.tagDirective, null, null, 24, null));
        this.anchorNode(node);
        if (this.settings.explicitRootTag != null) {
            node.setTag(this.settings.explicitRootTag);
        }
        this.serializeNode(node);
        this.emitable.emit(new DocumentEndEvent(this.settings.isExplicitEnd(), null, null, 6, null));
        this.serializedNodes.clear();
        this.anchors.clear();
    }

    public final void emitStreamStart() {
        this.emitable.emit(new StreamStartEvent());
    }

    public final void emitStreamEnd() {
        this.emitable.emit(new StreamEndEvent());
    }

    private final void anchorNode(Node node) {
        Node realNode;
        Node node2 = realNode = node instanceof AnchorNode ? ((AnchorNode)node).getRealNode() : node;
        if (this.anchors.containsKey(realNode)) {
            Map<Node, Anchor> $this$getOrPut$iv = this.anchors;
            boolean $i$f$getOrPut = false;
            Anchor value$iv = $this$getOrPut$iv.get(realNode);
            if (value$iv == null) {
                boolean bl = false;
                Anchor answer$iv = this.settings.anchorGenerator.nextAnchor(realNode);
                $this$getOrPut$iv.put(realNode, answer$iv);
            }
        } else {
            this.anchors.put(realNode, realNode.getAnchor() != null ? this.settings.anchorGenerator.nextAnchor(realNode) : null);
            switch (WhenMappings.$EnumSwitchMapping$0[realNode.getNodeType().ordinal()]) {
                case 1: {
                    if (!(realNode instanceof SequenceNode)) {
                        String bl = "Failed requirement.";
                        throw new IllegalArgumentException(bl.toString());
                    }
                    for (Node item : ((SequenceNode)realNode).getValue()) {
                        this.anchorNode(item);
                    }
                    break;
                }
                case 2: {
                    if (!(realNode instanceof MappingNode)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    for (NodeTuple nodeTuple : ((MappingNode)realNode).getValue()) {
                        Node key = nodeTuple.component1();
                        Node value = nodeTuple.component2();
                        this.anchorNode(key);
                        this.anchorNode(value);
                    }
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final void serializeNode(Node node) {
        Node realNode = node instanceof AnchorNode ? ((AnchorNode)node).getRealNode() : node;
        Anchor tAlias = this.anchors.get(realNode);
        if (this.serializedNodes.contains(realNode)) {
            this.emitable.emit(new AliasEvent(tAlias, null, null, 6, null));
        } else {
            this.serializedNodes.add(realNode);
            switch (WhenMappings.$EnumSwitchMapping$0[realNode.getNodeType().ordinal()]) {
                case 3: {
                    if (!(realNode instanceof ScalarNode)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.serializeComments(realNode.getBlockComments());
                    Tag detectedTag = this.settings.schema.getScalarResolver().resolve(((ScalarNode)realNode).getValue(), true);
                    Tag defaultTag = this.settings.schema.getScalarResolver().resolve(((ScalarNode)realNode).getValue(), false);
                    ImplicitTuple tuple = new ImplicitTuple(Intrinsics.areEqual(realNode.getTag(), detectedTag), Intrinsics.areEqual(realNode.getTag(), defaultTag));
                    ScalarEvent event = new ScalarEvent(tAlias, realNode.getTag().getValue(), tuple, ((ScalarNode)realNode).getValue(), ((ScalarNode)realNode).getScalarStyle(), null, null, 96, null);
                    this.emitable.emit(event);
                    this.serializeComments(realNode.getInLineComments());
                    this.serializeComments(realNode.getEndComments());
                    break;
                }
                case 1: {
                    if (!(realNode instanceof SequenceNode)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.serializeComments(realNode.getBlockComments());
                    boolean implicitS = Intrinsics.areEqual(realNode.getTag(), Tag.SEQ);
                    this.emitable.emit(new SequenceStartEvent(tAlias, realNode.getTag().getValue(), implicitS, ((SequenceNode)realNode).getFlowStyle(), null, null, 48, null));
                    for (Node item : ((SequenceNode)realNode).getValue()) {
                        this.serializeNode(item);
                    }
                    this.emitable.emit(new SequenceEndEvent());
                    this.serializeComments(realNode.getInLineComments());
                    this.serializeComments(realNode.getEndComments());
                    break;
                }
                case 2: {
                    if (!(realNode instanceof MappingNode)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.serializeComments(realNode.getBlockComments());
                    if (Intrinsics.areEqual(realNode.getTag(), Tag.COMMENT)) break;
                    this.emitable.emit(new MappingStartEvent(tAlias, realNode.getTag().getValue(), Intrinsics.areEqual(realNode.getTag(), Tag.MAP), ((MappingNode)realNode).getFlowStyle(), null, null));
                    for (NodeTuple nodeTuple : ((MappingNode)realNode).getValue()) {
                        Node key = nodeTuple.component1();
                        Node value = nodeTuple.component2();
                        this.serializeNode(key);
                        this.serializeNode(value);
                    }
                    this.emitable.emit(new MappingEndEvent());
                    this.serializeComments(realNode.getInLineComments());
                    this.serializeComments(realNode.getEndComments());
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final void serializeComments(List<CommentLine> comments) {
        if (comments == null) {
            return;
        }
        for (CommentLine line : comments) {
            CommentEvent commentEvent = new CommentEvent(line.commentType, line.value, line.startMark, line.endMark);
            this.emitable.emit(commentEvent);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NodeType.values().length];
            try {
                nArray[NodeType.SEQUENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.MAPPING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.SCALAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.ANCHOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

