/*
 * Decompiled with CFR 0.152.
 */
package it.krzeminski.snakeyaml.engine.kmp.internal.utils;

import it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u0000\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00052\b\b\u0002\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007*\u00020\u0002H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0001H\u0000\u00a8\u0006\n"}, d2={"codePointCount", "", "", "beginIndex", "endIndex", "", "toCodePoints", "", "codePointAt", "index", "snakeyaml-engine-kmp"})
public final class CharSequenceExtensionsKt {
    public static final int codePointCount(@NotNull CharSequence $this$codePointCount, int beginIndex, int endIndex) {
        Intrinsics.checkNotNullParameter($this$codePointCount, "<this>");
        char[] cArray = ((Object)$this$codePointCount).toString().toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        return CharSequenceExtensionsKt.codePointCount(cArray, beginIndex, endIndex);
    }

    public static /* synthetic */ int codePointCount$default(CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = charSequence.length();
        }
        return CharSequenceExtensionsKt.codePointCount(charSequence, n, n2);
    }

    public static final int codePointCount(@NotNull char[] $this$codePointCount, int beginIndex, int endIndex) {
        Intrinsics.checkNotNullParameter($this$codePointCount, "<this>");
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex must not be less than 0, but was " + beginIndex);
        }
        if (endIndex > $this$codePointCount.length) {
            throw new IndexOutOfBoundsException("endIndex must not be greater than size (" + $this$codePointCount.length + "), but was " + endIndex);
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("beginIndex must not be greater than endIndex (" + endIndex + "), but was " + beginIndex);
        }
        int index = beginIndex;
        int count2 = 0;
        while (index < endIndex) {
            char nextChar;
            char firstChar = $this$codePointCount[index];
            if (java.lang.Character.isHighSurrogate(firstChar) && ++index < endIndex && java.lang.Character.isLowSurrogate(nextChar = $this$codePointCount[index])) {
                ++index;
            }
            ++count2;
        }
        return count2;
    }

    public static /* synthetic */ int codePointCount$default(char[] cArray, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = cArray.length;
        }
        return CharSequenceExtensionsKt.codePointCount(cArray, n, n2);
    }

    @NotNull
    public static final List<Integer> toCodePoints(@NotNull CharSequence $this$toCodePoints) {
        List<Integer> list;
        Intrinsics.checkNotNullParameter($this$toCodePoints, "<this>");
        List<Integer> $this$toCodePoints_u24lambda_u240 = list = CollectionsKt.createListBuilder($this$toCodePoints.length());
        boolean bl = false;
        int i = 0;
        int c = 0;
        while (i < $this$toCodePoints.length()) {
            int cp = CharSequenceExtensionsKt.codePointAt($this$toCodePoints, i);
            $this$toCodePoints_u24lambda_u240.add(cp);
            i += Character.INSTANCE.charCount$snakeyaml_engine_kmp(cp);
            ++c;
        }
        return CollectionsKt.build(list);
    }

    public static final int codePointAt(@NotNull CharSequence $this$codePointAt, int index) {
        Intrinsics.checkNotNullParameter($this$codePointAt, "<this>");
        if (!(0 <= index ? index < $this$codePointAt.length() : false)) {
            throw new IndexOutOfBoundsException("index " + index + " was not in range " + StringsKt.getIndices($this$codePointAt));
        }
        char firstChar = $this$codePointAt.charAt(index);
        if (java.lang.Character.isHighSurrogate(firstChar)) {
            java.lang.Character nextChar;
            java.lang.Character c = nextChar = StringsKt.getOrNull($this$codePointAt, index + 1);
            boolean bl = c != null ? java.lang.Character.isLowSurrogate(c.charValue()) : false;
            if (bl) {
                return Character.INSTANCE.toCodePoint$snakeyaml_engine_kmp(firstChar, nextChar.charValue());
            }
        }
        return firstChar;
    }
}

