/*
 * Decompiled with CFR 0.152.
 */
package io.outfoxx.swiftpoet;

import io.outfoxx.swiftpoet.AnyTypeSpec;
import io.outfoxx.swiftpoet.AttributedSpec;
import io.outfoxx.swiftpoet.CodeBlock;
import io.outfoxx.swiftpoet.CodeWriter;
import io.outfoxx.swiftpoet.FunctionSignatureSpec;
import io.outfoxx.swiftpoet.Modifier;
import io.outfoxx.swiftpoet.ParameterSpec;
import io.outfoxx.swiftpoet.TypeName;
import io.outfoxx.swiftpoet.TypeSpec;
import io.outfoxx.swiftpoet.TypeVariableName;
import io.outfoxx.swiftpoet.UtilKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 D2\u00020\u0001:\u0002CDB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\b\u0002\u00109\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b:J\u0010\u0010;\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0013\u0010<\u001a\u00020\u00062\b\u0010=\u001a\u0004\u0018\u00010>H\u0096\u0002J\b\u0010?\u001a\u00020@H\u0016J\u0006\u0010A\u001a\u00020\u0003J\b\u0010B\u001a\u00020 H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u0011\u0010\u0012\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u0011\u0010\u0014\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0019R\u0013\u0010'\u001a\u0004\u0018\u00010(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\bR\u0017\u00101\u001a\b\u0012\u0004\u0012\u0002020$8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0019\u00a8\u0006E"}, d2={"Lio/outfoxx/swiftpoet/FunctionSpec;", "Lio/outfoxx/swiftpoet/AttributedSpec;", "builder", "Lio/outfoxx/swiftpoet/FunctionSpec$Builder;", "(Lio/outfoxx/swiftpoet/FunctionSpec$Builder;)V", "async", "", "getAsync", "()Z", "body", "Lio/outfoxx/swiftpoet/CodeBlock;", "getBody", "()Lio/outfoxx/swiftpoet/CodeBlock;", "doc", "getDoc", "failable", "getFailable", "isAccessor", "isConstructor", "isDeinitializer", "isObserver", "localTypeSpecs", "", "Lio/outfoxx/swiftpoet/AnyTypeSpec;", "getLocalTypeSpecs", "()Ljava/util/List;", "modifiers", "", "Lio/outfoxx/swiftpoet/Modifier;", "getModifiers", "()Ljava/util/Set;", "name", "", "getName", "()Ljava/lang/String;", "parameters", "", "Lio/outfoxx/swiftpoet/ParameterSpec;", "getParameters", "returnType", "Lio/outfoxx/swiftpoet/TypeName;", "getReturnType", "()Lio/outfoxx/swiftpoet/TypeName;", "signature", "Lio/outfoxx/swiftpoet/FunctionSignatureSpec;", "getSignature", "()Lio/outfoxx/swiftpoet/FunctionSignatureSpec;", "throws", "getThrows", "typeVariables", "Lio/outfoxx/swiftpoet/TypeVariableName;", "getTypeVariables", "emit", "", "codeWriter", "Lio/outfoxx/swiftpoet/CodeWriter;", "implicitModifiers", "conciseGetter", "emit$swiftpoet", "emitLocalTypes", "equals", "other", "", "hashCode", "", "toBuilder", "toString", "Builder", "Companion", "swiftpoet"})
public final class FunctionSpec
extends AttributedSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final CodeBlock doc;
    @NotNull
    private final Set<Modifier> modifiers;
    @NotNull
    private final FunctionSignatureSpec signature;
    @NotNull
    private final List<AnyTypeSpec> localTypeSpecs;
    @NotNull
    private final CodeBlock body;
    private final boolean isAccessor;
    @NotNull
    private static final String CONSTRUCTOR = "init";
    @NotNull
    private static final String DEINITIALIZER = "deinit";
    @NotNull
    private static final String OPERATOR = "op:";
    @NotNull
    public static final String GETTER = "get";
    @NotNull
    public static final String SETTER = "set";
    @NotNull
    public static final String WILL_SET = "willSet";
    @NotNull
    public static final String DID_SET = "didSet";

    private FunctionSpec(Builder builder) {
        super(UtilKt.toImmutableList((Collection)builder.getAttributes()), builder.getTags());
        this.name = builder.getName$swiftpoet();
        this.doc = builder.getDoc$swiftpoet().build();
        this.modifiers = UtilKt.toImmutableSet((Collection)builder.getModifiers$swiftpoet());
        this.signature = builder.getSignature$swiftpoet().build();
        this.localTypeSpecs = builder.getLocalTypeSpecs$swiftpoet();
        this.body = builder.getAbstract$swiftpoet() ? CodeBlock.Companion.getABSTRACT() : builder.getBody$swiftpoet().build();
        if (!(!Intrinsics.areEqual(this.name, SETTER) || this.signature.getParameters().size() <= 1)) {
            boolean bl = false;
            String string = this.name + " must have zero or one parameter";
            throw new IllegalArgumentException(string.toString());
        }
        this.isAccessor = builder.isAccessor$swiftpoet();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final CodeBlock getDoc() {
        return this.doc;
    }

    @NotNull
    public final Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    @NotNull
    public final FunctionSignatureSpec getSignature() {
        return this.signature;
    }

    @NotNull
    public final List<AnyTypeSpec> getLocalTypeSpecs() {
        return this.localTypeSpecs;
    }

    @NotNull
    public final CodeBlock getBody() {
        return this.body;
    }

    @NotNull
    public final List<TypeVariableName> getTypeVariables() {
        return UtilKt.toImmutableList((Collection)this.signature.getTypeVariables());
    }

    @Nullable
    public final TypeName getReturnType() {
        return this.signature.getReturnType();
    }

    @NotNull
    public final List<ParameterSpec> getParameters() {
        return UtilKt.toImmutableList((Collection)this.signature.getParameters());
    }

    public final boolean getThrows() {
        return this.signature.getThrows();
    }

    public final boolean getAsync() {
        return this.signature.getAsync();
    }

    public final boolean getFailable() {
        return this.signature.getFailable();
    }

    public final void emit$swiftpoet(@NotNull CodeWriter codeWriter, @NotNull Set<? extends Modifier> implicitModifiers, boolean conciseGetter) {
        Intrinsics.checkNotNullParameter(codeWriter, "codeWriter");
        Intrinsics.checkNotNullParameter(implicitModifiers, "implicitModifiers");
        if (Intrinsics.areEqual(this.name, GETTER) && conciseGetter && this.doc.isEmpty() && this.getAttributes().isEmpty() && this.modifiers.isEmpty()) {
            this.emitLocalTypes(codeWriter);
            CodeWriter.emitCode$default(codeWriter, this.body, false, 2, null);
            return;
        }
        codeWriter.emitDoc(this.doc);
        CodeWriter.emitAttributes$default(codeWriter, this.getAttributes(), null, null, 6, null);
        codeWriter.emitModifiers(this.modifiers, implicitModifiers);
        if (!(this.isConstructor() || this.isDeinitializer() || this.isAccessor || this.isObserver())) {
            codeWriter.emit("func ");
        }
        String name = this.isConstructor() || this.isDeinitializer() || this.isAccessor ? this.name : (Companion.isOperator$swiftpoet(this.name) ? StringsKt.removePrefix(this.name, (CharSequence)OPERATOR) : UtilKt.escapeIfNecessary(this.name));
        this.signature.emit$swiftpoet(codeWriter, name, this.isAccessor, !this.isDeinitializer() && !this.isAccessor && !this.isObserver());
        if (this.body != CodeBlock.Companion.getABSTRACT()) {
            codeWriter.emit(" {\n");
            CodeWriter.indent$default(codeWriter, 0, 1, null);
            this.emitLocalTypes(codeWriter);
            CodeWriter.emitCode$default(codeWriter, this.body, false, 2, null);
            CodeWriter.unindent$default(codeWriter, 0, 1, null);
            codeWriter.emit("}\n");
        }
    }

    public static /* synthetic */ void emit$swiftpoet$default(FunctionSpec functionSpec, CodeWriter codeWriter, Set set, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        functionSpec.emit$swiftpoet(codeWriter, set, bl);
    }

    private final void emitLocalTypes(CodeWriter codeWriter) {
        if (this.localTypeSpecs.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = this.localTypeSpecs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnyTypeSpec typeSpec = (AnyTypeSpec)element$iv;
            boolean bl = false;
            codeWriter.emit("\n");
            typeSpec.emit$swiftpoet(codeWriter);
        }
        codeWriter.emit("\n");
    }

    public final boolean isConstructor() {
        return Companion.isConstructor$swiftpoet(this.name);
    }

    public final boolean isDeinitializer() {
        return Companion.isDeinitializer$swiftpoet(this.name);
    }

    public final boolean isAccessor() {
        return this.isAccessor;
    }

    public final boolean isObserver() {
        return Companion.isObserver$swiftpoet(this.name);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        return Intrinsics.areEqual(this.toString(), other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Closeable closeable = new CodeWriter($this$toString_u24lambda_u243, null, null, null, null, 30, null);
        Throwable throwable = null;
        try {
            CodeWriter it = (CodeWriter)closeable;
            boolean bl2 = false;
            FunctionSpec.emit$swiftpoet$default(this, it, new TypeSpec.Kind.Class(new Modifier[0]).getImplicitFunctionModifiers$swiftpoet(), false, 4, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final Builder toBuilder() {
        Builder builder = new Builder(this.name);
        builder.getDoc$swiftpoet().add(this.doc);
        CollectionsKt.addAll((Collection)builder.getAttributes(), (Iterable)this.getAttributes());
        CollectionsKt.addAll((Collection)builder.getModifiers$swiftpoet(), (Iterable)this.modifiers);
        builder.setSignature$swiftpoet(this.signature.toBuilder());
        builder.getBody$swiftpoet().add(this.body);
        return builder;
    }

    @JvmStatic
    @NotNull
    public static final Builder builder(@NotNull String name) {
        return Companion.builder(name);
    }

    @JvmStatic
    @NotNull
    public static final Builder abstractBuilder(@NotNull String name) {
        return Companion.abstractBuilder(name);
    }

    @JvmStatic
    @NotNull
    public static final Builder constructorBuilder() {
        return Companion.constructorBuilder();
    }

    @JvmStatic
    @NotNull
    public static final Builder deinitializerBuilder() {
        return Companion.deinitializerBuilder();
    }

    @JvmStatic
    @NotNull
    public static final Builder getterBuilder() {
        return Companion.getterBuilder();
    }

    @JvmStatic
    @NotNull
    public static final Builder setterBuilder() {
        return Companion.setterBuilder();
    }

    @JvmStatic
    @NotNull
    public static final Builder willSetBuilder() {
        return Companion.willSetBuilder();
    }

    @JvmStatic
    @NotNull
    public static final Builder didSetBuilder() {
        return Companion.didSetBuilder();
    }

    @JvmStatic
    @NotNull
    public static final Builder operatorBuilder(@NotNull String name) {
        return Companion.operatorBuilder(name);
    }

    public /* synthetic */ FunctionSpec(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0006J\r\u0010%\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b&J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J'\u0010'\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00032\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0,\"\u00020-\u00a2\u0006\u0002\u0010.J'\u0010/\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00032\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0,\"\u00020-\u00a2\u0006\u0002\u0010.J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020)J'\u00100\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00032\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0,\"\u00020-\u00a2\u0006\u0002\u0010.J\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0016J\u0014\u00104\u001a\u00020\u00002\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001606J\u001f\u00107\u001a\u00020\u00002\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0,\"\u00020\u001a\u00a2\u0006\u0002\u00108J\u0014\u00107\u001a\u00020\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a06J \u00109\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00032\u0010\u0010+\u001a\f\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u00030:J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=J/\u0010;\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010>\u001a\u00020?2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0,\"\u00020\u001a\u00a2\u0006\u0002\u0010@J7\u0010;\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010>\u001a\u00020?2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0,\"\u00020\u001a\u00a2\u0006\u0002\u0010BJ\u0014\u0010C\u001a\u00020\u00002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020=06J'\u0010E\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00032\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0,\"\u00020-\u00a2\u0006\u0002\u0010.J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020HJ\u0014\u0010I\u001a\u00020\u00002\f\u0010J\u001a\b\u0012\u0004\u0012\u00020H06J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0006J/\u0010L\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u00032\u0006\u0010N\u001a\u00020\u00032\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0,\"\u00020-\u00a2\u0006\u0002\u0010OJ\u0006\u0010P\u001a\u00020QJ\u000e\u0010R\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u0003J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0006J3\u0010T\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u00032\u0006\u0010N\u001a\u00020\u00032\u0016\u0010+\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010-0,\"\u0004\u0018\u00010-\u00a2\u0006\u0002\u0010OJ\u000e\u0010U\u001a\u00020\u00002\u0006\u0010V\u001a\u00020?J\u000e\u0010W\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0006R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006X"}, d2={"Lio/outfoxx/swiftpoet/FunctionSpec$Builder;", "Lio/outfoxx/swiftpoet/AttributedSpec$Builder;", "name", "", "(Ljava/lang/String;)V", "abstract", "", "getAbstract$swiftpoet", "()Z", "setAbstract$swiftpoet", "(Z)V", "body", "Lio/outfoxx/swiftpoet/CodeBlock$Builder;", "getBody$swiftpoet", "()Lio/outfoxx/swiftpoet/CodeBlock$Builder;", "doc", "getDoc$swiftpoet", "isAccessor", "isAccessor$swiftpoet", "setAccessor$swiftpoet", "localTypeSpecs", "", "Lio/outfoxx/swiftpoet/AnyTypeSpec;", "getLocalTypeSpecs$swiftpoet", "()Ljava/util/List;", "modifiers", "Lio/outfoxx/swiftpoet/Modifier;", "getModifiers$swiftpoet", "getName$swiftpoet", "()Ljava/lang/String;", "signature", "Lio/outfoxx/swiftpoet/FunctionSignatureSpec$Builder;", "getSignature$swiftpoet", "()Lio/outfoxx/swiftpoet/FunctionSignatureSpec$Builder;", "setSignature$swiftpoet", "(Lio/outfoxx/swiftpoet/FunctionSignatureSpec$Builder;)V", "value", "accessor", "accessor$swiftpoet", "addCode", "codeBlock", "Lio/outfoxx/swiftpoet/CodeBlock;", "format", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lio/outfoxx/swiftpoet/FunctionSpec$Builder;", "addComment", "addDoc", "block", "addLocalType", "typeSpec", "addLocalTypes", "typeSpecs", "", "addModifiers", "([Lio/outfoxx/swiftpoet/Modifier;)Lio/outfoxx/swiftpoet/FunctionSpec$Builder;", "addNamedCode", "", "addParameter", "parameterSpec", "Lio/outfoxx/swiftpoet/ParameterSpec;", "type", "Lio/outfoxx/swiftpoet/TypeName;", "(Ljava/lang/String;Lio/outfoxx/swiftpoet/TypeName;[Lio/outfoxx/swiftpoet/Modifier;)Lio/outfoxx/swiftpoet/FunctionSpec$Builder;", "label", "(Ljava/lang/String;Ljava/lang/String;Lio/outfoxx/swiftpoet/TypeName;[Lio/outfoxx/swiftpoet/Modifier;)Lio/outfoxx/swiftpoet/FunctionSpec$Builder;", "addParameters", "parameterSpecs", "addStatement", "addTypeVariable", "typeVariable", "Lio/outfoxx/swiftpoet/TypeVariableName;", "addTypeVariables", "typeVariables", "async", "beginControlFlow", "controlFlowName", "controlFlowCode", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lio/outfoxx/swiftpoet/FunctionSpec$Builder;", "build", "Lio/outfoxx/swiftpoet/FunctionSpec;", "endControlFlow", "failable", "nextControlFlow", "returns", "returnType", "throws", "swiftpoet"})
    public static final class Builder
    extends AttributedSpec.Builder<Builder> {
        @NotNull
        private final String name;
        @NotNull
        private final CodeBlock.Builder doc;
        @NotNull
        private final List<Modifier> modifiers;
        @NotNull
        private FunctionSignatureSpec.Builder signature;
        @NotNull
        private final List<AnyTypeSpec> localTypeSpecs;
        @NotNull
        private final CodeBlock.Builder body;
        private boolean abstract;
        private boolean isAccessor;

        public Builder(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.name = name;
            this.doc = CodeBlock.Companion.builder();
            this.modifiers = new ArrayList();
            this.signature = FunctionSignatureSpec.Companion.builder();
            this.localTypeSpecs = new ArrayList();
            this.body = CodeBlock.Companion.builder();
        }

        @NotNull
        public final String getName$swiftpoet() {
            return this.name;
        }

        @NotNull
        public final CodeBlock.Builder getDoc$swiftpoet() {
            return this.doc;
        }

        @NotNull
        public final List<Modifier> getModifiers$swiftpoet() {
            return this.modifiers;
        }

        @NotNull
        public final FunctionSignatureSpec.Builder getSignature$swiftpoet() {
            return this.signature;
        }

        public final void setSignature$swiftpoet(@NotNull FunctionSignatureSpec.Builder builder) {
            Intrinsics.checkNotNullParameter(builder, "<set-?>");
            this.signature = builder;
        }

        @NotNull
        public final List<AnyTypeSpec> getLocalTypeSpecs$swiftpoet() {
            return this.localTypeSpecs;
        }

        @NotNull
        public final CodeBlock.Builder getBody$swiftpoet() {
            return this.body;
        }

        public final boolean getAbstract$swiftpoet() {
            return this.abstract;
        }

        public final void setAbstract$swiftpoet(boolean bl) {
            this.abstract = bl;
        }

        public final boolean isAccessor$swiftpoet() {
            return this.isAccessor;
        }

        public final void setAccessor$swiftpoet(boolean bl) {
            this.isAccessor = bl;
        }

        @NotNull
        public final Builder accessor$swiftpoet() {
            Builder builder;
            Builder $this$accessor_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$accessor_u24lambda_u240.isAccessor = true;
            return builder;
        }

        @NotNull
        public final Builder addDoc(@NotNull String format, Object ... args2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(format, "format");
            Intrinsics.checkNotNullParameter(args2, "args");
            Builder $this$addDoc_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$addDoc_u24lambda_u241.doc.add(format, Arrays.copyOf(args2, args2.length));
            return builder;
        }

        @NotNull
        public final Builder addDoc(@NotNull CodeBlock block) {
            Builder builder;
            Intrinsics.checkNotNullParameter(block, "block");
            Builder $this$addDoc_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$addDoc_u24lambda_u242.doc.add(block);
            return builder;
        }

        @NotNull
        public final Builder addModifiers(Modifier ... modifiers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(modifiers, "modifiers");
            Builder $this$addModifiers_u24lambda_u244 = builder = this;
            boolean bl = false;
            if (!(!UtilKt.isOneOf$default($this$addModifiers_u24lambda_u244.name, FunctionSpec.WILL_SET, FunctionSpec.DID_SET, null, null, null, null, 60, null))) {
                boolean bl2 = false;
                String string = "observers cannot have modifiers";
                throw new IllegalStateException(string.toString());
            }
            CollectionsKt.addAll((Collection)$this$addModifiers_u24lambda_u244.modifiers, modifiers);
            return builder;
        }

        @NotNull
        public final Builder addModifiers(@NotNull Iterable<? extends Modifier> modifiers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(modifiers, "modifiers");
            Builder $this$addModifiers_u24lambda_u246 = builder = this;
            boolean bl = false;
            if (!(!UtilKt.isOneOf$default($this$addModifiers_u24lambda_u246.name, FunctionSpec.WILL_SET, FunctionSpec.DID_SET, null, null, null, null, 60, null))) {
                boolean bl2 = false;
                String string = "observers cannot have modifiers";
                throw new IllegalStateException(string.toString());
            }
            CollectionsKt.addAll((Collection)$this$addModifiers_u24lambda_u246.modifiers, modifiers);
            return builder;
        }

        @NotNull
        public final Builder addTypeVariables(@NotNull Iterable<TypeVariableName> typeVariables) {
            Builder builder;
            Intrinsics.checkNotNullParameter(typeVariables, "typeVariables");
            Builder $this$addTypeVariables_u24lambda_u248 = builder = this;
            boolean bl = false;
            if (!(!Companion.isAccessor$swiftpoet($this$addTypeVariables_u24lambda_u248.name))) {
                boolean bl2 = false;
                String string = $this$addTypeVariables_u24lambda_u248.name + " cannot have type variables";
                throw new IllegalStateException(string.toString());
            }
            CollectionsKt.addAll((Collection)$this$addTypeVariables_u24lambda_u248.signature.getTypeVariables$swiftpoet(), typeVariables);
            return builder;
        }

        @NotNull
        public final Builder addTypeVariable(@NotNull TypeVariableName typeVariable) {
            Builder builder;
            Intrinsics.checkNotNullParameter(typeVariable, "typeVariable");
            Builder $this$addTypeVariable_u24lambda_u2410 = builder = this;
            boolean bl = false;
            if (!(!Companion.isAccessor$swiftpoet($this$addTypeVariable_u24lambda_u2410.name))) {
                boolean bl2 = false;
                String string = $this$addTypeVariable_u24lambda_u2410.name + " cannot have type variables";
                throw new IllegalStateException(string.toString());
            }
            ((Collection)$this$addTypeVariable_u24lambda_u2410.signature.getTypeVariables$swiftpoet()).add(typeVariable);
            return builder;
        }

        @NotNull
        public final Builder returns(@NotNull TypeName returnType) {
            Builder builder;
            Intrinsics.checkNotNullParameter(returnType, "returnType");
            Builder $this$returns_u24lambda_u2412 = builder = this;
            boolean bl = false;
            if (!(!Companion.isConstructor$swiftpoet($this$returns_u24lambda_u2412.name) && !Companion.isAccessor$swiftpoet($this$returns_u24lambda_u2412.name))) {
                boolean bl2 = false;
                String string = $this$returns_u24lambda_u2412.name + " cannot have a return type";
                throw new IllegalStateException(string.toString());
            }
            $this$returns_u24lambda_u2412.signature.setReturnType$swiftpoet(returnType);
            return builder;
        }

        @NotNull
        public final Builder addParameters(@NotNull Iterable<ParameterSpec> parameterSpecs) {
            Builder builder;
            Intrinsics.checkNotNullParameter(parameterSpecs, "parameterSpecs");
            Builder $this$addParameters_u24lambda_u2413 = builder = this;
            boolean bl = false;
            for (ParameterSpec parameterSpec : parameterSpecs) {
                $this$addParameters_u24lambda_u2413.addParameter(parameterSpec);
            }
            return builder;
        }

        @NotNull
        public final Builder addParameter(@NotNull ParameterSpec parameterSpec) {
            Builder builder;
            Intrinsics.checkNotNullParameter(parameterSpec, "parameterSpec");
            Builder $this$addParameter_u24lambda_u2416 = builder = this;
            boolean bl = false;
            if (!(!Intrinsics.areEqual($this$addParameter_u24lambda_u2416.name, FunctionSpec.GETTER))) {
                boolean $i$a$-check-FunctionSpec$Builder$addParameter$1$32 = false;
                String $i$a$-check-FunctionSpec$Builder$addParameter$1$32 = $this$addParameter_u24lambda_u2416.name + " cannot have parameters";
                throw new IllegalStateException($i$a$-check-FunctionSpec$Builder$addParameter$1$32.toString());
            }
            if (!(!UtilKt.isOneOf$default($this$addParameter_u24lambda_u2416.name, FunctionSpec.SETTER, FunctionSpec.WILL_SET, FunctionSpec.DID_SET, null, null, null, 56, null) || $this$addParameter_u24lambda_u2416.signature.getParameters$swiftpoet().size() == 0)) {
                boolean bl2 = false;
                String string = $this$addParameter_u24lambda_u2416.name + " can have only one parameter";
                throw new IllegalStateException(string.toString());
            }
            ((Collection)$this$addParameter_u24lambda_u2416.signature.getParameters$swiftpoet()).add(parameterSpec);
            return builder;
        }

        @NotNull
        public final Builder addParameter(@NotNull String name, @NotNull TypeName type, Modifier ... modifiers) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(type, "type");
            Intrinsics.checkNotNullParameter(modifiers, "modifiers");
            return this.addParameter(ParameterSpec.Companion.builder(name, type, Arrays.copyOf(modifiers, modifiers.length)).build());
        }

        @NotNull
        public final Builder addParameter(@NotNull String label, @NotNull String name, @NotNull TypeName type, Modifier ... modifiers) {
            Intrinsics.checkNotNullParameter(label, "label");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(type, "type");
            Intrinsics.checkNotNullParameter(modifiers, "modifiers");
            return this.addParameter(ParameterSpec.Companion.builder(label, name, type, Arrays.copyOf(modifiers, modifiers.length)).build());
        }

        @NotNull
        public final Builder addCode(@NotNull String format, Object ... args2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(format, "format");
            Intrinsics.checkNotNullParameter(args2, "args");
            Builder $this$addCode_u24lambda_u2417 = builder = this;
            boolean bl = false;
            $this$addCode_u24lambda_u2417.body.add(format, Arrays.copyOf(args2, args2.length));
            return builder;
        }

        @NotNull
        public final Builder abstract(boolean value) {
            Builder builder;
            Builder $this$abstract_u24lambda_u2419 = builder = this;
            boolean bl = false;
            if (!$this$abstract_u24lambda_u2419.body.isEmpty()) {
                boolean bl2 = false;
                String string = "function with code cannot be abstract";
                throw new IllegalStateException(string.toString());
            }
            $this$abstract_u24lambda_u2419.abstract = value;
            return builder;
        }

        @NotNull
        public final Builder failable(boolean value) {
            Builder builder;
            Builder $this$failable_u24lambda_u2421 = builder = this;
            boolean bl = false;
            if (!Companion.isConstructor$swiftpoet($this$failable_u24lambda_u2421.name)) {
                boolean bl2 = false;
                String string = "only constructors can be failable";
                throw new IllegalStateException(string.toString());
            }
            $this$failable_u24lambda_u2421.signature.setFailable$swiftpoet(value);
            return builder;
        }

        @NotNull
        public final Builder throws(boolean value) {
            Builder builder;
            Builder $this$throws_u24lambda_u2422 = builder = this;
            boolean bl = false;
            $this$throws_u24lambda_u2422.signature.setThrows$swiftpoet(value);
            return builder;
        }

        @NotNull
        public final Builder async(boolean value) {
            Builder builder;
            Builder $this$async_u24lambda_u2423 = builder = this;
            boolean bl = false;
            $this$async_u24lambda_u2423.signature.setAsync$swiftpoet(value);
            return builder;
        }

        @NotNull
        public final Builder addLocalTypes(@NotNull Iterable<? extends AnyTypeSpec> typeSpecs) {
            Builder builder;
            Intrinsics.checkNotNullParameter(typeSpecs, "typeSpecs");
            Builder $this$addLocalTypes_u24lambda_u2425 = builder = this;
            boolean bl = false;
            if (!(!$this$addLocalTypes_u24lambda_u2425.abstract)) {
                boolean bl2 = false;
                String string = "abstract functions cannot have local types";
                throw new IllegalStateException(string.toString());
            }
            CollectionsKt.addAll((Collection)$this$addLocalTypes_u24lambda_u2425.localTypeSpecs, typeSpecs);
            return builder;
        }

        @NotNull
        public final Builder addLocalType(@NotNull AnyTypeSpec typeSpec) {
            Builder builder;
            Intrinsics.checkNotNullParameter(typeSpec, "typeSpec");
            Builder $this$addLocalType_u24lambda_u2426 = builder = this;
            boolean bl = false;
            ((Collection)$this$addLocalType_u24lambda_u2426.localTypeSpecs).add(typeSpec);
            return builder;
        }

        @NotNull
        public final Builder addNamedCode(@NotNull String format, @NotNull Map<String, ?> args2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(format, "format");
            Intrinsics.checkNotNullParameter(args2, "args");
            Builder $this$addNamedCode_u24lambda_u2428 = builder = this;
            boolean bl = false;
            if (!(!$this$addNamedCode_u24lambda_u2428.abstract)) {
                boolean bl2 = false;
                String string = "abstract functions cannot have code";
                throw new IllegalStateException(string.toString());
            }
            $this$addNamedCode_u24lambda_u2428.body.addNamed(format, args2);
            return builder;
        }

        @NotNull
        public final Builder addCode(@NotNull CodeBlock codeBlock) {
            Builder builder;
            Intrinsics.checkNotNullParameter(codeBlock, "codeBlock");
            Builder $this$addCode_u24lambda_u2430 = builder = this;
            boolean bl = false;
            if (!(!$this$addCode_u24lambda_u2430.abstract)) {
                boolean bl2 = false;
                String string = "abstract functions cannot have code";
                throw new IllegalStateException(string.toString());
            }
            $this$addCode_u24lambda_u2430.body.add(codeBlock);
            return builder;
        }

        @NotNull
        public final Builder addComment(@NotNull String format, Object ... args2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(format, "format");
            Intrinsics.checkNotNullParameter(args2, "args");
            Builder $this$addComment_u24lambda_u2431 = builder = this;
            boolean bl = false;
            $this$addComment_u24lambda_u2431.body.add("// " + format + '\n', Arrays.copyOf(args2, args2.length));
            return builder;
        }

        @NotNull
        public final Builder beginControlFlow(@NotNull String controlFlowName, @NotNull String controlFlowCode, Object ... args2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(controlFlowName, "controlFlowName");
            Intrinsics.checkNotNullParameter(controlFlowCode, "controlFlowCode");
            Intrinsics.checkNotNullParameter(args2, "args");
            Builder $this$beginControlFlow_u24lambda_u2432 = builder = this;
            boolean bl = false;
            $this$beginControlFlow_u24lambda_u2432.body.beginControlFlow(controlFlowName, controlFlowCode, Arrays.copyOf(args2, args2.length));
            return builder;
        }

        @NotNull
        public final Builder nextControlFlow(@NotNull String controlFlowName, @NotNull String controlFlowCode, Object ... args2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(controlFlowName, "controlFlowName");
            Intrinsics.checkNotNullParameter(controlFlowCode, "controlFlowCode");
            Intrinsics.checkNotNullParameter(args2, "args");
            Builder $this$nextControlFlow_u24lambda_u2433 = builder = this;
            boolean bl = false;
            $this$nextControlFlow_u24lambda_u2433.body.nextControlFlow(controlFlowName, controlFlowCode, Arrays.copyOf(args2, args2.length));
            return builder;
        }

        @NotNull
        public final Builder endControlFlow(@NotNull String controlFlowName) {
            Builder builder;
            Intrinsics.checkNotNullParameter(controlFlowName, "controlFlowName");
            Builder $this$endControlFlow_u24lambda_u2434 = builder = this;
            boolean bl = false;
            $this$endControlFlow_u24lambda_u2434.body.endControlFlow(controlFlowName);
            return builder;
        }

        @NotNull
        public final Builder addStatement(@NotNull String format, Object ... args2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(format, "format");
            Intrinsics.checkNotNullParameter(args2, "args");
            Builder $this$addStatement_u24lambda_u2435 = builder = this;
            boolean bl = false;
            $this$addStatement_u24lambda_u2435.body.addStatement(format, Arrays.copyOf(args2, args2.length));
            return builder;
        }

        @NotNull
        public final FunctionSpec build() {
            return new FunctionSpec(this, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\b\u0010\u001b\u001a\u00020\u0018H\u0007J\b\u0010\u001c\u001a\u00020\u0018H\u0007J\b\u0010\u001d\u001a\u00020\u0018H\u0007J\b\u0010\u001e\u001a\u00020\u0018H\u0007J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\b\u0010 \u001a\u00020\u0018H\u0007J\b\u0010!\u001a\u00020\u0018H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\f*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0018\u0010\u0011\u001a\u00020\f*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0018\u0010\u0013\u001a\u00020\f*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0018\u0010\u0015\u001a\u00020\f*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\""}, d2={"Lio/outfoxx/swiftpoet/FunctionSpec$Companion;", "", "()V", "CONSTRUCTOR", "", "DEINITIALIZER", "DID_SET", "GETTER", "OPERATOR", "SETTER", "WILL_SET", "isAccessor", "", "isAccessor$swiftpoet", "(Ljava/lang/String;)Z", "isConstructor", "isConstructor$swiftpoet", "isDeinitializer", "isDeinitializer$swiftpoet", "isObserver", "isObserver$swiftpoet", "isOperator", "isOperator$swiftpoet", "abstractBuilder", "Lio/outfoxx/swiftpoet/FunctionSpec$Builder;", "name", "builder", "constructorBuilder", "deinitializerBuilder", "didSetBuilder", "getterBuilder", "operatorBuilder", "setterBuilder", "willSetBuilder", "swiftpoet"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isConstructor$swiftpoet(@NotNull String $this$isConstructor) {
            Intrinsics.checkNotNullParameter($this$isConstructor, "<this>");
            return Intrinsics.areEqual($this$isConstructor, FunctionSpec.CONSTRUCTOR);
        }

        public final boolean isDeinitializer$swiftpoet(@NotNull String $this$isDeinitializer) {
            Intrinsics.checkNotNullParameter($this$isDeinitializer, "<this>");
            return Intrinsics.areEqual($this$isDeinitializer, FunctionSpec.DEINITIALIZER);
        }

        public final boolean isAccessor$swiftpoet(@NotNull String $this$isAccessor) {
            Intrinsics.checkNotNullParameter($this$isAccessor, "<this>");
            return UtilKt.isOneOf$default($this$isAccessor, FunctionSpec.GETTER, FunctionSpec.SETTER, null, null, null, null, 60, null);
        }

        public final boolean isObserver$swiftpoet(@NotNull String $this$isObserver) {
            Intrinsics.checkNotNullParameter($this$isObserver, "<this>");
            return UtilKt.isOneOf$default($this$isObserver, FunctionSpec.WILL_SET, FunctionSpec.DID_SET, null, null, null, null, 60, null);
        }

        public final boolean isOperator$swiftpoet(@NotNull String $this$isOperator) {
            Intrinsics.checkNotNullParameter($this$isOperator, "<this>");
            return StringsKt.startsWith$default($this$isOperator, FunctionSpec.OPERATOR, false, 2, null);
        }

        @JvmStatic
        @NotNull
        public final Builder builder(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return new Builder(name);
        }

        @JvmStatic
        @NotNull
        public final Builder abstractBuilder(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return new Builder(name).abstract(true);
        }

        @JvmStatic
        @NotNull
        public final Builder constructorBuilder() {
            return new Builder(FunctionSpec.CONSTRUCTOR);
        }

        @JvmStatic
        @NotNull
        public final Builder deinitializerBuilder() {
            return new Builder(FunctionSpec.DEINITIALIZER);
        }

        @JvmStatic
        @NotNull
        public final Builder getterBuilder() {
            return new Builder(FunctionSpec.GETTER).accessor$swiftpoet();
        }

        @JvmStatic
        @NotNull
        public final Builder setterBuilder() {
            return new Builder(FunctionSpec.SETTER).accessor$swiftpoet();
        }

        @JvmStatic
        @NotNull
        public final Builder willSetBuilder() {
            return new Builder(FunctionSpec.WILL_SET);
        }

        @JvmStatic
        @NotNull
        public final Builder didSetBuilder() {
            return new Builder(FunctionSpec.DID_SET);
        }

        @JvmStatic
        @NotNull
        public final Builder operatorBuilder(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return new Builder(FunctionSpec.OPERATOR + name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

