/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.MeterConfig;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorageRegistry;
import io.opentelemetry.sdk.metrics.internal.state.MultiWritableMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.SdkObservableMeasurement;
import io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MeterSharedState {
    private final Object collectLock = new Object();
    private final Object callbackLock = new Object();
    private final List<CallbackRegistration> callbackRegistrations = new ArrayList<CallbackRegistration>();
    private final Map<RegisteredReader, MetricStorageRegistry> readerStorageRegistries;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final boolean meterEnabled;

    private MeterSharedState(InstrumentationScopeInfo instrumentationScopeInfo, List<RegisteredReader> registeredReaders, MeterConfig meterConfig) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.readerStorageRegistries = registeredReaders.stream().collect(Collectors.toMap(Function.identity(), unused -> new MetricStorageRegistry()));
        this.meterEnabled = meterConfig.isEnabled();
    }

    public static MeterSharedState create(InstrumentationScopeInfo instrumentationScopeInfo, List<RegisteredReader> registeredReaders, MeterConfig meterConfig) {
        return new MeterSharedState(instrumentationScopeInfo, registeredReaders, meterConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(CallbackRegistration callbackRegistration) {
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackRegistrations.remove(callbackRegistration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerCallback(CallbackRegistration callbackRegistration) {
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackRegistrations.add(callbackRegistration);
        }
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    public boolean isMeterEnabled() {
        return this.meterEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetricData> collectAll(RegisteredReader registeredReader, MeterProviderSharedState meterProviderSharedState, long epochNanos) {
        ArrayList<CallbackRegistration> currentRegisteredCallbacks;
        if (!this.meterEnabled) {
            return Collections.emptyList();
        }
        Object object = this.callbackLock;
        synchronized (object) {
            currentRegisteredCallbacks = new ArrayList<CallbackRegistration>(this.callbackRegistrations);
        }
        object = this.collectLock;
        synchronized (object) {
            for (CallbackRegistration callbackRegistration : currentRegisteredCallbacks) {
                callbackRegistration.invokeCallback(registeredReader, meterProviderSharedState.getStartEpochNanos(), epochNanos);
            }
            Collection<MetricStorage> storages = Objects.requireNonNull(this.readerStorageRegistries.get(registeredReader)).getStorages();
            ArrayList<MetricData> result2 = new ArrayList<MetricData>(storages.size());
            for (MetricStorage storage : storages) {
                MetricData current = storage.collect(meterProviderSharedState.getResource(), this.getInstrumentationScopeInfo(), meterProviderSharedState.getStartEpochNanos(), epochNanos);
                if (current.isEmpty()) continue;
                result2.add(current);
            }
            return Collections.unmodifiableList(result2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetForTest() {
        Object object = this.collectLock;
        synchronized (object) {
            Object object2 = this.callbackLock;
            synchronized (object2) {
                this.callbackRegistrations.clear();
            }
            this.readerStorageRegistries.values().forEach(MetricStorageRegistry::resetForTest);
        }
    }

    public final WriteableMetricStorage registerSynchronousMetricStorage(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState) {
        ArrayList<SynchronousMetricStorage> registeredStorages = new ArrayList<SynchronousMetricStorage>();
        for (Map.Entry<RegisteredReader, MetricStorageRegistry> entry : this.readerStorageRegistries.entrySet()) {
            RegisteredReader reader = entry.getKey();
            MetricStorageRegistry registry = entry.getValue();
            for (RegisteredView registeredView : reader.getViewRegistry().findViews(instrument, this.getInstrumentationScopeInfo())) {
                if (Aggregation.drop() == registeredView.getView().getAggregation()) continue;
                registeredStorages.add(registry.register(SynchronousMetricStorage.create(reader, registeredView, instrument, meterProviderSharedState.getExemplarFilter())));
            }
        }
        if (registeredStorages.size() == 1) {
            return (WriteableMetricStorage)registeredStorages.get(0);
        }
        return new MultiWritableMetricStorage(registeredStorages);
    }

    public final SdkObservableMeasurement registerObservableMeasurement(InstrumentDescriptor instrumentDescriptor) {
        ArrayList registeredStorages = new ArrayList();
        for (Map.Entry<RegisteredReader, MetricStorageRegistry> entry : this.readerStorageRegistries.entrySet()) {
            RegisteredReader reader = entry.getKey();
            MetricStorageRegistry registry = entry.getValue();
            for (RegisteredView registeredView : reader.getViewRegistry().findViews(instrumentDescriptor, this.getInstrumentationScopeInfo())) {
                if (Aggregation.drop() == registeredView.getView().getAggregation()) continue;
                registeredStorages.add(registry.register(AsynchronousMetricStorage.create(reader, registeredView, instrumentDescriptor)));
            }
        }
        return SdkObservableMeasurement.create(this.instrumentationScopeInfo, instrumentDescriptor, registeredStorages);
    }
}

