/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.descriptor;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregationUtil;
import io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import io.opentelemetry.sdk.metrics.internal.descriptor.AutoValue_MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MetricDescriptor {
    private final AtomicReference<SourceInfo> viewSourceInfo = new AtomicReference();
    private int hashcode;

    public static MetricDescriptor create(String name, String description, String unit) {
        return MetricDescriptor.create(View.builder().build(), SourceInfo.fromCurrentStack(), InstrumentDescriptor.create(name, description, unit, InstrumentType.OBSERVABLE_GAUGE, InstrumentValueType.DOUBLE, Advice.empty()));
    }

    public static MetricDescriptor create(View view, SourceInfo viewSourceInfo, InstrumentDescriptor instrument) {
        String name = view.getName() == null ? instrument.getName() : view.getName();
        String description = view.getDescription() == null ? instrument.getDescription() : view.getDescription();
        AutoValue_MetricDescriptor metricDescriptor = new AutoValue_MetricDescriptor(name, description, view, instrument);
        metricDescriptor.viewSourceInfo.set(viewSourceInfo);
        return metricDescriptor;
    }

    MetricDescriptor() {
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract View getView();

    public final SourceInfo getViewSourceInfo() {
        SourceInfo sourceInfo = this.viewSourceInfo.get();
        return sourceInfo == null ? SourceInfo.noSourceInfo() : sourceInfo;
    }

    public abstract InstrumentDescriptor getSourceInstrument();

    public String getAggregationName() {
        return AggregationUtil.aggregationName(this.getView().getAggregation());
    }

    public final int hashCode() {
        int result2 = this.hashcode;
        if (result2 == 0) {
            result2 = 1;
            result2 *= 1000003;
            result2 ^= this.getName().toLowerCase(Locale.ROOT).hashCode();
            result2 *= 1000003;
            result2 ^= this.getDescription().hashCode();
            result2 *= 1000003;
            result2 ^= this.getView().hashCode();
            result2 *= 1000003;
            this.hashcode = result2 ^= this.getSourceInstrument().hashCode();
        }
        return result2;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MetricDescriptor) {
            MetricDescriptor that = (MetricDescriptor)o;
            return this.getName().equalsIgnoreCase(that.getName()) && this.getDescription().equals(that.getDescription()) && this.getView().equals(that.getView()) && this.getSourceInstrument().equals(that.getSourceInstrument());
        }
        return false;
    }
}

