/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.http;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterMetrics;
import io.opentelemetry.exporter.internal.grpc.GrpcExporterUtil;
import io.opentelemetry.exporter.internal.http.HttpSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class HttpExporter<T extends Marshaler> {
    private static final Logger internalLogger = Logger.getLogger(HttpExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final String type;
    private final HttpSender httpSender;
    private final ExporterMetrics exporterMetrics;

    public HttpExporter(String exporterName, String type, HttpSender httpSender, Supplier<MeterProvider> meterProviderSupplier, boolean exportAsJson) {
        this.type = type;
        this.httpSender = httpSender;
        this.exporterMetrics = exportAsJson ? ExporterMetrics.createHttpJson(exporterName, type, meterProviderSupplier) : ExporterMetrics.createHttpProtobuf(exporterName, type, meterProviderSupplier);
    }

    public CompletableResultCode export(T exportRequest, int numItems) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        this.exporterMetrics.addSeen(numItems);
        CompletableResultCode result2 = new CompletableResultCode();
        this.httpSender.send((Marshaler)exportRequest, ((Marshaler)exportRequest).getBinarySerializedSize(), httpResponse -> {
            int statusCode = httpResponse.statusCode();
            if (statusCode >= 200 && statusCode < 300) {
                this.exporterMetrics.addSuccess(numItems);
                result2.succeed();
                return;
            }
            this.exporterMetrics.addFailed(numItems);
            byte[] body = null;
            try {
                body = httpResponse.responseBody();
            }
            catch (IOException ex) {
                this.logger.log(Level.FINE, "Unable to obtain response body", ex);
            }
            String status = HttpExporter.extractErrorStatus(httpResponse.statusMessage(), body);
            this.logger.log(Level.WARNING, "Failed to export " + this.type + "s. Server responded with HTTP status code " + statusCode + ". Error message: " + status);
            result2.fail();
        }, e -> {
            this.exporterMetrics.addFailed(numItems);
            this.logger.log(Level.SEVERE, "Failed to export " + this.type + "s. The request could not be executed. Full error message: " + e.getMessage(), (Throwable)e);
            result2.fail();
        });
        return result2;
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.httpSender.shutdown();
    }

    private static String extractErrorStatus(String statusMessage, @Nullable byte[] responseBody) {
        if (responseBody == null) {
            return "Response body missing, HTTP status message: " + statusMessage;
        }
        try {
            return GrpcExporterUtil.getStatusMessage(responseBody);
        }
        catch (IOException e) {
            return "Unable to parse response body, HTTP status message: " + statusMessage;
        }
    }
}

