/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.diskbuffering.proto.trace.v1;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.diskbuffering.proto.common.v1.KeyValue;
import io.opentelemetry.diskbuffering.proto.trace.v1.Status;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

public final class Span
extends Message<Span, Builder> {
    public static final ProtoAdapter<Span> ADAPTER = new ProtoAdapter_Span();
    private static final long serialVersionUID = 0L;
    @WireField(tag=1, adapter="com.squareup.wire.ProtoAdapter#BYTES", label=WireField.Label.OMIT_IDENTITY, jsonName="traceId")
    public final ByteString trace_id;
    @WireField(tag=2, adapter="com.squareup.wire.ProtoAdapter#BYTES", label=WireField.Label.OMIT_IDENTITY, jsonName="spanId")
    public final ByteString span_id;
    @WireField(tag=3, adapter="com.squareup.wire.ProtoAdapter#STRING", label=WireField.Label.OMIT_IDENTITY, jsonName="traceState")
    public final String trace_state;
    @WireField(tag=4, adapter="com.squareup.wire.ProtoAdapter#BYTES", label=WireField.Label.OMIT_IDENTITY, jsonName="parentSpanId")
    public final ByteString parent_span_id;
    @WireField(tag=16, adapter="com.squareup.wire.ProtoAdapter#FIXED32", label=WireField.Label.OMIT_IDENTITY)
    public final int flags;
    @WireField(tag=5, adapter="com.squareup.wire.ProtoAdapter#STRING", label=WireField.Label.OMIT_IDENTITY)
    public final String name;
    @WireField(tag=6, adapter="io.opentelemetry.diskbuffering.proto.trace.v1.Span$SpanKind#ADAPTER", label=WireField.Label.OMIT_IDENTITY)
    public final SpanKind kind;
    @WireField(tag=7, adapter="com.squareup.wire.ProtoAdapter#FIXED64", label=WireField.Label.OMIT_IDENTITY, jsonName="startTimeUnixNano")
    public final long start_time_unix_nano;
    @WireField(tag=8, adapter="com.squareup.wire.ProtoAdapter#FIXED64", label=WireField.Label.OMIT_IDENTITY, jsonName="endTimeUnixNano")
    public final long end_time_unix_nano;
    @WireField(tag=9, adapter="io.opentelemetry.diskbuffering.proto.common.v1.KeyValue#ADAPTER", label=WireField.Label.REPEATED)
    public final List<KeyValue> attributes;
    @WireField(tag=10, adapter="com.squareup.wire.ProtoAdapter#UINT32", label=WireField.Label.OMIT_IDENTITY, jsonName="droppedAttributesCount")
    public final int dropped_attributes_count;
    @WireField(tag=11, adapter="io.opentelemetry.diskbuffering.proto.trace.v1.Span$Event#ADAPTER", label=WireField.Label.REPEATED)
    public final List<Event> events;
    @WireField(tag=12, adapter="com.squareup.wire.ProtoAdapter#UINT32", label=WireField.Label.OMIT_IDENTITY, jsonName="droppedEventsCount")
    public final int dropped_events_count;
    @WireField(tag=13, adapter="io.opentelemetry.diskbuffering.proto.trace.v1.Span$Link#ADAPTER", label=WireField.Label.REPEATED)
    public final List<Link> links;
    @WireField(tag=14, adapter="com.squareup.wire.ProtoAdapter#UINT32", label=WireField.Label.OMIT_IDENTITY, jsonName="droppedLinksCount")
    public final int dropped_links_count;
    @WireField(tag=15, adapter="io.opentelemetry.diskbuffering.proto.trace.v1.Status#ADAPTER", label=WireField.Label.OMIT_IDENTITY)
    public final Status status;

    public Span(Builder builder, ByteString unknownFields) {
        super(ADAPTER, unknownFields);
        if (builder.trace_id == null) {
            throw new IllegalArgumentException("builder.trace_id == null");
        }
        this.trace_id = builder.trace_id;
        if (builder.span_id == null) {
            throw new IllegalArgumentException("builder.span_id == null");
        }
        this.span_id = builder.span_id;
        if (builder.trace_state == null) {
            throw new IllegalArgumentException("builder.trace_state == null");
        }
        this.trace_state = builder.trace_state;
        if (builder.parent_span_id == null) {
            throw new IllegalArgumentException("builder.parent_span_id == null");
        }
        this.parent_span_id = builder.parent_span_id;
        this.flags = builder.flags;
        if (builder.name == null) {
            throw new IllegalArgumentException("builder.name == null");
        }
        this.name = builder.name;
        if (builder.kind == null) {
            throw new IllegalArgumentException("builder.kind == null");
        }
        this.kind = builder.kind;
        this.start_time_unix_nano = builder.start_time_unix_nano;
        this.end_time_unix_nano = builder.end_time_unix_nano;
        this.attributes = Internal.immutableCopyOf("attributes", builder.attributes);
        this.dropped_attributes_count = builder.dropped_attributes_count;
        this.events = Internal.immutableCopyOf("events", builder.events);
        this.dropped_events_count = builder.dropped_events_count;
        this.links = Internal.immutableCopyOf("links", builder.links);
        this.dropped_links_count = builder.dropped_links_count;
        this.status = builder.status;
    }

    @Override
    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.trace_id = this.trace_id;
        builder.span_id = this.span_id;
        builder.trace_state = this.trace_state;
        builder.parent_span_id = this.parent_span_id;
        builder.flags = this.flags;
        builder.name = this.name;
        builder.kind = this.kind;
        builder.start_time_unix_nano = this.start_time_unix_nano;
        builder.end_time_unix_nano = this.end_time_unix_nano;
        builder.attributes = Internal.copyOf(this.attributes);
        builder.dropped_attributes_count = this.dropped_attributes_count;
        builder.events = Internal.copyOf(this.events);
        builder.dropped_events_count = this.dropped_events_count;
        builder.links = Internal.copyOf(this.links);
        builder.dropped_links_count = this.dropped_links_count;
        builder.status = this.status;
        builder.addUnknownFields(this.unknownFields());
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Span)) {
            return false;
        }
        Span o = (Span)other;
        return this.unknownFields().equals(o.unknownFields()) && Internal.equals(this.trace_id, o.trace_id) && Internal.equals(this.span_id, o.span_id) && Internal.equals(this.trace_state, o.trace_state) && Internal.equals(this.parent_span_id, o.parent_span_id) && Internal.equals(this.flags, o.flags) && Internal.equals(this.name, o.name) && Internal.equals(this.kind, o.kind) && Internal.equals(this.start_time_unix_nano, o.start_time_unix_nano) && Internal.equals(this.end_time_unix_nano, o.end_time_unix_nano) && this.attributes.equals(o.attributes) && Internal.equals(this.dropped_attributes_count, o.dropped_attributes_count) && this.events.equals(o.events) && Internal.equals(this.dropped_events_count, o.dropped_events_count) && this.links.equals(o.links) && Internal.equals(this.dropped_links_count, o.dropped_links_count) && Internal.equals(this.status, o.status);
    }

    public int hashCode() {
        int result2 = this.hashCode;
        if (result2 == 0) {
            result2 = this.unknownFields().hashCode();
            result2 = result2 * 37 + (this.trace_id != null ? this.trace_id.hashCode() : 0);
            result2 = result2 * 37 + (this.span_id != null ? this.span_id.hashCode() : 0);
            result2 = result2 * 37 + (this.trace_state != null ? this.trace_state.hashCode() : 0);
            result2 = result2 * 37 + (this.parent_span_id != null ? this.parent_span_id.hashCode() : 0);
            result2 = result2 * 37 + Integer.hashCode(this.flags);
            result2 = result2 * 37 + (this.name != null ? this.name.hashCode() : 0);
            result2 = result2 * 37 + (this.kind != null ? this.kind.hashCode() : 0);
            result2 = result2 * 37 + Long.hashCode(this.start_time_unix_nano);
            result2 = result2 * 37 + Long.hashCode(this.end_time_unix_nano);
            result2 = result2 * 37 + this.attributes.hashCode();
            result2 = result2 * 37 + Integer.hashCode(this.dropped_attributes_count);
            result2 = result2 * 37 + this.events.hashCode();
            result2 = result2 * 37 + Integer.hashCode(this.dropped_events_count);
            result2 = result2 * 37 + this.links.hashCode();
            result2 = result2 * 37 + Integer.hashCode(this.dropped_links_count);
            this.hashCode = result2 = result2 * 37 + (this.status != null ? this.status.hashCode() : 0);
        }
        return result2;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.trace_id != null) {
            builder.append(", trace_id=").append(this.trace_id);
        }
        if (this.span_id != null) {
            builder.append(", span_id=").append(this.span_id);
        }
        if (this.trace_state != null) {
            builder.append(", trace_state=").append(Internal.sanitize(this.trace_state));
        }
        if (this.parent_span_id != null) {
            builder.append(", parent_span_id=").append(this.parent_span_id);
        }
        builder.append(", flags=").append(this.flags);
        if (this.name != null) {
            builder.append(", name=").append(Internal.sanitize(this.name));
        }
        if (this.kind != null) {
            builder.append(", kind=").append(this.kind);
        }
        builder.append(", start_time_unix_nano=").append(this.start_time_unix_nano);
        builder.append(", end_time_unix_nano=").append(this.end_time_unix_nano);
        if (!this.attributes.isEmpty()) {
            builder.append(", attributes=").append(this.attributes);
        }
        builder.append(", dropped_attributes_count=").append(this.dropped_attributes_count);
        if (!this.events.isEmpty()) {
            builder.append(", events=").append(this.events);
        }
        builder.append(", dropped_events_count=").append(this.dropped_events_count);
        if (!this.links.isEmpty()) {
            builder.append(", links=").append(this.links);
        }
        builder.append(", dropped_links_count=").append(this.dropped_links_count);
        if (this.status != null) {
            builder.append(", status=").append(this.status);
        }
        return builder.replace(0, 2, "Span{").append('}').toString();
    }

    public static final class Builder
    extends Message.Builder<Span, Builder> {
        public ByteString trace_id = ByteString.EMPTY;
        public ByteString span_id = ByteString.EMPTY;
        public String trace_state = "";
        public ByteString parent_span_id = ByteString.EMPTY;
        public int flags = 0;
        public String name = "";
        public SpanKind kind = SpanKind.SPAN_KIND_UNSPECIFIED;
        public long start_time_unix_nano = 0L;
        public long end_time_unix_nano = 0L;
        public List<KeyValue> attributes = Internal.newMutableList();
        public int dropped_attributes_count = 0;
        public List<Event> events = Internal.newMutableList();
        public int dropped_events_count = 0;
        public List<Link> links = Internal.newMutableList();
        public int dropped_links_count = 0;
        public Status status;

        public Builder trace_id(ByteString trace_id) {
            this.trace_id = trace_id;
            return this;
        }

        public Builder span_id(ByteString span_id) {
            this.span_id = span_id;
            return this;
        }

        public Builder trace_state(String trace_state) {
            this.trace_state = trace_state;
            return this;
        }

        public Builder parent_span_id(ByteString parent_span_id) {
            this.parent_span_id = parent_span_id;
            return this;
        }

        public Builder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder kind(SpanKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder start_time_unix_nano(long start_time_unix_nano) {
            this.start_time_unix_nano = start_time_unix_nano;
            return this;
        }

        public Builder end_time_unix_nano(long end_time_unix_nano) {
            this.end_time_unix_nano = end_time_unix_nano;
            return this;
        }

        public Builder attributes(List<KeyValue> attributes) {
            Internal.checkElementsNotNull(attributes);
            this.attributes = attributes;
            return this;
        }

        public Builder dropped_attributes_count(int dropped_attributes_count) {
            this.dropped_attributes_count = dropped_attributes_count;
            return this;
        }

        public Builder events(List<Event> events) {
            Internal.checkElementsNotNull(events);
            this.events = events;
            return this;
        }

        public Builder dropped_events_count(int dropped_events_count) {
            this.dropped_events_count = dropped_events_count;
            return this;
        }

        public Builder links(List<Link> links) {
            Internal.checkElementsNotNull(links);
            this.links = links;
            return this;
        }

        public Builder dropped_links_count(int dropped_links_count) {
            this.dropped_links_count = dropped_links_count;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        @Override
        public Span build() {
            return new Span(this, super.buildUnknownFields());
        }
    }

    public static enum SpanKind implements WireEnum
    {
        SPAN_KIND_UNSPECIFIED(0),
        SPAN_KIND_INTERNAL(1),
        SPAN_KIND_SERVER(2),
        SPAN_KIND_CLIENT(3),
        SPAN_KIND_PRODUCER(4),
        SPAN_KIND_CONSUMER(5);

        public static final ProtoAdapter<SpanKind> ADAPTER;
        private final int value;

        private SpanKind(int value) {
            this.value = value;
        }

        public static SpanKind fromValue(int value) {
            switch (value) {
                case 0: {
                    return SPAN_KIND_UNSPECIFIED;
                }
                case 1: {
                    return SPAN_KIND_INTERNAL;
                }
                case 2: {
                    return SPAN_KIND_SERVER;
                }
                case 3: {
                    return SPAN_KIND_CLIENT;
                }
                case 4: {
                    return SPAN_KIND_PRODUCER;
                }
                case 5: {
                    return SPAN_KIND_CONSUMER;
                }
            }
            return null;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static {
            ADAPTER = new ProtoAdapter_SpanKind();
        }

        private static final class ProtoAdapter_SpanKind
        extends EnumAdapter<SpanKind> {
            ProtoAdapter_SpanKind() {
                super(SpanKind.class, Syntax.PROTO_3, SPAN_KIND_UNSPECIFIED);
            }

            @Override
            protected SpanKind fromValue(int value) {
                return SpanKind.fromValue(value);
            }
        }
    }

    private static final class ProtoAdapter_Span
    extends ProtoAdapter<Span> {
        public ProtoAdapter_Span() {
            super(FieldEncoding.LENGTH_DELIMITED, Span.class, "type.googleapis.com/opentelemetry.proto.trace.v1.Span", Syntax.PROTO_3, null, "opentelemetry/proto/trace/v1/trace.proto");
        }

        @Override
        public int encodedSize(Span value) {
            int result2 = 0;
            if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
                result2 += ProtoAdapter.BYTES.encodedSizeWithTag(1, value.trace_id);
            }
            if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
                result2 += ProtoAdapter.BYTES.encodedSizeWithTag(2, value.span_id);
            }
            if (!Objects.equals(value.trace_state, "")) {
                result2 += ProtoAdapter.STRING.encodedSizeWithTag(3, value.trace_state);
            }
            if (!Objects.equals(value.parent_span_id, ByteString.EMPTY)) {
                result2 += ProtoAdapter.BYTES.encodedSizeWithTag(4, value.parent_span_id);
            }
            if (!Objects.equals(value.flags, 0)) {
                result2 += ProtoAdapter.FIXED32.encodedSizeWithTag(16, value.flags);
            }
            if (!Objects.equals(value.name, "")) {
                result2 += ProtoAdapter.STRING.encodedSizeWithTag(5, value.name);
            }
            if (!Objects.equals(value.kind, SpanKind.SPAN_KIND_UNSPECIFIED)) {
                result2 += SpanKind.ADAPTER.encodedSizeWithTag(6, value.kind);
            }
            if (!Objects.equals(value.start_time_unix_nano, 0L)) {
                result2 += ProtoAdapter.FIXED64.encodedSizeWithTag(7, value.start_time_unix_nano);
            }
            if (!Objects.equals(value.end_time_unix_nano, 0L)) {
                result2 += ProtoAdapter.FIXED64.encodedSizeWithTag(8, value.end_time_unix_nano);
            }
            result2 += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(9, value.attributes);
            if (!Objects.equals(value.dropped_attributes_count, 0)) {
                result2 += ProtoAdapter.UINT32.encodedSizeWithTag(10, value.dropped_attributes_count);
            }
            result2 += Event.ADAPTER.asRepeated().encodedSizeWithTag(11, value.events);
            if (!Objects.equals(value.dropped_events_count, 0)) {
                result2 += ProtoAdapter.UINT32.encodedSizeWithTag(12, value.dropped_events_count);
            }
            result2 += Link.ADAPTER.asRepeated().encodedSizeWithTag(13, value.links);
            if (!Objects.equals(value.dropped_links_count, 0)) {
                result2 += ProtoAdapter.UINT32.encodedSizeWithTag(14, value.dropped_links_count);
            }
            if (!Objects.equals(value.status, null)) {
                result2 += Status.ADAPTER.encodedSizeWithTag(15, value.status);
            }
            return result2 += value.unknownFields().size();
        }

        @Override
        public void encode(ProtoWriter writer, Span value) throws IOException {
            if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
                ProtoAdapter.BYTES.encodeWithTag(writer, 1, value.trace_id);
            }
            if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
                ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.span_id);
            }
            if (!Objects.equals(value.trace_state, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 3, value.trace_state);
            }
            if (!Objects.equals(value.parent_span_id, ByteString.EMPTY)) {
                ProtoAdapter.BYTES.encodeWithTag(writer, 4, value.parent_span_id);
            }
            if (!Objects.equals(value.flags, 0)) {
                ProtoAdapter.FIXED32.encodeWithTag(writer, 16, (Integer)value.flags);
            }
            if (!Objects.equals(value.name, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 5, value.name);
            }
            if (!Objects.equals(value.kind, SpanKind.SPAN_KIND_UNSPECIFIED)) {
                SpanKind.ADAPTER.encodeWithTag(writer, 6, value.kind);
            }
            if (!Objects.equals(value.start_time_unix_nano, 0L)) {
                ProtoAdapter.FIXED64.encodeWithTag(writer, 7, (Long)value.start_time_unix_nano);
            }
            if (!Objects.equals(value.end_time_unix_nano, 0L)) {
                ProtoAdapter.FIXED64.encodeWithTag(writer, 8, (Long)value.end_time_unix_nano);
            }
            KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 9, value.attributes);
            if (!Objects.equals(value.dropped_attributes_count, 0)) {
                ProtoAdapter.UINT32.encodeWithTag(writer, 10, (Integer)value.dropped_attributes_count);
            }
            Event.ADAPTER.asRepeated().encodeWithTag(writer, 11, value.events);
            if (!Objects.equals(value.dropped_events_count, 0)) {
                ProtoAdapter.UINT32.encodeWithTag(writer, 12, (Integer)value.dropped_events_count);
            }
            Link.ADAPTER.asRepeated().encodeWithTag(writer, 13, value.links);
            if (!Objects.equals(value.dropped_links_count, 0)) {
                ProtoAdapter.UINT32.encodeWithTag(writer, 14, (Integer)value.dropped_links_count);
            }
            if (!Objects.equals(value.status, null)) {
                Status.ADAPTER.encodeWithTag(writer, 15, value.status);
            }
            writer.writeBytes(value.unknownFields());
        }

        @Override
        public void encode(ReverseProtoWriter writer, Span value) throws IOException {
            writer.writeBytes(value.unknownFields());
            if (!Objects.equals(value.status, null)) {
                Status.ADAPTER.encodeWithTag(writer, 15, value.status);
            }
            if (!Objects.equals(value.dropped_links_count, 0)) {
                ProtoAdapter.UINT32.encodeWithTag(writer, 14, (Integer)value.dropped_links_count);
            }
            Link.ADAPTER.asRepeated().encodeWithTag(writer, 13, value.links);
            if (!Objects.equals(value.dropped_events_count, 0)) {
                ProtoAdapter.UINT32.encodeWithTag(writer, 12, (Integer)value.dropped_events_count);
            }
            Event.ADAPTER.asRepeated().encodeWithTag(writer, 11, value.events);
            if (!Objects.equals(value.dropped_attributes_count, 0)) {
                ProtoAdapter.UINT32.encodeWithTag(writer, 10, (Integer)value.dropped_attributes_count);
            }
            KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 9, value.attributes);
            if (!Objects.equals(value.end_time_unix_nano, 0L)) {
                ProtoAdapter.FIXED64.encodeWithTag(writer, 8, (Long)value.end_time_unix_nano);
            }
            if (!Objects.equals(value.start_time_unix_nano, 0L)) {
                ProtoAdapter.FIXED64.encodeWithTag(writer, 7, (Long)value.start_time_unix_nano);
            }
            if (!Objects.equals(value.kind, SpanKind.SPAN_KIND_UNSPECIFIED)) {
                SpanKind.ADAPTER.encodeWithTag(writer, 6, value.kind);
            }
            if (!Objects.equals(value.name, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 5, value.name);
            }
            if (!Objects.equals(value.flags, 0)) {
                ProtoAdapter.FIXED32.encodeWithTag(writer, 16, (Integer)value.flags);
            }
            if (!Objects.equals(value.parent_span_id, ByteString.EMPTY)) {
                ProtoAdapter.BYTES.encodeWithTag(writer, 4, value.parent_span_id);
            }
            if (!Objects.equals(value.trace_state, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 3, value.trace_state);
            }
            if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
                ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.span_id);
            }
            if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
                ProtoAdapter.BYTES.encodeWithTag(writer, 1, value.trace_id);
            }
        }

        @Override
        public Span decode(ProtoReader reader) throws IOException {
            int tag;
            Builder builder = new Builder();
            long token2 = reader.beginMessage();
            block20: while ((tag = reader.nextTag()) != -1) {
                switch (tag) {
                    case 1: {
                        builder.trace_id(ProtoAdapter.BYTES.decode(reader));
                        continue block20;
                    }
                    case 2: {
                        builder.span_id(ProtoAdapter.BYTES.decode(reader));
                        continue block20;
                    }
                    case 3: {
                        builder.trace_state(ProtoAdapter.STRING.decode(reader));
                        continue block20;
                    }
                    case 4: {
                        builder.parent_span_id(ProtoAdapter.BYTES.decode(reader));
                        continue block20;
                    }
                    case 5: {
                        builder.name(ProtoAdapter.STRING.decode(reader));
                        continue block20;
                    }
                    case 6: {
                        try {
                            builder.kind(SpanKind.ADAPTER.decode(reader));
                        }
                        catch (ProtoAdapter.EnumConstantNotFoundException e) {
                            builder.addUnknownField(tag, FieldEncoding.VARINT, e.value);
                        }
                        continue block20;
                    }
                    case 7: {
                        builder.start_time_unix_nano(ProtoAdapter.FIXED64.decode(reader));
                        continue block20;
                    }
                    case 8: {
                        builder.end_time_unix_nano(ProtoAdapter.FIXED64.decode(reader));
                        continue block20;
                    }
                    case 9: {
                        builder.attributes.add(KeyValue.ADAPTER.decode(reader));
                        continue block20;
                    }
                    case 10: {
                        builder.dropped_attributes_count(ProtoAdapter.UINT32.decode(reader));
                        continue block20;
                    }
                    case 11: {
                        builder.events.add(Event.ADAPTER.decode(reader));
                        continue block20;
                    }
                    case 12: {
                        builder.dropped_events_count(ProtoAdapter.UINT32.decode(reader));
                        continue block20;
                    }
                    case 13: {
                        builder.links.add(Link.ADAPTER.decode(reader));
                        continue block20;
                    }
                    case 14: {
                        builder.dropped_links_count(ProtoAdapter.UINT32.decode(reader));
                        continue block20;
                    }
                    case 15: {
                        builder.status(Status.ADAPTER.decode(reader));
                        continue block20;
                    }
                    case 16: {
                        builder.flags(ProtoAdapter.FIXED32.decode(reader));
                        continue block20;
                    }
                }
                reader.readUnknownField(tag);
            }
            builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token2));
            return builder.build();
        }

        @Override
        public Span redact(Span value) {
            Builder builder = value.newBuilder();
            Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
            Internal.redactElements(builder.events, Event.ADAPTER);
            Internal.redactElements(builder.links, Link.ADAPTER);
            if (builder.status != null) {
                builder.status = Status.ADAPTER.redact(builder.status);
            }
            builder.clearUnknownFields();
            return builder.build();
        }
    }

    public static final class Link
    extends Message<Link, Builder> {
        public static final ProtoAdapter<Link> ADAPTER = new ProtoAdapter_Link();
        private static final long serialVersionUID = 0L;
        @WireField(tag=1, adapter="com.squareup.wire.ProtoAdapter#BYTES", label=WireField.Label.OMIT_IDENTITY, jsonName="traceId")
        public final ByteString trace_id;
        @WireField(tag=2, adapter="com.squareup.wire.ProtoAdapter#BYTES", label=WireField.Label.OMIT_IDENTITY, jsonName="spanId")
        public final ByteString span_id;
        @WireField(tag=3, adapter="com.squareup.wire.ProtoAdapter#STRING", label=WireField.Label.OMIT_IDENTITY, jsonName="traceState")
        public final String trace_state;
        @WireField(tag=4, adapter="io.opentelemetry.diskbuffering.proto.common.v1.KeyValue#ADAPTER", label=WireField.Label.REPEATED)
        public final List<KeyValue> attributes;
        @WireField(tag=5, adapter="com.squareup.wire.ProtoAdapter#UINT32", label=WireField.Label.OMIT_IDENTITY, jsonName="droppedAttributesCount")
        public final int dropped_attributes_count;
        @WireField(tag=6, adapter="com.squareup.wire.ProtoAdapter#FIXED32", label=WireField.Label.OMIT_IDENTITY)
        public final int flags;

        public Link(ByteString trace_id, ByteString span_id, String trace_state, List<KeyValue> attributes, int dropped_attributes_count, int flags) {
            this(trace_id, span_id, trace_state, attributes, dropped_attributes_count, flags, ByteString.EMPTY);
        }

        public Link(ByteString trace_id, ByteString span_id, String trace_state, List<KeyValue> attributes, int dropped_attributes_count, int flags, ByteString unknownFields) {
            super(ADAPTER, unknownFields);
            if (trace_id == null) {
                throw new IllegalArgumentException("trace_id == null");
            }
            this.trace_id = trace_id;
            if (span_id == null) {
                throw new IllegalArgumentException("span_id == null");
            }
            this.span_id = span_id;
            if (trace_state == null) {
                throw new IllegalArgumentException("trace_state == null");
            }
            this.trace_state = trace_state;
            this.attributes = Internal.immutableCopyOf("attributes", attributes);
            this.dropped_attributes_count = dropped_attributes_count;
            this.flags = flags;
        }

        @Override
        public Builder newBuilder() {
            Builder builder = new Builder();
            builder.trace_id = this.trace_id;
            builder.span_id = this.span_id;
            builder.trace_state = this.trace_state;
            builder.attributes = Internal.copyOf(this.attributes);
            builder.dropped_attributes_count = this.dropped_attributes_count;
            builder.flags = this.flags;
            builder.addUnknownFields(this.unknownFields());
            return builder;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Link)) {
                return false;
            }
            Link o = (Link)other;
            return this.unknownFields().equals(o.unknownFields()) && Internal.equals(this.trace_id, o.trace_id) && Internal.equals(this.span_id, o.span_id) && Internal.equals(this.trace_state, o.trace_state) && this.attributes.equals(o.attributes) && Internal.equals(this.dropped_attributes_count, o.dropped_attributes_count) && Internal.equals(this.flags, o.flags);
        }

        public int hashCode() {
            int result2 = this.hashCode;
            if (result2 == 0) {
                result2 = this.unknownFields().hashCode();
                result2 = result2 * 37 + (this.trace_id != null ? this.trace_id.hashCode() : 0);
                result2 = result2 * 37 + (this.span_id != null ? this.span_id.hashCode() : 0);
                result2 = result2 * 37 + (this.trace_state != null ? this.trace_state.hashCode() : 0);
                result2 = result2 * 37 + this.attributes.hashCode();
                result2 = result2 * 37 + Integer.hashCode(this.dropped_attributes_count);
                this.hashCode = result2 = result2 * 37 + Integer.hashCode(this.flags);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.trace_id != null) {
                builder.append(", trace_id=").append(this.trace_id);
            }
            if (this.span_id != null) {
                builder.append(", span_id=").append(this.span_id);
            }
            if (this.trace_state != null) {
                builder.append(", trace_state=").append(Internal.sanitize(this.trace_state));
            }
            if (!this.attributes.isEmpty()) {
                builder.append(", attributes=").append(this.attributes);
            }
            builder.append(", dropped_attributes_count=").append(this.dropped_attributes_count);
            builder.append(", flags=").append(this.flags);
            return builder.replace(0, 2, "Link{").append('}').toString();
        }

        public static final class Builder
        extends Message.Builder<Link, Builder> {
            public ByteString trace_id = ByteString.EMPTY;
            public ByteString span_id = ByteString.EMPTY;
            public String trace_state = "";
            public List<KeyValue> attributes = Internal.newMutableList();
            public int dropped_attributes_count = 0;
            public int flags = 0;

            public Builder trace_id(ByteString trace_id) {
                this.trace_id = trace_id;
                return this;
            }

            public Builder span_id(ByteString span_id) {
                this.span_id = span_id;
                return this;
            }

            public Builder trace_state(String trace_state) {
                this.trace_state = trace_state;
                return this;
            }

            public Builder attributes(List<KeyValue> attributes) {
                Internal.checkElementsNotNull(attributes);
                this.attributes = attributes;
                return this;
            }

            public Builder dropped_attributes_count(int dropped_attributes_count) {
                this.dropped_attributes_count = dropped_attributes_count;
                return this;
            }

            public Builder flags(int flags) {
                this.flags = flags;
                return this;
            }

            @Override
            public Link build() {
                return new Link(this.trace_id, this.span_id, this.trace_state, this.attributes, this.dropped_attributes_count, this.flags, super.buildUnknownFields());
            }
        }

        private static final class ProtoAdapter_Link
        extends ProtoAdapter<Link> {
            public ProtoAdapter_Link() {
                super(FieldEncoding.LENGTH_DELIMITED, Link.class, "type.googleapis.com/opentelemetry.proto.trace.v1.Span.Link", Syntax.PROTO_3, null, "opentelemetry/proto/trace/v1/trace.proto");
            }

            @Override
            public int encodedSize(Link value) {
                int result2 = 0;
                if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
                    result2 += ProtoAdapter.BYTES.encodedSizeWithTag(1, value.trace_id);
                }
                if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
                    result2 += ProtoAdapter.BYTES.encodedSizeWithTag(2, value.span_id);
                }
                if (!Objects.equals(value.trace_state, "")) {
                    result2 += ProtoAdapter.STRING.encodedSizeWithTag(3, value.trace_state);
                }
                result2 += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(4, value.attributes);
                if (!Objects.equals(value.dropped_attributes_count, 0)) {
                    result2 += ProtoAdapter.UINT32.encodedSizeWithTag(5, value.dropped_attributes_count);
                }
                if (!Objects.equals(value.flags, 0)) {
                    result2 += ProtoAdapter.FIXED32.encodedSizeWithTag(6, value.flags);
                }
                return result2 += value.unknownFields().size();
            }

            @Override
            public void encode(ProtoWriter writer, Link value) throws IOException {
                if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
                    ProtoAdapter.BYTES.encodeWithTag(writer, 1, value.trace_id);
                }
                if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
                    ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.span_id);
                }
                if (!Objects.equals(value.trace_state, "")) {
                    ProtoAdapter.STRING.encodeWithTag(writer, 3, value.trace_state);
                }
                KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 4, value.attributes);
                if (!Objects.equals(value.dropped_attributes_count, 0)) {
                    ProtoAdapter.UINT32.encodeWithTag(writer, 5, (Integer)value.dropped_attributes_count);
                }
                if (!Objects.equals(value.flags, 0)) {
                    ProtoAdapter.FIXED32.encodeWithTag(writer, 6, (Integer)value.flags);
                }
                writer.writeBytes(value.unknownFields());
            }

            @Override
            public void encode(ReverseProtoWriter writer, Link value) throws IOException {
                writer.writeBytes(value.unknownFields());
                if (!Objects.equals(value.flags, 0)) {
                    ProtoAdapter.FIXED32.encodeWithTag(writer, 6, (Integer)value.flags);
                }
                if (!Objects.equals(value.dropped_attributes_count, 0)) {
                    ProtoAdapter.UINT32.encodeWithTag(writer, 5, (Integer)value.dropped_attributes_count);
                }
                KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 4, value.attributes);
                if (!Objects.equals(value.trace_state, "")) {
                    ProtoAdapter.STRING.encodeWithTag(writer, 3, value.trace_state);
                }
                if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
                    ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.span_id);
                }
                if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
                    ProtoAdapter.BYTES.encodeWithTag(writer, 1, value.trace_id);
                }
            }

            @Override
            public Link decode(ProtoReader reader) throws IOException {
                int tag;
                Builder builder = new Builder();
                long token2 = reader.beginMessage();
                block8: while ((tag = reader.nextTag()) != -1) {
                    switch (tag) {
                        case 1: {
                            builder.trace_id(ProtoAdapter.BYTES.decode(reader));
                            continue block8;
                        }
                        case 2: {
                            builder.span_id(ProtoAdapter.BYTES.decode(reader));
                            continue block8;
                        }
                        case 3: {
                            builder.trace_state(ProtoAdapter.STRING.decode(reader));
                            continue block8;
                        }
                        case 4: {
                            builder.attributes.add(KeyValue.ADAPTER.decode(reader));
                            continue block8;
                        }
                        case 5: {
                            builder.dropped_attributes_count(ProtoAdapter.UINT32.decode(reader));
                            continue block8;
                        }
                        case 6: {
                            builder.flags(ProtoAdapter.FIXED32.decode(reader));
                            continue block8;
                        }
                    }
                    reader.readUnknownField(tag);
                }
                builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token2));
                return builder.build();
            }

            @Override
            public Link redact(Link value) {
                Builder builder = value.newBuilder();
                Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
                builder.clearUnknownFields();
                return builder.build();
            }
        }
    }

    public static final class Event
    extends Message<Event, Builder> {
        public static final ProtoAdapter<Event> ADAPTER = new ProtoAdapter_Event();
        private static final long serialVersionUID = 0L;
        @WireField(tag=1, adapter="com.squareup.wire.ProtoAdapter#FIXED64", label=WireField.Label.OMIT_IDENTITY, jsonName="timeUnixNano")
        public final long time_unix_nano;
        @WireField(tag=2, adapter="com.squareup.wire.ProtoAdapter#STRING", label=WireField.Label.OMIT_IDENTITY)
        public final String name;
        @WireField(tag=3, adapter="io.opentelemetry.diskbuffering.proto.common.v1.KeyValue#ADAPTER", label=WireField.Label.REPEATED)
        public final List<KeyValue> attributes;
        @WireField(tag=4, adapter="com.squareup.wire.ProtoAdapter#UINT32", label=WireField.Label.OMIT_IDENTITY, jsonName="droppedAttributesCount")
        public final int dropped_attributes_count;

        public Event(long time_unix_nano, String name, List<KeyValue> attributes, int dropped_attributes_count) {
            this(time_unix_nano, name, attributes, dropped_attributes_count, ByteString.EMPTY);
        }

        public Event(long time_unix_nano, String name, List<KeyValue> attributes, int dropped_attributes_count, ByteString unknownFields) {
            super(ADAPTER, unknownFields);
            this.time_unix_nano = time_unix_nano;
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            this.name = name;
            this.attributes = Internal.immutableCopyOf("attributes", attributes);
            this.dropped_attributes_count = dropped_attributes_count;
        }

        @Override
        public Builder newBuilder() {
            Builder builder = new Builder();
            builder.time_unix_nano = this.time_unix_nano;
            builder.name = this.name;
            builder.attributes = Internal.copyOf(this.attributes);
            builder.dropped_attributes_count = this.dropped_attributes_count;
            builder.addUnknownFields(this.unknownFields());
            return builder;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Event)) {
                return false;
            }
            Event o = (Event)other;
            return this.unknownFields().equals(o.unknownFields()) && Internal.equals(this.time_unix_nano, o.time_unix_nano) && Internal.equals(this.name, o.name) && this.attributes.equals(o.attributes) && Internal.equals(this.dropped_attributes_count, o.dropped_attributes_count);
        }

        public int hashCode() {
            int result2 = this.hashCode;
            if (result2 == 0) {
                result2 = this.unknownFields().hashCode();
                result2 = result2 * 37 + Long.hashCode(this.time_unix_nano);
                result2 = result2 * 37 + (this.name != null ? this.name.hashCode() : 0);
                result2 = result2 * 37 + this.attributes.hashCode();
                this.hashCode = result2 = result2 * 37 + Integer.hashCode(this.dropped_attributes_count);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(", time_unix_nano=").append(this.time_unix_nano);
            if (this.name != null) {
                builder.append(", name=").append(Internal.sanitize(this.name));
            }
            if (!this.attributes.isEmpty()) {
                builder.append(", attributes=").append(this.attributes);
            }
            builder.append(", dropped_attributes_count=").append(this.dropped_attributes_count);
            return builder.replace(0, 2, "Event{").append('}').toString();
        }

        public static final class Builder
        extends Message.Builder<Event, Builder> {
            public long time_unix_nano = 0L;
            public String name = "";
            public List<KeyValue> attributes = Internal.newMutableList();
            public int dropped_attributes_count = 0;

            public Builder time_unix_nano(long time_unix_nano) {
                this.time_unix_nano = time_unix_nano;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder attributes(List<KeyValue> attributes) {
                Internal.checkElementsNotNull(attributes);
                this.attributes = attributes;
                return this;
            }

            public Builder dropped_attributes_count(int dropped_attributes_count) {
                this.dropped_attributes_count = dropped_attributes_count;
                return this;
            }

            @Override
            public Event build() {
                return new Event(this.time_unix_nano, this.name, this.attributes, this.dropped_attributes_count, super.buildUnknownFields());
            }
        }

        private static final class ProtoAdapter_Event
        extends ProtoAdapter<Event> {
            public ProtoAdapter_Event() {
                super(FieldEncoding.LENGTH_DELIMITED, Event.class, "type.googleapis.com/opentelemetry.proto.trace.v1.Span.Event", Syntax.PROTO_3, null, "opentelemetry/proto/trace/v1/trace.proto");
            }

            @Override
            public int encodedSize(Event value) {
                int result2 = 0;
                if (!Objects.equals(value.time_unix_nano, 0L)) {
                    result2 += ProtoAdapter.FIXED64.encodedSizeWithTag(1, value.time_unix_nano);
                }
                if (!Objects.equals(value.name, "")) {
                    result2 += ProtoAdapter.STRING.encodedSizeWithTag(2, value.name);
                }
                result2 += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(3, value.attributes);
                if (!Objects.equals(value.dropped_attributes_count, 0)) {
                    result2 += ProtoAdapter.UINT32.encodedSizeWithTag(4, value.dropped_attributes_count);
                }
                return result2 += value.unknownFields().size();
            }

            @Override
            public void encode(ProtoWriter writer, Event value) throws IOException {
                if (!Objects.equals(value.time_unix_nano, 0L)) {
                    ProtoAdapter.FIXED64.encodeWithTag(writer, 1, (Long)value.time_unix_nano);
                }
                if (!Objects.equals(value.name, "")) {
                    ProtoAdapter.STRING.encodeWithTag(writer, 2, value.name);
                }
                KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 3, value.attributes);
                if (!Objects.equals(value.dropped_attributes_count, 0)) {
                    ProtoAdapter.UINT32.encodeWithTag(writer, 4, (Integer)value.dropped_attributes_count);
                }
                writer.writeBytes(value.unknownFields());
            }

            @Override
            public void encode(ReverseProtoWriter writer, Event value) throws IOException {
                writer.writeBytes(value.unknownFields());
                if (!Objects.equals(value.dropped_attributes_count, 0)) {
                    ProtoAdapter.UINT32.encodeWithTag(writer, 4, (Integer)value.dropped_attributes_count);
                }
                KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 3, value.attributes);
                if (!Objects.equals(value.name, "")) {
                    ProtoAdapter.STRING.encodeWithTag(writer, 2, value.name);
                }
                if (!Objects.equals(value.time_unix_nano, 0L)) {
                    ProtoAdapter.FIXED64.encodeWithTag(writer, 1, (Long)value.time_unix_nano);
                }
            }

            @Override
            public Event decode(ProtoReader reader) throws IOException {
                int tag;
                Builder builder = new Builder();
                long token2 = reader.beginMessage();
                block6: while ((tag = reader.nextTag()) != -1) {
                    switch (tag) {
                        case 1: {
                            builder.time_unix_nano(ProtoAdapter.FIXED64.decode(reader));
                            continue block6;
                        }
                        case 2: {
                            builder.name(ProtoAdapter.STRING.decode(reader));
                            continue block6;
                        }
                        case 3: {
                            builder.attributes.add(KeyValue.ADAPTER.decode(reader));
                            continue block6;
                        }
                        case 4: {
                            builder.dropped_attributes_count(ProtoAdapter.UINT32.decode(reader));
                            continue block6;
                        }
                    }
                    reader.readUnknownField(tag);
                }
                builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token2));
                return builder.build();
            }

            @Override
            public Event redact(Event value) {
                Builder builder = value.newBuilder();
                Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
                builder.clearUnknownFields();
                return builder.build();
            }
        }
    }
}

