/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.diskbuffering.proto.metrics.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.diskbuffering.proto.metrics.v1.ExponentialHistogram;
import io.opentelemetry.diskbuffering.proto.metrics.v1.Gauge;
import io.opentelemetry.diskbuffering.proto.metrics.v1.Histogram;
import io.opentelemetry.diskbuffering.proto.metrics.v1.Sum;
import io.opentelemetry.diskbuffering.proto.metrics.v1.Summary;
import java.io.IOException;
import java.util.Objects;
import okio.ByteString;

public final class Metric
extends Message<Metric, Builder> {
    public static final ProtoAdapter<Metric> ADAPTER = new ProtoAdapter_Metric();
    private static final long serialVersionUID = 0L;
    @WireField(tag=1, adapter="com.squareup.wire.ProtoAdapter#STRING", label=WireField.Label.OMIT_IDENTITY)
    public final String name;
    @WireField(tag=2, adapter="com.squareup.wire.ProtoAdapter#STRING", label=WireField.Label.OMIT_IDENTITY)
    public final String description;
    @WireField(tag=3, adapter="com.squareup.wire.ProtoAdapter#STRING", label=WireField.Label.OMIT_IDENTITY)
    public final String unit;
    @WireField(tag=5, adapter="io.opentelemetry.diskbuffering.proto.metrics.v1.Gauge#ADAPTER", oneofName="data")
    public final Gauge gauge;
    @WireField(tag=7, adapter="io.opentelemetry.diskbuffering.proto.metrics.v1.Sum#ADAPTER", oneofName="data")
    public final Sum sum;
    @WireField(tag=9, adapter="io.opentelemetry.diskbuffering.proto.metrics.v1.Histogram#ADAPTER", oneofName="data")
    public final Histogram histogram;
    @WireField(tag=10, adapter="io.opentelemetry.diskbuffering.proto.metrics.v1.ExponentialHistogram#ADAPTER", jsonName="exponentialHistogram", oneofName="data")
    public final ExponentialHistogram exponential_histogram;
    @WireField(tag=11, adapter="io.opentelemetry.diskbuffering.proto.metrics.v1.Summary#ADAPTER", oneofName="data")
    public final Summary summary;

    public Metric(String name, String description, String unit, Gauge gauge, Sum sum, Histogram histogram, ExponentialHistogram exponential_histogram, Summary summary) {
        this(name, description, unit, gauge, sum, histogram, exponential_histogram, summary, ByteString.EMPTY);
    }

    public Metric(String name, String description, String unit, Gauge gauge, Sum sum, Histogram histogram, ExponentialHistogram exponential_histogram, Summary summary, ByteString unknownFields) {
        super(ADAPTER, unknownFields);
        if (Internal.countNonNull(gauge, sum, histogram, exponential_histogram, summary) > 1) {
            throw new IllegalArgumentException("at most one of gauge, sum, histogram, exponential_histogram, summary may be non-null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.name = name;
        if (description == null) {
            throw new IllegalArgumentException("description == null");
        }
        this.description = description;
        if (unit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        this.unit = unit;
        this.gauge = gauge;
        this.sum = sum;
        this.histogram = histogram;
        this.exponential_histogram = exponential_histogram;
        this.summary = summary;
    }

    @Override
    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.name = this.name;
        builder.description = this.description;
        builder.unit = this.unit;
        builder.gauge = this.gauge;
        builder.sum = this.sum;
        builder.histogram = this.histogram;
        builder.exponential_histogram = this.exponential_histogram;
        builder.summary = this.summary;
        builder.addUnknownFields(this.unknownFields());
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Metric)) {
            return false;
        }
        Metric o = (Metric)other;
        return this.unknownFields().equals(o.unknownFields()) && Internal.equals(this.name, o.name) && Internal.equals(this.description, o.description) && Internal.equals(this.unit, o.unit) && Internal.equals(this.gauge, o.gauge) && Internal.equals(this.sum, o.sum) && Internal.equals(this.histogram, o.histogram) && Internal.equals(this.exponential_histogram, o.exponential_histogram) && Internal.equals(this.summary, o.summary);
    }

    public int hashCode() {
        int result2 = this.hashCode;
        if (result2 == 0) {
            result2 = this.unknownFields().hashCode();
            result2 = result2 * 37 + (this.name != null ? this.name.hashCode() : 0);
            result2 = result2 * 37 + (this.description != null ? this.description.hashCode() : 0);
            result2 = result2 * 37 + (this.unit != null ? this.unit.hashCode() : 0);
            result2 = result2 * 37 + (this.gauge != null ? this.gauge.hashCode() : 0);
            result2 = result2 * 37 + (this.sum != null ? this.sum.hashCode() : 0);
            result2 = result2 * 37 + (this.histogram != null ? this.histogram.hashCode() : 0);
            result2 = result2 * 37 + (this.exponential_histogram != null ? this.exponential_histogram.hashCode() : 0);
            this.hashCode = result2 = result2 * 37 + (this.summary != null ? this.summary.hashCode() : 0);
        }
        return result2;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.name != null) {
            builder.append(", name=").append(Internal.sanitize(this.name));
        }
        if (this.description != null) {
            builder.append(", description=").append(Internal.sanitize(this.description));
        }
        if (this.unit != null) {
            builder.append(", unit=").append(Internal.sanitize(this.unit));
        }
        if (this.gauge != null) {
            builder.append(", gauge=").append(this.gauge);
        }
        if (this.sum != null) {
            builder.append(", sum=").append(this.sum);
        }
        if (this.histogram != null) {
            builder.append(", histogram=").append(this.histogram);
        }
        if (this.exponential_histogram != null) {
            builder.append(", exponential_histogram=").append(this.exponential_histogram);
        }
        if (this.summary != null) {
            builder.append(", summary=").append(this.summary);
        }
        return builder.replace(0, 2, "Metric{").append('}').toString();
    }

    public static final class Builder
    extends Message.Builder<Metric, Builder> {
        public String name = "";
        public String description = "";
        public String unit = "";
        public Gauge gauge;
        public Sum sum;
        public Histogram histogram;
        public ExponentialHistogram exponential_histogram;
        public Summary summary;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public Builder gauge(Gauge gauge) {
            this.gauge = gauge;
            this.sum = null;
            this.histogram = null;
            this.exponential_histogram = null;
            this.summary = null;
            return this;
        }

        public Builder sum(Sum sum) {
            this.sum = sum;
            this.gauge = null;
            this.histogram = null;
            this.exponential_histogram = null;
            this.summary = null;
            return this;
        }

        public Builder histogram(Histogram histogram) {
            this.histogram = histogram;
            this.gauge = null;
            this.sum = null;
            this.exponential_histogram = null;
            this.summary = null;
            return this;
        }

        public Builder exponential_histogram(ExponentialHistogram exponential_histogram) {
            this.exponential_histogram = exponential_histogram;
            this.gauge = null;
            this.sum = null;
            this.histogram = null;
            this.summary = null;
            return this;
        }

        public Builder summary(Summary summary) {
            this.summary = summary;
            this.gauge = null;
            this.sum = null;
            this.histogram = null;
            this.exponential_histogram = null;
            return this;
        }

        @Override
        public Metric build() {
            return new Metric(this.name, this.description, this.unit, this.gauge, this.sum, this.histogram, this.exponential_histogram, this.summary, super.buildUnknownFields());
        }
    }

    private static final class ProtoAdapter_Metric
    extends ProtoAdapter<Metric> {
        public ProtoAdapter_Metric() {
            super(FieldEncoding.LENGTH_DELIMITED, Metric.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.Metric", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
        }

        @Override
        public int encodedSize(Metric value) {
            int result2 = 0;
            if (!Objects.equals(value.name, "")) {
                result2 += ProtoAdapter.STRING.encodedSizeWithTag(1, value.name);
            }
            if (!Objects.equals(value.description, "")) {
                result2 += ProtoAdapter.STRING.encodedSizeWithTag(2, value.description);
            }
            if (!Objects.equals(value.unit, "")) {
                result2 += ProtoAdapter.STRING.encodedSizeWithTag(3, value.unit);
            }
            result2 += Gauge.ADAPTER.encodedSizeWithTag(5, value.gauge);
            result2 += Sum.ADAPTER.encodedSizeWithTag(7, value.sum);
            result2 += Histogram.ADAPTER.encodedSizeWithTag(9, value.histogram);
            result2 += ExponentialHistogram.ADAPTER.encodedSizeWithTag(10, value.exponential_histogram);
            result2 += Summary.ADAPTER.encodedSizeWithTag(11, value.summary);
            return result2 += value.unknownFields().size();
        }

        @Override
        public void encode(ProtoWriter writer, Metric value) throws IOException {
            if (!Objects.equals(value.name, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 1, value.name);
            }
            if (!Objects.equals(value.description, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 2, value.description);
            }
            if (!Objects.equals(value.unit, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 3, value.unit);
            }
            Gauge.ADAPTER.encodeWithTag(writer, 5, value.gauge);
            Sum.ADAPTER.encodeWithTag(writer, 7, value.sum);
            Histogram.ADAPTER.encodeWithTag(writer, 9, value.histogram);
            ExponentialHistogram.ADAPTER.encodeWithTag(writer, 10, value.exponential_histogram);
            Summary.ADAPTER.encodeWithTag(writer, 11, value.summary);
            writer.writeBytes(value.unknownFields());
        }

        @Override
        public void encode(ReverseProtoWriter writer, Metric value) throws IOException {
            writer.writeBytes(value.unknownFields());
            Summary.ADAPTER.encodeWithTag(writer, 11, value.summary);
            ExponentialHistogram.ADAPTER.encodeWithTag(writer, 10, value.exponential_histogram);
            Histogram.ADAPTER.encodeWithTag(writer, 9, value.histogram);
            Sum.ADAPTER.encodeWithTag(writer, 7, value.sum);
            Gauge.ADAPTER.encodeWithTag(writer, 5, value.gauge);
            if (!Objects.equals(value.unit, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 3, value.unit);
            }
            if (!Objects.equals(value.description, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 2, value.description);
            }
            if (!Objects.equals(value.name, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 1, value.name);
            }
        }

        @Override
        public Metric decode(ProtoReader reader) throws IOException {
            int tag;
            Builder builder = new Builder();
            long token2 = reader.beginMessage();
            block10: while ((tag = reader.nextTag()) != -1) {
                switch (tag) {
                    case 1: {
                        builder.name(ProtoAdapter.STRING.decode(reader));
                        continue block10;
                    }
                    case 2: {
                        builder.description(ProtoAdapter.STRING.decode(reader));
                        continue block10;
                    }
                    case 3: {
                        builder.unit(ProtoAdapter.STRING.decode(reader));
                        continue block10;
                    }
                    case 5: {
                        builder.gauge(Gauge.ADAPTER.decode(reader));
                        continue block10;
                    }
                    case 7: {
                        builder.sum(Sum.ADAPTER.decode(reader));
                        continue block10;
                    }
                    case 9: {
                        builder.histogram(Histogram.ADAPTER.decode(reader));
                        continue block10;
                    }
                    case 10: {
                        builder.exponential_histogram(ExponentialHistogram.ADAPTER.decode(reader));
                        continue block10;
                    }
                    case 11: {
                        builder.summary(Summary.ADAPTER.decode(reader));
                        continue block10;
                    }
                }
                reader.readUnknownField(tag);
            }
            builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token2));
            return builder.build();
        }

        @Override
        public Metric redact(Metric value) {
            Builder builder = value.newBuilder();
            if (builder.gauge != null) {
                builder.gauge = Gauge.ADAPTER.redact(builder.gauge);
            }
            if (builder.sum != null) {
                builder.sum = Sum.ADAPTER.redact(builder.sum);
            }
            if (builder.histogram != null) {
                builder.histogram = Histogram.ADAPTER.redact(builder.histogram);
            }
            if (builder.exponential_histogram != null) {
                builder.exponential_histogram = ExponentialHistogram.ADAPTER.redact(builder.exponential_histogram);
            }
            if (builder.summary != null) {
                builder.summary = Summary.ADAPTER.redact(builder.summary);
            }
            builder.clearUnknownFields();
            return builder.build();
        }
    }
}

