/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.diskbuffering.proto.logs.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.diskbuffering.proto.common.v1.AnyValue;
import io.opentelemetry.diskbuffering.proto.common.v1.KeyValue;
import io.opentelemetry.diskbuffering.proto.logs.v1.SeverityNumber;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

public final class LogRecord
extends Message<LogRecord, Builder> {
    public static final ProtoAdapter<LogRecord> ADAPTER = new ProtoAdapter_LogRecord();
    private static final long serialVersionUID = 0L;
    @WireField(tag=1, adapter="com.squareup.wire.ProtoAdapter#FIXED64", label=WireField.Label.OMIT_IDENTITY, jsonName="timeUnixNano")
    public final long time_unix_nano;
    @WireField(tag=11, adapter="com.squareup.wire.ProtoAdapter#FIXED64", label=WireField.Label.OMIT_IDENTITY, jsonName="observedTimeUnixNano")
    public final long observed_time_unix_nano;
    @WireField(tag=2, adapter="io.opentelemetry.diskbuffering.proto.logs.v1.SeverityNumber#ADAPTER", label=WireField.Label.OMIT_IDENTITY, jsonName="severityNumber")
    public final SeverityNumber severity_number;
    @WireField(tag=3, adapter="com.squareup.wire.ProtoAdapter#STRING", label=WireField.Label.OMIT_IDENTITY, jsonName="severityText")
    public final String severity_text;
    @WireField(tag=5, adapter="io.opentelemetry.diskbuffering.proto.common.v1.AnyValue#ADAPTER", label=WireField.Label.OMIT_IDENTITY)
    public final AnyValue body;
    @WireField(tag=6, adapter="io.opentelemetry.diskbuffering.proto.common.v1.KeyValue#ADAPTER", label=WireField.Label.REPEATED)
    public final List<KeyValue> attributes;
    @WireField(tag=7, adapter="com.squareup.wire.ProtoAdapter#UINT32", label=WireField.Label.OMIT_IDENTITY, jsonName="droppedAttributesCount")
    public final int dropped_attributes_count;
    @WireField(tag=8, adapter="com.squareup.wire.ProtoAdapter#FIXED32", label=WireField.Label.OMIT_IDENTITY)
    public final int flags;
    @WireField(tag=9, adapter="com.squareup.wire.ProtoAdapter#BYTES", label=WireField.Label.OMIT_IDENTITY, jsonName="traceId")
    public final ByteString trace_id;
    @WireField(tag=10, adapter="com.squareup.wire.ProtoAdapter#BYTES", label=WireField.Label.OMIT_IDENTITY, jsonName="spanId")
    public final ByteString span_id;

    public LogRecord(long time_unix_nano, long observed_time_unix_nano, SeverityNumber severity_number, String severity_text, AnyValue body, List<KeyValue> attributes, int dropped_attributes_count, int flags, ByteString trace_id, ByteString span_id) {
        this(time_unix_nano, observed_time_unix_nano, severity_number, severity_text, body, attributes, dropped_attributes_count, flags, trace_id, span_id, ByteString.EMPTY);
    }

    public LogRecord(long time_unix_nano, long observed_time_unix_nano, SeverityNumber severity_number, String severity_text, AnyValue body, List<KeyValue> attributes, int dropped_attributes_count, int flags, ByteString trace_id, ByteString span_id, ByteString unknownFields) {
        super(ADAPTER, unknownFields);
        this.time_unix_nano = time_unix_nano;
        this.observed_time_unix_nano = observed_time_unix_nano;
        if (severity_number == null) {
            throw new IllegalArgumentException("severity_number == null");
        }
        this.severity_number = severity_number;
        if (severity_text == null) {
            throw new IllegalArgumentException("severity_text == null");
        }
        this.severity_text = severity_text;
        this.body = body;
        this.attributes = Internal.immutableCopyOf("attributes", attributes);
        this.dropped_attributes_count = dropped_attributes_count;
        this.flags = flags;
        if (trace_id == null) {
            throw new IllegalArgumentException("trace_id == null");
        }
        this.trace_id = trace_id;
        if (span_id == null) {
            throw new IllegalArgumentException("span_id == null");
        }
        this.span_id = span_id;
    }

    @Override
    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.time_unix_nano = this.time_unix_nano;
        builder.observed_time_unix_nano = this.observed_time_unix_nano;
        builder.severity_number = this.severity_number;
        builder.severity_text = this.severity_text;
        builder.body = this.body;
        builder.attributes = Internal.copyOf(this.attributes);
        builder.dropped_attributes_count = this.dropped_attributes_count;
        builder.flags = this.flags;
        builder.trace_id = this.trace_id;
        builder.span_id = this.span_id;
        builder.addUnknownFields(this.unknownFields());
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LogRecord)) {
            return false;
        }
        LogRecord o = (LogRecord)other;
        return this.unknownFields().equals(o.unknownFields()) && Internal.equals(this.time_unix_nano, o.time_unix_nano) && Internal.equals(this.observed_time_unix_nano, o.observed_time_unix_nano) && Internal.equals(this.severity_number, o.severity_number) && Internal.equals(this.severity_text, o.severity_text) && Internal.equals(this.body, o.body) && this.attributes.equals(o.attributes) && Internal.equals(this.dropped_attributes_count, o.dropped_attributes_count) && Internal.equals(this.flags, o.flags) && Internal.equals(this.trace_id, o.trace_id) && Internal.equals(this.span_id, o.span_id);
    }

    public int hashCode() {
        int result2 = this.hashCode;
        if (result2 == 0) {
            result2 = this.unknownFields().hashCode();
            result2 = result2 * 37 + Long.hashCode(this.time_unix_nano);
            result2 = result2 * 37 + Long.hashCode(this.observed_time_unix_nano);
            result2 = result2 * 37 + (this.severity_number != null ? this.severity_number.hashCode() : 0);
            result2 = result2 * 37 + (this.severity_text != null ? this.severity_text.hashCode() : 0);
            result2 = result2 * 37 + (this.body != null ? this.body.hashCode() : 0);
            result2 = result2 * 37 + this.attributes.hashCode();
            result2 = result2 * 37 + Integer.hashCode(this.dropped_attributes_count);
            result2 = result2 * 37 + Integer.hashCode(this.flags);
            result2 = result2 * 37 + (this.trace_id != null ? this.trace_id.hashCode() : 0);
            this.hashCode = result2 = result2 * 37 + (this.span_id != null ? this.span_id.hashCode() : 0);
        }
        return result2;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(", time_unix_nano=").append(this.time_unix_nano);
        builder.append(", observed_time_unix_nano=").append(this.observed_time_unix_nano);
        if (this.severity_number != null) {
            builder.append(", severity_number=").append(this.severity_number);
        }
        if (this.severity_text != null) {
            builder.append(", severity_text=").append(Internal.sanitize(this.severity_text));
        }
        if (this.body != null) {
            builder.append(", body=").append(this.body);
        }
        if (!this.attributes.isEmpty()) {
            builder.append(", attributes=").append(this.attributes);
        }
        builder.append(", dropped_attributes_count=").append(this.dropped_attributes_count);
        builder.append(", flags=").append(this.flags);
        if (this.trace_id != null) {
            builder.append(", trace_id=").append(this.trace_id);
        }
        if (this.span_id != null) {
            builder.append(", span_id=").append(this.span_id);
        }
        return builder.replace(0, 2, "LogRecord{").append('}').toString();
    }

    public static final class Builder
    extends Message.Builder<LogRecord, Builder> {
        public long time_unix_nano = 0L;
        public long observed_time_unix_nano = 0L;
        public SeverityNumber severity_number = SeverityNumber.SEVERITY_NUMBER_UNSPECIFIED;
        public String severity_text = "";
        public AnyValue body;
        public List<KeyValue> attributes = Internal.newMutableList();
        public int dropped_attributes_count = 0;
        public int flags = 0;
        public ByteString trace_id = ByteString.EMPTY;
        public ByteString span_id = ByteString.EMPTY;

        public Builder time_unix_nano(long time_unix_nano) {
            this.time_unix_nano = time_unix_nano;
            return this;
        }

        public Builder observed_time_unix_nano(long observed_time_unix_nano) {
            this.observed_time_unix_nano = observed_time_unix_nano;
            return this;
        }

        public Builder severity_number(SeverityNumber severity_number) {
            this.severity_number = severity_number;
            return this;
        }

        public Builder severity_text(String severity_text) {
            this.severity_text = severity_text;
            return this;
        }

        public Builder body(AnyValue body) {
            this.body = body;
            return this;
        }

        public Builder attributes(List<KeyValue> attributes) {
            Internal.checkElementsNotNull(attributes);
            this.attributes = attributes;
            return this;
        }

        public Builder dropped_attributes_count(int dropped_attributes_count) {
            this.dropped_attributes_count = dropped_attributes_count;
            return this;
        }

        public Builder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public Builder trace_id(ByteString trace_id) {
            this.trace_id = trace_id;
            return this;
        }

        public Builder span_id(ByteString span_id) {
            this.span_id = span_id;
            return this;
        }

        @Override
        public LogRecord build() {
            return new LogRecord(this.time_unix_nano, this.observed_time_unix_nano, this.severity_number, this.severity_text, this.body, this.attributes, this.dropped_attributes_count, this.flags, this.trace_id, this.span_id, super.buildUnknownFields());
        }
    }

    private static final class ProtoAdapter_LogRecord
    extends ProtoAdapter<LogRecord> {
        public ProtoAdapter_LogRecord() {
            super(FieldEncoding.LENGTH_DELIMITED, LogRecord.class, "type.googleapis.com/opentelemetry.proto.logs.v1.LogRecord", Syntax.PROTO_3, null, "opentelemetry/proto/logs/v1/logs.proto");
        }

        @Override
        public int encodedSize(LogRecord value) {
            int result2 = 0;
            if (!Objects.equals(value.time_unix_nano, 0L)) {
                result2 += ProtoAdapter.FIXED64.encodedSizeWithTag(1, value.time_unix_nano);
            }
            if (!Objects.equals(value.observed_time_unix_nano, 0L)) {
                result2 += ProtoAdapter.FIXED64.encodedSizeWithTag(11, value.observed_time_unix_nano);
            }
            if (!Objects.equals(value.severity_number, SeverityNumber.SEVERITY_NUMBER_UNSPECIFIED)) {
                result2 += SeverityNumber.ADAPTER.encodedSizeWithTag(2, value.severity_number);
            }
            if (!Objects.equals(value.severity_text, "")) {
                result2 += ProtoAdapter.STRING.encodedSizeWithTag(3, value.severity_text);
            }
            if (!Objects.equals(value.body, null)) {
                result2 += AnyValue.ADAPTER.encodedSizeWithTag(5, value.body);
            }
            result2 += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(6, value.attributes);
            if (!Objects.equals(value.dropped_attributes_count, 0)) {
                result2 += ProtoAdapter.UINT32.encodedSizeWithTag(7, value.dropped_attributes_count);
            }
            if (!Objects.equals(value.flags, 0)) {
                result2 += ProtoAdapter.FIXED32.encodedSizeWithTag(8, value.flags);
            }
            if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
                result2 += ProtoAdapter.BYTES.encodedSizeWithTag(9, value.trace_id);
            }
            if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
                result2 += ProtoAdapter.BYTES.encodedSizeWithTag(10, value.span_id);
            }
            return result2 += value.unknownFields().size();
        }

        @Override
        public void encode(ProtoWriter writer, LogRecord value) throws IOException {
            if (!Objects.equals(value.time_unix_nano, 0L)) {
                ProtoAdapter.FIXED64.encodeWithTag(writer, 1, (Long)value.time_unix_nano);
            }
            if (!Objects.equals(value.observed_time_unix_nano, 0L)) {
                ProtoAdapter.FIXED64.encodeWithTag(writer, 11, (Long)value.observed_time_unix_nano);
            }
            if (!Objects.equals(value.severity_number, SeverityNumber.SEVERITY_NUMBER_UNSPECIFIED)) {
                SeverityNumber.ADAPTER.encodeWithTag(writer, 2, value.severity_number);
            }
            if (!Objects.equals(value.severity_text, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 3, value.severity_text);
            }
            if (!Objects.equals(value.body, null)) {
                AnyValue.ADAPTER.encodeWithTag(writer, 5, value.body);
            }
            KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 6, value.attributes);
            if (!Objects.equals(value.dropped_attributes_count, 0)) {
                ProtoAdapter.UINT32.encodeWithTag(writer, 7, (Integer)value.dropped_attributes_count);
            }
            if (!Objects.equals(value.flags, 0)) {
                ProtoAdapter.FIXED32.encodeWithTag(writer, 8, (Integer)value.flags);
            }
            if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
                ProtoAdapter.BYTES.encodeWithTag(writer, 9, value.trace_id);
            }
            if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
                ProtoAdapter.BYTES.encodeWithTag(writer, 10, value.span_id);
            }
            writer.writeBytes(value.unknownFields());
        }

        @Override
        public void encode(ReverseProtoWriter writer, LogRecord value) throws IOException {
            writer.writeBytes(value.unknownFields());
            if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
                ProtoAdapter.BYTES.encodeWithTag(writer, 10, value.span_id);
            }
            if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
                ProtoAdapter.BYTES.encodeWithTag(writer, 9, value.trace_id);
            }
            if (!Objects.equals(value.flags, 0)) {
                ProtoAdapter.FIXED32.encodeWithTag(writer, 8, (Integer)value.flags);
            }
            if (!Objects.equals(value.dropped_attributes_count, 0)) {
                ProtoAdapter.UINT32.encodeWithTag(writer, 7, (Integer)value.dropped_attributes_count);
            }
            KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 6, value.attributes);
            if (!Objects.equals(value.body, null)) {
                AnyValue.ADAPTER.encodeWithTag(writer, 5, value.body);
            }
            if (!Objects.equals(value.severity_text, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 3, value.severity_text);
            }
            if (!Objects.equals(value.severity_number, SeverityNumber.SEVERITY_NUMBER_UNSPECIFIED)) {
                SeverityNumber.ADAPTER.encodeWithTag(writer, 2, value.severity_number);
            }
            if (!Objects.equals(value.observed_time_unix_nano, 0L)) {
                ProtoAdapter.FIXED64.encodeWithTag(writer, 11, (Long)value.observed_time_unix_nano);
            }
            if (!Objects.equals(value.time_unix_nano, 0L)) {
                ProtoAdapter.FIXED64.encodeWithTag(writer, 1, (Long)value.time_unix_nano);
            }
        }

        @Override
        public LogRecord decode(ProtoReader reader) throws IOException {
            int tag;
            Builder builder = new Builder();
            long token2 = reader.beginMessage();
            block14: while ((tag = reader.nextTag()) != -1) {
                switch (tag) {
                    case 1: {
                        builder.time_unix_nano(ProtoAdapter.FIXED64.decode(reader));
                        continue block14;
                    }
                    case 2: {
                        try {
                            builder.severity_number(SeverityNumber.ADAPTER.decode(reader));
                        }
                        catch (ProtoAdapter.EnumConstantNotFoundException e) {
                            builder.addUnknownField(tag, FieldEncoding.VARINT, e.value);
                        }
                        continue block14;
                    }
                    case 3: {
                        builder.severity_text(ProtoAdapter.STRING.decode(reader));
                        continue block14;
                    }
                    case 5: {
                        builder.body(AnyValue.ADAPTER.decode(reader));
                        continue block14;
                    }
                    case 6: {
                        builder.attributes.add(KeyValue.ADAPTER.decode(reader));
                        continue block14;
                    }
                    case 7: {
                        builder.dropped_attributes_count(ProtoAdapter.UINT32.decode(reader));
                        continue block14;
                    }
                    case 8: {
                        builder.flags(ProtoAdapter.FIXED32.decode(reader));
                        continue block14;
                    }
                    case 9: {
                        builder.trace_id(ProtoAdapter.BYTES.decode(reader));
                        continue block14;
                    }
                    case 10: {
                        builder.span_id(ProtoAdapter.BYTES.decode(reader));
                        continue block14;
                    }
                    case 11: {
                        builder.observed_time_unix_nano(ProtoAdapter.FIXED64.decode(reader));
                        continue block14;
                    }
                }
                reader.readUnknownField(tag);
            }
            builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token2));
            return builder.build();
        }

        @Override
        public LogRecord redact(LogRecord value) {
            Builder builder = value.newBuilder();
            if (builder.body != null) {
                builder.body = AnyValue.ADAPTER.redact(builder.body);
            }
            Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
            builder.clearUnknownFields();
            return builder.build();
        }
    }
}

