/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.diskbuffering.proto.common.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.diskbuffering.proto.common.v1.KeyValue;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

public final class InstrumentationScope
extends Message<InstrumentationScope, Builder> {
    public static final ProtoAdapter<InstrumentationScope> ADAPTER = new ProtoAdapter_InstrumentationScope();
    private static final long serialVersionUID = 0L;
    @WireField(tag=1, adapter="com.squareup.wire.ProtoAdapter#STRING", label=WireField.Label.OMIT_IDENTITY)
    public final String name;
    @WireField(tag=2, adapter="com.squareup.wire.ProtoAdapter#STRING", label=WireField.Label.OMIT_IDENTITY)
    public final String version;
    @WireField(tag=3, adapter="io.opentelemetry.diskbuffering.proto.common.v1.KeyValue#ADAPTER", label=WireField.Label.REPEATED)
    public final List<KeyValue> attributes;
    @WireField(tag=4, adapter="com.squareup.wire.ProtoAdapter#UINT32", label=WireField.Label.OMIT_IDENTITY, jsonName="droppedAttributesCount")
    public final int dropped_attributes_count;

    public InstrumentationScope(String name, String version, List<KeyValue> attributes, int dropped_attributes_count) {
        this(name, version, attributes, dropped_attributes_count, ByteString.EMPTY);
    }

    public InstrumentationScope(String name, String version, List<KeyValue> attributes, int dropped_attributes_count, ByteString unknownFields) {
        super(ADAPTER, unknownFields);
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.name = name;
        if (version == null) {
            throw new IllegalArgumentException("version == null");
        }
        this.version = version;
        this.attributes = Internal.immutableCopyOf("attributes", attributes);
        this.dropped_attributes_count = dropped_attributes_count;
    }

    @Override
    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.name = this.name;
        builder.version = this.version;
        builder.attributes = Internal.copyOf(this.attributes);
        builder.dropped_attributes_count = this.dropped_attributes_count;
        builder.addUnknownFields(this.unknownFields());
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof InstrumentationScope)) {
            return false;
        }
        InstrumentationScope o = (InstrumentationScope)other;
        return this.unknownFields().equals(o.unknownFields()) && Internal.equals(this.name, o.name) && Internal.equals(this.version, o.version) && this.attributes.equals(o.attributes) && Internal.equals(this.dropped_attributes_count, o.dropped_attributes_count);
    }

    public int hashCode() {
        int result2 = this.hashCode;
        if (result2 == 0) {
            result2 = this.unknownFields().hashCode();
            result2 = result2 * 37 + (this.name != null ? this.name.hashCode() : 0);
            result2 = result2 * 37 + (this.version != null ? this.version.hashCode() : 0);
            result2 = result2 * 37 + this.attributes.hashCode();
            this.hashCode = result2 = result2 * 37 + Integer.hashCode(this.dropped_attributes_count);
        }
        return result2;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.name != null) {
            builder.append(", name=").append(Internal.sanitize(this.name));
        }
        if (this.version != null) {
            builder.append(", version=").append(Internal.sanitize(this.version));
        }
        if (!this.attributes.isEmpty()) {
            builder.append(", attributes=").append(this.attributes);
        }
        builder.append(", dropped_attributes_count=").append(this.dropped_attributes_count);
        return builder.replace(0, 2, "InstrumentationScope{").append('}').toString();
    }

    public static final class Builder
    extends Message.Builder<InstrumentationScope, Builder> {
        public String name = "";
        public String version = "";
        public List<KeyValue> attributes = Internal.newMutableList();
        public int dropped_attributes_count = 0;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder attributes(List<KeyValue> attributes) {
            Internal.checkElementsNotNull(attributes);
            this.attributes = attributes;
            return this;
        }

        public Builder dropped_attributes_count(int dropped_attributes_count) {
            this.dropped_attributes_count = dropped_attributes_count;
            return this;
        }

        @Override
        public InstrumentationScope build() {
            return new InstrumentationScope(this.name, this.version, this.attributes, this.dropped_attributes_count, super.buildUnknownFields());
        }
    }

    private static final class ProtoAdapter_InstrumentationScope
    extends ProtoAdapter<InstrumentationScope> {
        public ProtoAdapter_InstrumentationScope() {
            super(FieldEncoding.LENGTH_DELIMITED, InstrumentationScope.class, "type.googleapis.com/opentelemetry.proto.common.v1.InstrumentationScope", Syntax.PROTO_3, null, "opentelemetry/proto/common/v1/common.proto");
        }

        @Override
        public int encodedSize(InstrumentationScope value) {
            int result2 = 0;
            if (!Objects.equals(value.name, "")) {
                result2 += ProtoAdapter.STRING.encodedSizeWithTag(1, value.name);
            }
            if (!Objects.equals(value.version, "")) {
                result2 += ProtoAdapter.STRING.encodedSizeWithTag(2, value.version);
            }
            result2 += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(3, value.attributes);
            if (!Objects.equals(value.dropped_attributes_count, 0)) {
                result2 += ProtoAdapter.UINT32.encodedSizeWithTag(4, value.dropped_attributes_count);
            }
            return result2 += value.unknownFields().size();
        }

        @Override
        public void encode(ProtoWriter writer, InstrumentationScope value) throws IOException {
            if (!Objects.equals(value.name, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 1, value.name);
            }
            if (!Objects.equals(value.version, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 2, value.version);
            }
            KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 3, value.attributes);
            if (!Objects.equals(value.dropped_attributes_count, 0)) {
                ProtoAdapter.UINT32.encodeWithTag(writer, 4, (Integer)value.dropped_attributes_count);
            }
            writer.writeBytes(value.unknownFields());
        }

        @Override
        public void encode(ReverseProtoWriter writer, InstrumentationScope value) throws IOException {
            writer.writeBytes(value.unknownFields());
            if (!Objects.equals(value.dropped_attributes_count, 0)) {
                ProtoAdapter.UINT32.encodeWithTag(writer, 4, (Integer)value.dropped_attributes_count);
            }
            KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 3, value.attributes);
            if (!Objects.equals(value.version, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 2, value.version);
            }
            if (!Objects.equals(value.name, "")) {
                ProtoAdapter.STRING.encodeWithTag(writer, 1, value.name);
            }
        }

        @Override
        public InstrumentationScope decode(ProtoReader reader) throws IOException {
            int tag;
            Builder builder = new Builder();
            long token2 = reader.beginMessage();
            block6: while ((tag = reader.nextTag()) != -1) {
                switch (tag) {
                    case 1: {
                        builder.name(ProtoAdapter.STRING.decode(reader));
                        continue block6;
                    }
                    case 2: {
                        builder.version(ProtoAdapter.STRING.decode(reader));
                        continue block6;
                    }
                    case 3: {
                        builder.attributes.add(KeyValue.ADAPTER.decode(reader));
                        continue block6;
                    }
                    case 4: {
                        builder.dropped_attributes_count(ProtoAdapter.UINT32.decode(reader));
                        continue block6;
                    }
                }
                reader.readUnknownField(tag);
            }
            builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token2));
            return builder.build();
        }

        @Override
        public InstrumentationScope redact(InstrumentationScope value) {
            Builder builder = value.newBuilder();
            Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
            builder.clearUnknownFields();
            return builder.build();
        }
    }
}

