/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers;

import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.metrics.ProtoMetricsDataMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.contrib.disk.buffering.internal.utils.ProtobufTools;
import io.opentelemetry.diskbuffering.proto.metrics.v1.MetricsData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;

public final class MetricDataSerializer
implements SignalSerializer<MetricData> {
    private static final MetricDataSerializer INSTANCE = new MetricDataSerializer();

    private MetricDataSerializer() {
    }

    static MetricDataSerializer getInstance() {
        return INSTANCE;
    }

    @Override
    public byte[] serialize(Collection<MetricData> metricData) {
        byte[] byArray;
        MetricsData proto = (MetricsData)ProtoMetricsDataMapper.getInstance().toProto(metricData);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int size = MetricsData.ADAPTER.encodedSize(proto);
            ProtobufTools.writeRawVarint32(size, out);
            proto.encode(out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        out.close();
        return byArray;
    }
}

