/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.spans;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common.AttributesMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common.ByteStringMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.spans.models.SpanDataImpl;
import io.opentelemetry.contrib.disk.buffering.internal.utils.ProtobufTools;
import io.opentelemetry.diskbuffering.proto.common.v1.KeyValue;
import io.opentelemetry.diskbuffering.proto.trace.v1.Span;
import io.opentelemetry.diskbuffering.proto.trace.v1.Status;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class SpanDataMapper {
    private static final SpanDataMapper INSTANCE = new SpanDataMapper();
    private final ByteStringMapper byteStringMapper = ByteStringMapper.getInstance();

    public static SpanDataMapper getInstance() {
        return INSTANCE;
    }

    public Span mapToProto(SpanData source2) {
        Span.Builder span = new Span.Builder();
        span.start_time_unix_nano(source2.getStartEpochNanos());
        span.end_time_unix_nano(source2.getEndEpochNanos());
        if (source2.getEvents() != null) {
            for (EventData event : source2.getEvents()) {
                span.events.add(SpanDataMapper.eventDataToProto(event));
            }
        }
        if (source2.getLinks() != null) {
            for (LinkData link : source2.getLinks()) {
                span.links.add(SpanDataMapper.linkDataToProto(link));
            }
        }
        span.trace_id(this.byteStringMapper.stringToProto(source2.getTraceId()));
        span.span_id(this.byteStringMapper.stringToProto(source2.getSpanId()));
        span.flags(source2.getSpanContext().getTraceFlags().asByte());
        span.parent_span_id(this.byteStringMapper.stringToProto(source2.getParentSpanId()));
        span.name(source2.getName());
        span.kind(SpanDataMapper.mapSpanKindToProto(source2.getKind()));
        span.status(SpanDataMapper.statusDataToProto(source2.getStatus()));
        SpanDataMapper.addSpanProtoExtras(source2, span);
        return span.build();
    }

    private static void addSpanProtoExtras(SpanData source2, Span.Builder target) {
        target.attributes.addAll(SpanDataMapper.attributesToProto(source2.getAttributes()));
        target.dropped_attributes_count(source2.getTotalAttributeCount() - source2.getAttributes().size());
        target.dropped_events_count(source2.getTotalRecordedEvents() - SpanDataMapper.getListSize(source2.getEvents()));
        target.dropped_links_count(source2.getTotalRecordedLinks() - SpanDataMapper.getListSize(source2.getLinks()));
        target.trace_state(SpanDataMapper.encodeTraceState(source2.getSpanContext().getTraceState()));
    }

    public SpanData mapToSdk(Span source2, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo) {
        SpanDataImpl.Builder spanData = SpanDataImpl.builder();
        spanData.setStartEpochNanos(source2.start_time_unix_nano);
        spanData.setEndEpochNanos(source2.end_time_unix_nano);
        spanData.setEvents(SpanDataMapper.eventListToEventDataList(source2.events));
        spanData.setLinks(SpanDataMapper.linkListToLinkDataList(source2.links));
        spanData.setName(source2.name);
        spanData.setKind(SpanDataMapper.mapSpanKindToSdk(source2.kind));
        if (source2.status != null) {
            spanData.setStatus(SpanDataMapper.mapStatusDataToSdk(source2.status));
        }
        SpanDataMapper.addSpanDataExtras(source2, spanData, resource, instrumentationScopeInfo);
        return spanData.build();
    }

    private static void addSpanDataExtras(Span source2, SpanDataImpl.Builder target, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo) {
        Attributes attributes = SpanDataMapper.protoToAttributes(source2.attributes);
        target.setAttributes(attributes);
        target.setResource(resource);
        target.setInstrumentationScopeInfo(instrumentationScopeInfo);
        String traceId = ByteStringMapper.getInstance().protoToString(source2.trace_id);
        target.setSpanContext(SpanContext.create(traceId, ByteStringMapper.getInstance().protoToString(source2.span_id), SpanDataMapper.flagsFromInt(source2.flags), SpanDataMapper.decodeTraceState(source2.trace_state)));
        target.setParentSpanContext(SpanContext.create(traceId, ByteStringMapper.getInstance().protoToString(source2.parent_span_id), TraceFlags.getSampled(), TraceState.getDefault()));
        target.setTotalAttributeCount(source2.dropped_attributes_count + attributes.size());
        target.setTotalRecordedEvents(SpanDataMapper.calculateRecordedItems(source2.dropped_events_count, source2.events.size()));
        target.setTotalRecordedLinks(SpanDataMapper.calculateRecordedItems(source2.dropped_links_count, source2.links.size()));
    }

    private static StatusData mapStatusDataToSdk(Status source2) {
        return StatusData.create(SpanDataMapper.getStatusCode(source2.code), source2.message);
    }

    private static Span.Event eventDataToProto(EventData source2) {
        Span.Event.Builder event = new Span.Event.Builder();
        event.time_unix_nano(source2.getEpochNanos());
        event.name(source2.getName());
        event.dropped_attributes_count(source2.getDroppedAttributesCount());
        SpanDataMapper.addEventProtoExtras(source2, event);
        return event.build();
    }

    private static void addEventProtoExtras(EventData source2, Span.Event.Builder target) {
        target.attributes.addAll(SpanDataMapper.attributesToProto(source2.getAttributes()));
    }

    private static Status statusDataToProto(StatusData source2) {
        Status.Builder status = new Status.Builder();
        status.message(source2.getDescription());
        status.code(SpanDataMapper.mapStatusCodeToProto(source2.getStatusCode()));
        return status.build();
    }

    private static Span.SpanKind mapSpanKindToProto(SpanKind source2) {
        Span.SpanKind spanKind;
        switch (source2) {
            case INTERNAL: {
                spanKind = Span.SpanKind.SPAN_KIND_INTERNAL;
                break;
            }
            case SERVER: {
                spanKind = Span.SpanKind.SPAN_KIND_SERVER;
                break;
            }
            case CLIENT: {
                spanKind = Span.SpanKind.SPAN_KIND_CLIENT;
                break;
            }
            case PRODUCER: {
                spanKind = Span.SpanKind.SPAN_KIND_PRODUCER;
                break;
            }
            case CONSUMER: {
                spanKind = Span.SpanKind.SPAN_KIND_CONSUMER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)source2));
            }
        }
        return spanKind;
    }

    private static Status.StatusCode mapStatusCodeToProto(StatusCode source2) {
        Status.StatusCode statusCode;
        switch (source2) {
            case UNSET: {
                statusCode = Status.StatusCode.STATUS_CODE_UNSET;
                break;
            }
            case OK: {
                statusCode = Status.StatusCode.STATUS_CODE_OK;
                break;
            }
            case ERROR: {
                statusCode = Status.StatusCode.STATUS_CODE_ERROR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)source2));
            }
        }
        return statusCode;
    }

    private static EventData eventDataToSdk(Span.Event source2) {
        Attributes attributes = SpanDataMapper.protoToAttributes(source2.attributes);
        return EventData.create(source2.time_unix_nano, source2.name, attributes, attributes.size() + source2.dropped_attributes_count);
    }

    private static SpanKind mapSpanKindToSdk(Span.SpanKind source2) {
        SpanKind spanKind;
        switch (source2) {
            case SPAN_KIND_INTERNAL: {
                spanKind = SpanKind.INTERNAL;
                break;
            }
            case SPAN_KIND_SERVER: {
                spanKind = SpanKind.SERVER;
                break;
            }
            case SPAN_KIND_CLIENT: {
                spanKind = SpanKind.CLIENT;
                break;
            }
            case SPAN_KIND_PRODUCER: {
                spanKind = SpanKind.PRODUCER;
                break;
            }
            case SPAN_KIND_CONSUMER: {
                spanKind = SpanKind.CONSUMER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + source2);
            }
        }
        return spanKind;
    }

    private static List<EventData> eventListToEventDataList(List<Span.Event> list) {
        ArrayList<EventData> result2 = new ArrayList<EventData>(list.size());
        for (Span.Event event : list) {
            result2.add(SpanDataMapper.eventDataToSdk(event));
        }
        return result2;
    }

    private static List<LinkData> linkListToLinkDataList(List<Span.Link> list) {
        ArrayList<LinkData> result2 = new ArrayList<LinkData>(list.size());
        for (Span.Link link : list) {
            result2.add(SpanDataMapper.linkDataToSdk(link));
        }
        return result2;
    }

    private static LinkData linkDataToSdk(Span.Link source2) {
        Attributes attributes = SpanDataMapper.protoToAttributes(source2.attributes);
        int totalAttrCount = source2.dropped_attributes_count + attributes.size();
        SpanContext spanContext = SpanContext.create(ByteStringMapper.getInstance().protoToString(source2.trace_id), ByteStringMapper.getInstance().protoToString(source2.span_id), SpanDataMapper.flagsFromInt(source2.flags), SpanDataMapper.decodeTraceState(source2.trace_state));
        return LinkData.create(spanContext, attributes, totalAttrCount);
    }

    private static int calculateRecordedItems(int droppedCount, int itemsCount) {
        return droppedCount + itemsCount;
    }

    private static StatusCode getStatusCode(Status.StatusCode source2) {
        switch (source2) {
            case STATUS_CODE_UNSET: {
                return StatusCode.UNSET;
            }
            case STATUS_CODE_OK: {
                return StatusCode.OK;
            }
            case STATUS_CODE_ERROR: {
                return StatusCode.ERROR;
            }
        }
        throw new IllegalArgumentException("Unexpected enum constant: " + source2);
    }

    private static List<KeyValue> attributesToProto(Attributes source2) {
        return AttributesMapper.getInstance().attributesToProto(source2);
    }

    private static Attributes protoToAttributes(List<KeyValue> source2) {
        return AttributesMapper.getInstance().protoToAttributes(source2);
    }

    private static int getListSize(List<?> list) {
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    private static String encodeTraceState(TraceState traceState) {
        if (!traceState.isEmpty()) {
            return W3CTraceContextEncoding.encodeTraceState(traceState);
        }
        return "";
    }

    private static TraceState decodeTraceState(@Nullable String source2) {
        return source2 == null || source2.isEmpty() ? TraceState.getDefault() : W3CTraceContextEncoding.decodeTraceState(source2);
    }

    private static Span.Link linkDataToProto(LinkData source2) {
        Span.Link.Builder builder = new Span.Link.Builder();
        SpanContext spanContext = source2.getSpanContext();
        builder.trace_id(ByteStringMapper.getInstance().stringToProto(spanContext.getTraceId()));
        builder.span_id(ByteStringMapper.getInstance().stringToProto(spanContext.getSpanId()));
        builder.flags = ProtobufTools.toUnsignedInt(spanContext.getTraceFlags().asByte());
        builder.attributes.addAll(SpanDataMapper.attributesToProto(source2.getAttributes()));
        builder.dropped_attributes_count(source2.getTotalAttributeCount() - source2.getAttributes().size());
        builder.trace_state(SpanDataMapper.encodeTraceState(spanContext.getTraceState()));
        return builder.build();
    }

    public static TraceFlags flagsFromInt(int b) {
        return TraceFlags.fromByte((byte)(b & 0xFF));
    }
}

