/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.logs;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common.AttributesMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common.ByteStringMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.logs.models.LogRecordDataImpl;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.spans.SpanDataMapper;
import io.opentelemetry.contrib.disk.buffering.internal.utils.ProtobufTools;
import io.opentelemetry.diskbuffering.proto.common.v1.AnyValue;
import io.opentelemetry.diskbuffering.proto.logs.v1.LogRecord;
import io.opentelemetry.diskbuffering.proto.logs.v1.SeverityNumber;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.stream.Collectors;

public final class LogRecordDataMapper {
    private static final LogRecordDataMapper INSTANCE = new LogRecordDataMapper();

    public static LogRecordDataMapper getInstance() {
        return INSTANCE;
    }

    public LogRecord mapToProto(LogRecordData source2) {
        LogRecord.Builder logRecord = new LogRecord.Builder();
        logRecord.time_unix_nano(source2.getTimestampEpochNanos());
        logRecord.observed_time_unix_nano(source2.getObservedTimestampEpochNanos());
        if (source2.getSeverity() != null) {
            logRecord.severity_number(LogRecordDataMapper.severityToProto(source2.getSeverity()));
        }
        if (source2.getSeverityText() != null) {
            logRecord.severity_text(source2.getSeverityText());
        }
        if (source2.getBodyValue() != null) {
            logRecord.body(LogRecordDataMapper.bodyToAnyValue(source2.getBodyValue()));
        }
        byte flags = source2.getSpanContext().getTraceFlags().asByte();
        logRecord.flags(ProtobufTools.toUnsignedInt(flags));
        LogRecordDataMapper.addExtrasToProtoBuilder(source2, logRecord);
        return logRecord.build();
    }

    private static void addExtrasToProtoBuilder(LogRecordData source2, LogRecord.Builder target) {
        target.attributes.addAll(AttributesMapper.getInstance().attributesToProto(source2.getAttributes()));
        SpanContext spanContext = source2.getSpanContext();
        target.span_id(ByteStringMapper.getInstance().stringToProto(spanContext.getSpanId()));
        target.trace_id(ByteStringMapper.getInstance().stringToProto(spanContext.getTraceId()));
        target.dropped_attributes_count(source2.getTotalAttributeCount() - source2.getAttributes().size());
    }

    public LogRecordData mapToSdk(LogRecord source2, Resource resource, InstrumentationScopeInfo scopeInfo) {
        LogRecordDataImpl.Builder logRecordData = LogRecordDataImpl.builder();
        logRecordData.setTimestampEpochNanos(source2.time_unix_nano);
        logRecordData.setObservedTimestampEpochNanos(source2.observed_time_unix_nano);
        logRecordData.setSeverity(LogRecordDataMapper.severityNumberToSdk(source2.severity_number));
        logRecordData.setSeverityText(source2.severity_text);
        if (source2.body != null) {
            logRecordData.setBodyValue(LogRecordDataMapper.anyValueToBody(source2.body));
        }
        LogRecordDataMapper.addExtrasToSdkItemBuilder(source2, logRecordData, resource, scopeInfo);
        return logRecordData.build();
    }

    private static void addExtrasToSdkItemBuilder(LogRecord source2, LogRecordDataImpl.Builder target, Resource resource, InstrumentationScopeInfo scopeInfo) {
        Attributes attributes = AttributesMapper.getInstance().protoToAttributes(source2.attributes);
        target.setAttributes(attributes);
        target.setSpanContext(SpanContext.create(ByteStringMapper.getInstance().protoToString(source2.trace_id), ByteStringMapper.getInstance().protoToString(source2.span_id), SpanDataMapper.flagsFromInt(source2.flags), TraceState.getDefault()));
        target.setTotalAttributeCount(source2.dropped_attributes_count + attributes.size());
        target.setResource(resource);
        target.setInstrumentationScopeInfo(scopeInfo);
    }

    private static AnyValue bodyToAnyValue(Value<?> body) {
        return new AnyValue.Builder().string_value(body.asString()).build();
    }

    private static SeverityNumber severityToProto(Severity severity) {
        return SeverityNumber.fromValue(severity.getSeverityNumber());
    }

    private static Value<?> anyValueToBody(AnyValue source2) {
        if (source2.string_value != null) {
            return Value.of((String)source2.string_value);
        }
        if (source2.int_value != null) {
            return Value.of((long)source2.int_value);
        }
        if (source2.double_value != null) {
            return Value.of((double)source2.double_value);
        }
        if (source2.bool_value != null) {
            return Value.of((boolean)source2.bool_value);
        }
        if (source2.bytes_value != null) {
            return Value.of((byte[])source2.bytes_value.toByteArray());
        }
        if (source2.kvlist_value != null) {
            return Value.of(source2.kvlist_value.values.stream().collect(Collectors.toMap(keyValue -> keyValue.key, keyValue -> LogRecordDataMapper.anyValueToBody(keyValue.value))));
        }
        if (source2.array_value != null) {
            return Value.of(source2.array_value.values.stream().map(LogRecordDataMapper::anyValueToBody).collect(Collectors.toList()));
        }
        throw new IllegalArgumentException("Unrecognized AnyValue type");
    }

    private static Severity severityNumberToSdk(SeverityNumber source2) {
        for (Severity value : Severity.values()) {
            if (value.getSeverityNumber() != source2.getValue()) continue;
            return value;
        }
        throw new IllegalArgumentException();
    }
}

