/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering;

import io.opentelemetry.contrib.disk.buffering.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.exporter.ToDiskExporter;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.contrib.disk.buffering.internal.utils.SignalTypes;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.io.IOException;
import java.util.Collection;

public class LogRecordToDiskExporter
implements LogRecordExporter {
    private final ToDiskExporter<LogRecordData> delegate;

    public static LogRecordToDiskExporter create(LogRecordExporter delegate, StorageConfiguration config) throws IOException {
        ToDiskExporter<LogRecordData> toDisk = ToDiskExporter.builder().setFolderName(SignalTypes.logs.name()).setStorageConfiguration(config).setSerializer(SignalSerializer.ofLogs()).setExportFunction(delegate::export).build();
        return new LogRecordToDiskExporter(toDisk);
    }

    LogRecordToDiskExporter(ToDiskExporter<LogRecordData> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        return this.delegate.export(logs);
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        try {
            this.delegate.shutdown();
            return CompletableResultCode.ofSuccess();
        }
        catch (IOException e) {
            return CompletableResultCode.ofFailure();
        }
    }
}

