/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.context;

import com.google.errorprone.annotations.MustBeClosed;
import io.opentelemetry.context.ContextExecutorService;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ContextScheduledExecutorService;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.CurrentContextExecutorService;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface Context {
    public static Context current() {
        Context current = ContextStorage.get().current();
        return current != null ? current : Context.root();
    }

    public static Context root() {
        return ContextStorage.get().root();
    }

    public static Executor taskWrapping(Executor executor) {
        return command2 -> executor.execute(Context.current().wrap(command2));
    }

    public static ExecutorService taskWrapping(ExecutorService executorService) {
        return new CurrentContextExecutorService(executorService);
    }

    @Nullable
    public <V> V get(ContextKey<V> var1);

    public <V> Context with(ContextKey<V> var1, V var2);

    default public Context with(ImplicitContextKeyed value) {
        return value.storeInContext(this);
    }

    @MustBeClosed
    default public Scope makeCurrent() {
        return ContextStorage.get().attach(this);
    }

    default public Runnable wrap(Runnable runnable2) {
        return () -> {
            try (Scope ignored = this.makeCurrent();){
                runnable2.run();
            }
        };
    }

    default public <T> Callable<T> wrap(Callable<T> callable) {
        return () -> {
            try (Scope ignored = this.makeCurrent();){
                Object v = callable.call();
                return v;
            }
        };
    }

    default public Executor wrap(Executor executor) {
        return command2 -> executor.execute(this.wrap(command2));
    }

    default public ExecutorService wrap(ExecutorService executor) {
        return new ContextExecutorService(this, executor);
    }

    default public ScheduledExecutorService wrap(ScheduledExecutorService executor) {
        return new ContextScheduledExecutorService(this, executor);
    }

    default public <T, U> Function<T, U> wrapFunction(Function<T, U> function) {
        return t2 -> {
            try (Scope ignored = this.makeCurrent();){
                Object r = function.apply(t2);
                return r;
            }
        };
    }

    default public <T, U, V> BiFunction<T, U, V> wrapFunction(BiFunction<T, U, V> function) {
        return (t2, u) -> {
            try (Scope ignored = this.makeCurrent();){
                Object r = function.apply(t2, u);
                return r;
            }
        };
    }

    default public <T> Consumer<T> wrapConsumer(Consumer<T> consumer) {
        return t2 -> {
            try (Scope ignored = this.makeCurrent();){
                consumer.accept(t2);
            }
        };
    }

    default public <T, U> BiConsumer<T, U> wrapConsumer(BiConsumer<T, U> consumer) {
        return (t2, u) -> {
            try (Scope ignored = this.makeCurrent();){
                consumer.accept(t2, u);
            }
        };
    }

    default public <T> Supplier<T> wrapSupplier(Supplier<T> supplier) {
        return () -> {
            try (Scope ignored = this.makeCurrent();){
                Object t2 = supplier.get();
                return t2;
            }
        };
    }
}

