/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.squareup.wire.schema.Location;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u001a\u0010\u001c\u001a\u00020\u00162\b\b\u0002\u0010\u001d\u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\rJ\u0006\u0010\u001f\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0016J\u0010\u0010!\u001a\u00020\u00162\b\b\u0002\u0010\u001d\u001a\u00020\rJ\u0006\u0010\"\u001a\u00020\tJ\u0006\u0010#\u001a\u00020\u0016J\b\u0010$\u001a\u00020\u0016H\u0002J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u0016J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\rH\u0002J\b\u0010)\u001a\u00020\u0011H\u0002J\u0006\u0010\u0004\u001a\u00020\u0005J,\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\r2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00160-H\u0086\b\u00f8\u0001\u0000J\u001e\u0010.\u001a\u00060/j\u0002`02\u0006\u0010,\u001a\u00020\u00162\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Lcom/squareup/wire/schema/internal/parser/SyntaxReader;", "", "data", "", "location", "Lcom/squareup/wire/schema/Location;", "<init>", "([CLcom/squareup/wire/schema/Location;)V", "pos", "", "line", "lineStart", "exhausted", "", "readChar", "", "require", "", "c", "peekChar", "pushBack", "readString", "", "readQuotedString", "readNumericEscape", "radix", "len", "hexDigit", "readName", "allowLeadingDigit", "retainWrap", "readDataType", "name", "readWord", "readInt", "readDocumentation", "readComment", "tryAppendTrailingDocumentation", "documentation", "skipWhitespace", "skipComments", "newline", "expect", "condition", "message", "Lkotlin/Function0;", "unexpected", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "wire-schema"})
@SourceDebugExtension(value={"SMAP\nSyntaxReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntaxReader.kt\ncom/squareup/wire/schema/internal/parser/SyntaxReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,427:1\n418#1,3:429\n418#1,3:432\n418#1,3:435\n418#1,3:438\n418#1,3:441\n418#1,3:444\n418#1,3:447\n418#1,3:450\n418#1,3:453\n418#1,3:456\n419#1,2:459\n418#1,3:461\n418#1,3:464\n418#1,3:467\n1#2:428\n*S KotlinDebug\n*F\n+ 1 SyntaxReader.kt\ncom/squareup/wire/schema/internal/parser/SyntaxReader\n*L\n42#1:429,3\n51#1:432,3\n95#1:435,3\n130#1:438,3\n154#1:441,3\n162#1:444,3\n181#1:447,3\n184#1:450,3\n187#1:453,3\n205#1:456,3\n207#1:459,2\n324#1:461,3\n341#1:464,3\n357#1:467,3\n*E\n"})
public final class SyntaxReader {
    @NotNull
    private final char[] data;
    @NotNull
    private final Location location;
    private int pos;
    private int line;
    private int lineStart;

    public SyntaxReader(@NotNull char[] data, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(location, "location");
        this.data = data;
        this.location = location;
    }

    public final boolean exhausted() {
        return this.pos == this.data.length;
    }

    public final char readChar() {
        char c;
        char it = c = this.peekChar();
        boolean bl = false;
        int n = this.pos;
        this.pos = n + 1;
        return c;
    }

    public final void require(char c) {
        char readChar = this.readChar();
        boolean condition$iv = readChar == c;
        Location location$iv = this.location();
        boolean $i$f$expect = false;
        if (!condition$iv) {
            SyntaxReader syntaxReader = this;
            boolean bl = false;
            throw syntaxReader.unexpected("expected '" + c + "' but was '" + readChar + '\'', location$iv);
        }
    }

    public final char peekChar() {
        this.skipWhitespace(true);
        boolean condition$iv = this.pos < this.data.length;
        Location location$iv = this.location();
        boolean $i$f$expect = false;
        if (!condition$iv) {
            SyntaxReader syntaxReader = this;
            boolean bl = false;
            throw syntaxReader.unexpected("unexpected end of file", location$iv);
        }
        return this.data[this.pos];
    }

    public final boolean peekChar(char c) {
        boolean bl;
        if (this.peekChar() == c) {
            int n = this.pos;
            this.pos = n + 1;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void pushBack(char c) {
        if (!(this.data[this.pos - 1] == c)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.pos;
        this.pos = n + -1;
    }

    @NotNull
    public final String readString() {
        String string;
        this.skipWhitespace(true);
        switch (this.peekChar()) {
            case '\"': 
            case '\'': {
                string = this.readQuotedString();
                break;
            }
            default: {
                string = SyntaxReader.readWord$default(this, false, 1, null);
            }
        }
        return string;
    }

    @NotNull
    public final String readQuotedString() {
        char startQuote = this.readChar();
        if (!(startQuote == '\"' || startQuote == '\'')) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        StringBuilder result2 = new StringBuilder();
        while (this.pos < this.data.length) {
            int n = this.pos;
            this.pos = n + 1;
            char c = this.data[n];
            if (c == startQuote) {
                if (this.peekChar() == '\"' || this.peekChar() == '\'') {
                    startQuote = this.readChar();
                    continue;
                }
                String string = result2.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                return string;
            }
            if (c == '\\') {
                boolean condition$iv = this.pos < this.data.length;
                Location location$iv = this.location();
                boolean $i$f$expect = false;
                if (!condition$iv) {
                    SyntaxReader syntaxReader = this;
                    boolean bl = false;
                    throw syntaxReader.unexpected("unexpected end of file", location$iv);
                }
                n = this.pos;
                this.pos = n + 1;
                c = this.data[n];
                switch (c) {
                    case 'a': {
                        c = '\u0007';
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'v': {
                        c = '\u000b';
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        c = this.readNumericEscape(16, 2);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        this.pos += -1;
                        c = this.readNumericEscape(8, 3);
                    }
                }
            }
            result2.append(c);
            if (c != '\n') continue;
            this.newline();
        }
        throw SyntaxReader.unexpected$default(this, "unterminated string", null, 2, null);
    }

    private final char readNumericEscape(int radix, int len) {
        int digit;
        int value = -1;
        int endPos = Math.min(this.pos + len, this.data.length);
        while (this.pos < endPos && (digit = this.hexDigit(this.data[this.pos])) != -1 && digit < radix) {
            value = value < 0 ? digit : value * radix + digit;
            int n = this.pos;
            this.pos = n + 1;
        }
        boolean condition$iv = value >= 0;
        Location location$iv = this.location();
        boolean $i$f$expect = false;
        if (!condition$iv) {
            SyntaxReader syntaxReader = this;
            boolean bl = false;
            throw syntaxReader.unexpected("expected a digit after \\x or \\X", location$iv);
        }
        return (char)value;
    }

    private final int hexDigit(char c) {
        int n;
        block1: {
            char c2;
            block0: {
                c2 = c;
                boolean bl = '0' <= c2 ? c2 < ':' : false;
                if (!bl) break block0;
                n = c - 48;
                break block1;
            }
            n = ('a' <= c2 ? c2 < 'g' : false) ? c - 97 + 10 : (('A' <= c2 ? c2 < 'G' : false) ? c - 65 + 10 : -1);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readName(boolean allowLeadingDigit, boolean retainWrap) {
        String string;
        switch (this.peekChar()) {
            case '(': {
                String string2;
                int n = this.pos;
                this.pos = n + 1;
                String it = string2 = this.readWord(allowLeadingDigit);
                boolean bl = false;
                boolean condition$iv = this.readChar() == ')';
                Location location$iv = this.location();
                boolean $i$f$expect = false;
                if (!condition$iv) {
                    SyntaxReader syntaxReader = this;
                    boolean bl2 = false;
                    throw syntaxReader.unexpected("expected ')'", location$iv);
                }
                String word = string2;
                if (retainWrap) {
                    string = '(' + word + ')';
                    break;
                }
                string = word;
                break;
            }
            case '[': {
                void var3_6;
                String string3;
                int word = this.pos;
                this.pos = word + 1;
                String it = string3 = this.readWord(allowLeadingDigit);
                boolean bl = false;
                boolean condition$iv = this.readChar() == ']';
                Location location$iv = this.location();
                boolean $i$f$expect = false;
                if (!condition$iv) {
                    SyntaxReader syntaxReader = this;
                    boolean bl3 = false;
                    throw syntaxReader.unexpected("expected ']'", location$iv);
                }
                String word2 = string3;
                if (retainWrap) {
                    string = '[' + word2 + ']';
                    break;
                }
                string = var3_6;
                break;
            }
            default: {
                string = this.readWord(allowLeadingDigit);
            }
        }
        return string;
    }

    public static /* synthetic */ String readName$default(SyntaxReader syntaxReader, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return syntaxReader.readName(bl, bl2);
    }

    @NotNull
    public final String readDataType() {
        String name = SyntaxReader.readWord$default(this, false, 1, null);
        return this.readDataType(name);
    }

    @NotNull
    public final String readDataType(@NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter(name, "name");
        if (Intrinsics.areEqual(name, "map")) {
            boolean condition$iv = this.readChar() == '<';
            Location location$iv = this.location();
            boolean $i$f$expect = false;
            if (!condition$iv) {
                SyntaxReader syntaxReader = this;
                boolean bl = false;
                throw syntaxReader.unexpected("expected '<'", location$iv);
            }
            String keyType = this.readDataType();
            boolean condition$iv2 = this.readChar() == ',';
            Location location$iv2 = this.location();
            boolean $i$f$expect2 = false;
            if (!condition$iv2) {
                SyntaxReader syntaxReader = this;
                boolean bl = false;
                throw syntaxReader.unexpected("expected ','", location$iv2);
            }
            String valueType = this.readDataType();
            boolean condition$iv3 = this.readChar() == '>';
            Location location$iv3 = this.location();
            boolean $i$f$expect3 = false;
            if (!condition$iv3) {
                SyntaxReader syntaxReader = this;
                boolean bl = false;
                throw syntaxReader.unexpected("expected '>'", location$iv3);
            }
            string = "map<" + keyType + ", " + valueType + '>';
        } else {
            string = name;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readWord(boolean allowLeadingDigit) {
        this.skipWhitespace(true);
        int start = this.pos;
        while (this.pos < this.data.length) {
            char c = this.data[this.pos];
            if (!('a' <= c ? c < '{' : false)) {
                if (!('A' <= c ? c < '[' : false)) {
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (!bl && c != '_' && c != '-' && c != '.') break;
                }
            }
            int n = this.pos;
            this.pos = n + 1;
        }
        boolean condition$iv3 = start < this.pos;
        Location location$iv2 = this.location();
        boolean $i$f$expect = false;
        if (!condition$iv3) {
            SyntaxReader syntaxReader = this;
            boolean bl = false;
            throw syntaxReader.unexpected("expected a word", location$iv2);
        }
        if (!allowLeadingDigit) {
            void condition$iv2;
            SyntaxReader condition$iv3 = this;
            boolean location$iv2 = !Character.isDigit(this.data[start]);
            Location location$iv3 = Location.copy$default(this.location(), null, null, 0, start - this.lineStart, 7, null);
            boolean $i$f$expect2 = false;
            if (condition$iv2 == false) {
                void this_$iv;
                void var8_11 = this_$iv;
                boolean bl = false;
                throw var8_11.unexpected("field and constant names cannot start with a digit", location$iv3);
            }
        }
        return StringsKt.concatToString(this.data, start, this.pos);
    }

    public static /* synthetic */ String readWord$default(SyntaxReader syntaxReader, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return syntaxReader.readWord(bl);
    }

    public final int readInt() {
        String tag = SyntaxReader.readWord$default(this, false, 1, null);
        try {
            int radix = 10;
            if (StringsKt.startsWith$default(tag, "0x", false, 2, null) || StringsKt.startsWith$default(tag, "0X", false, 2, null)) {
                String string = tag.substring(2);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                tag = string;
                radix = 16;
            }
            return Integer.parseInt(tag, CharsKt.checkRadix(radix));
        }
        catch (Exception exception) {
            throw SyntaxReader.unexpected$default(this, "expected an integer but was " + tag, null, 2, null);
        }
    }

    @NotNull
    public final String readDocumentation() {
        String result2 = null;
        while (true) {
            this.skipWhitespace(false);
            if (this.pos == this.data.length || this.data[this.pos] != '/') {
                String string = result2;
                if (string == null) {
                    string = "";
                }
                return string;
            }
            String comment = this.readComment();
            result2 = result2 == null ? comment : result2 + '\n' + comment;
        }
    }

    private final String readComment() {
        int n;
        if (!(this.pos != this.data.length && this.data[this.pos] == '/')) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        int n2 = this.pos;
        this.pos = n2 + 1;
        if (this.pos < this.data.length) {
            int n3 = this.pos;
            this.pos = n3 + 1;
            n = this.data[n3];
        } else {
            n = -1;
        }
        switch (n) {
            case 42: {
                StringBuilder result2 = new StringBuilder();
                boolean startOfLine = true;
                while (this.pos + 1 < this.data.length) {
                    char c = this.data[this.pos];
                    if (c == '*' && this.data[this.pos + 1] == '/') {
                        this.pos += 2;
                        String string = result2.toString();
                        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                        return ((Object)StringsKt.trim((CharSequence)string)).toString();
                    }
                    if (c == '\n') {
                        result2.append('\n');
                        this.newline();
                        startOfLine = true;
                    } else if (!startOfLine) {
                        result2.append(c);
                    } else if (c == '*') {
                        if (this.data[this.pos + 1] == ' ') {
                            // empty if block
                        }
                        startOfLine = false;
                    } else if (!CharsKt.isWhitespace(c)) {
                        result2.append(c);
                        startOfLine = false;
                    }
                    int n4 = ++this.pos;
                    this.pos = n4 + 1;
                }
                throw SyntaxReader.unexpected$default(this, "unterminated comment", null, 2, null);
            }
            case 47: {
                if (this.pos < this.data.length && this.data[this.pos] == ' ') {
                    int result2 = this.pos;
                    this.pos = result2 + 1;
                }
                int start = this.pos;
                while (this.pos < this.data.length) {
                    int n5 = this.pos;
                    this.pos = n5 + 1;
                    char c = this.data[n5];
                    if (c != '\n') continue;
                    this.newline();
                    break;
                }
                return StringsKt.concatToString(this.data, start, this.pos - 1);
            }
        }
        throw SyntaxReader.unexpected$default(this, "unexpected '/'", null, 2, null);
    }

    @NotNull
    public final String tryAppendTrailingDocumentation(@NotNull String documentation) {
        int end;
        int start;
        block19: {
            char c;
            Intrinsics.checkNotNullParameter(documentation, "documentation");
            block4: while (this.pos < this.data.length) {
                switch (this.data[this.pos]) {
                    case '\t': 
                    case ' ': {
                        int n = this.pos;
                        this.pos = n + 1;
                        continue block4;
                    }
                    case '/': {
                        int n = this.pos;
                        this.pos = n + 1;
                        break block4;
                    }
                    default: {
                        return documentation;
                    }
                }
            }
            boolean condition$iv = this.pos < this.data.length && (this.data[this.pos] == '/' || this.data[this.pos] == '*');
            Location location$iv22 = this.location();
            boolean $i$f$expect = false;
            if (!condition$iv) {
                SyntaxReader syntaxReader = this;
                boolean bl = false;
                int n = this.pos;
                this.pos = n + -1;
                throw syntaxReader.unexpected("expected '//' or '/*'", location$iv22);
            }
            boolean isStar = this.data[this.pos] == '*';
            int location$iv22 = this.pos;
            this.pos = location$iv22 + 1;
            if (this.pos < this.data.length && this.data[this.pos] == ' ') {
                location$iv22 = this.pos;
                this.pos = location$iv22 + 1;
            }
            start = this.pos;
            end = 0;
            if (isStar) {
                while (true) {
                    int condition$iv2 = this.pos < this.data.length ? 1 : 0;
                    Location location$iv = this.location();
                    boolean $i$f$expect2 = false;
                    if (condition$iv2 == 0) {
                        SyntaxReader syntaxReader = this;
                        boolean bl = false;
                        throw syntaxReader.unexpected("trailing comment must be closed", location$iv);
                    }
                    if (this.data[this.pos] == '*' && this.pos + 1 < this.data.length && this.data[this.pos + 1] == '/') {
                        end = this.pos - 1;
                        this.pos += 2;
                        break;
                    }
                    condition$iv2 = this.pos;
                    this.pos = condition$iv2 + 1;
                }
                while (this.pos < this.data.length) {
                    int location$iv = this.pos;
                    this.pos = location$iv + 1;
                    c = this.data[location$iv];
                    if (c == '\n') {
                        this.newline();
                        break;
                    }
                    boolean condition$iv3 = c == ' ' || c == '\t';
                    Location location$iv3 = this.location();
                    boolean $i$f$expect3 = false;
                    if (condition$iv3) continue;
                    SyntaxReader syntaxReader = this;
                    boolean bl = false;
                    throw syntaxReader.unexpected("no syntax may follow trailing comment", location$iv3);
                }
            } else {
                int n;
                do {
                    if (this.pos == this.data.length) {
                        end = this.pos - 1;
                        break block19;
                    }
                    n = this.pos;
                    this.pos = n + 1;
                } while ((c = this.data[n]) != '\n');
                this.newline();
                end = this.pos - 2;
            }
        }
        while (end > start && (this.data[end] == ' ' || this.data[end] == '\t')) {
            --end;
        }
        if (end == start) {
            return documentation;
        }
        String trailingDocumentation = StringsKt.concatToString(this.data, start, end + 1);
        if (((CharSequence)documentation).length() == 0) {
            return trailingDocumentation;
        }
        return documentation + '\n' + trailingDocumentation;
    }

    private final void skipWhitespace(boolean skipComments) {
        while (this.pos < this.data.length) {
            char c = this.data[this.pos];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                int n = this.pos;
                this.pos = n + 1;
                if (c != '\n') continue;
                this.newline();
                continue;
            }
            if (skipComments && c == '/') {
                this.readComment();
                continue;
            }
            return;
        }
    }

    private final void newline() {
        int n = this.line;
        this.line = n + 1;
        this.lineStart = this.pos;
    }

    @NotNull
    public final Location location() {
        return this.location.at(this.line + 1, this.pos - this.lineStart + 1);
    }

    public final void expect(boolean condition, @NotNull Location location, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(message, "message");
        boolean $i$f$expect = false;
        if (!condition) {
            throw this.unexpected(message.invoke(), location);
        }
    }

    public static /* synthetic */ void expect$default(SyntaxReader $this, boolean condition, Location location, Function0 message, int n, Object object) {
        if ((n & 2) != 0) {
            location = $this.location();
        }
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(message, "message");
        boolean $i$f$expect = false;
        if (!condition) {
            throw $this.unexpected((String)message.invoke(), location);
        }
    }

    @NotNull
    public final RuntimeException unexpected(@NotNull String message, @Nullable Location location) {
        Intrinsics.checkNotNullParameter(message, "message");
        throw new IllegalStateException("Syntax error in " + location + ": " + message);
    }

    public static /* synthetic */ RuntimeException unexpected$default(SyntaxReader syntaxReader, String string, Location location, int n, Object object) {
        if ((n & 2) != 0) {
            location = syntaxReader.location();
        }
        return syntaxReader.unexpected(string, location);
    }
}

