/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.CoreLoaderKt;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaHandler;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Target;
import com.squareup.wire.schema.Type;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J4\u0010\u0014\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/squareup/wire/schema/ProtoTarget;", "Lcom/squareup/wire/schema/Target;", "outDirectory", "", "<init>", "(Ljava/lang/String;)V", "getOutDirectory", "()Ljava/lang/String;", "includes", "", "getIncludes", "()Ljava/util/List;", "excludes", "getExcludes", "exclusive", "", "getExclusive", "()Z", "newHandler", "Lcom/squareup/wire/schema/SchemaHandler;", "copyTarget", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "wire-compiler"})
public final class ProtoTarget
extends Target {
    @NotNull
    private final String outDirectory;
    @NotNull
    private final List<String> includes;
    @NotNull
    private final List<String> excludes;
    private final boolean exclusive;

    public ProtoTarget(@NotNull String outDirectory) {
        Intrinsics.checkNotNullParameter(outDirectory, "outDirectory");
        this.outDirectory = outDirectory;
        this.includes = CollectionsKt.emptyList();
        this.excludes = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public String getOutDirectory() {
        return this.outDirectory;
    }

    @Override
    @NotNull
    public List<String> getIncludes() {
        return this.includes;
    }

    @Override
    @NotNull
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean getExclusive() {
        return this.exclusive;
    }

    @Override
    @NotNull
    public SchemaHandler newHandler() {
        return new SchemaHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void handle(Schema schema, SchemaHandler.Context context) {
                Intrinsics.checkNotNullParameter(schema, "schema");
                Intrinsics.checkNotNullParameter(context, "context");
                context.getFileSystem().createDirectories(context.getOutDirectory());
                Path outDirectory = context.getOutDirectory();
                Iterator<ProtoFile> iterator2 = schema.getProtoFiles().iterator();
                while (iterator2.hasNext()) {
                    ProtoFile protoFile = iterator2.next();
                    if (!context.inSourcePath(protoFile) || this.isEmpty(protoFile) || CoreLoaderKt.isWireRuntimeProto(protoFile.getLocation().getPath())) continue;
                    String relativePath = StringsKt.substringBeforeLast(protoFile.getLocation().getPath(), "/", ".");
                    Path outputDirectory = outDirectory.resolve(relativePath);
                    Path outputFilePath = outputDirectory.resolve(protoFile.name() + ".proto");
                    context.getLogger().artifactHandled(outputDirectory, protoFile.getLocation().getPath(), "Proto");
                    try {
                        BufferedSink bufferedSink;
                        Throwable thrown$iv$iv;
                        block18: {
                            FileSystem fileSystem = context.getFileSystem();
                            Path path = outputFilePath.parent();
                            Intrinsics.checkNotNull(path);
                            fileSystem.createDirectories(path);
                            FileSystem $this$iv = context.getFileSystem();
                            boolean mustCreate$iv = false;
                            boolean bl = false;
                            Closeable $this$use$iv$iv = Okio.buffer($this$iv.sink(outputFilePath, mustCreate$iv));
                            boolean $i$f$use = false;
                            thrown$iv$iv = null;
                            try {
                                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                                boolean bl2 = false;
                                BufferedSink $this$handle_u24lambda_u240 = it$iv;
                                boolean bl3 = false;
                                bufferedSink = $this$handle_u24lambda_u240.writeUtf8(protoFile.toSchema());
                            }
                            catch (Throwable t$iv$iv) {
                                try {
                                    thrown$iv$iv = t$iv$iv;
                                    bufferedSink = null;
                                    break block18;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    block19: {
                                        try {
                                            Closeable closeable = $this$use$iv$iv;
                                            if (closeable != null) {
                                                closeable.close();
                                            }
                                        }
                                        catch (Throwable t$iv$iv2) {
                                            if (thrown$iv$iv == null) {
                                                thrown$iv$iv = t$iv$iv2;
                                                break block19;
                                            }
                                            ExceptionsKt.addSuppressed(thrown$iv$iv, t$iv$iv2);
                                        }
                                    }
                                }
                            }
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv) {
                                thrown$iv$iv = t$iv$iv;
                            }
                        }
                        BufferedSink result$iv$iv = bufferedSink;
                        Throwable throwable = thrown$iv$iv;
                        if (throwable != null) {
                            throw throwable;
                        }
                        BufferedSink bufferedSink2 = result$iv$iv;
                    }
                    catch (IOException e) {
                        throw new IOException("Error emitting " + outputFilePath + " to " + outDirectory, e);
                    }
                }
            }

            private final boolean isEmpty(ProtoFile $this$isEmpty) {
                return $this$isEmpty.getTypes().isEmpty() && $this$isEmpty.getServices().isEmpty() && $this$isEmpty.getExtendList().isEmpty();
            }

            public Path handle(Type type, SchemaHandler.Context context) {
                Intrinsics.checkNotNullParameter(type, "type");
                Intrinsics.checkNotNullParameter(context, "context");
                return null;
            }

            public List<Path> handle(Service service, SchemaHandler.Context context) {
                Intrinsics.checkNotNullParameter(service, "service");
                Intrinsics.checkNotNullParameter(context, "context");
                return CollectionsKt.emptyList();
            }

            public Path handle(Extend extend, Field field, SchemaHandler.Context context) {
                Intrinsics.checkNotNullParameter(extend, "extend");
                Intrinsics.checkNotNullParameter(field, "field");
                Intrinsics.checkNotNullParameter(context, "context");
                return null;
            }
        };
    }

    @Override
    @NotNull
    public Target copyTarget(@NotNull List<String> includes, @NotNull List<String> excludes, boolean exclusive, @NotNull String outDirectory) {
        Intrinsics.checkNotNullParameter(includes, "includes");
        Intrinsics.checkNotNullParameter(excludes, "excludes");
        Intrinsics.checkNotNullParameter(outDirectory, "outDirectory");
        return this.copy(outDirectory);
    }

    @NotNull
    public final String component1() {
        return this.outDirectory;
    }

    @NotNull
    public final ProtoTarget copy(@NotNull String outDirectory) {
        Intrinsics.checkNotNullParameter(outDirectory, "outDirectory");
        return new ProtoTarget(outDirectory);
    }

    public static /* synthetic */ ProtoTarget copy$default(ProtoTarget protoTarget, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = protoTarget.outDirectory;
        }
        return protoTarget.copy(string);
    }

    @NotNull
    public String toString() {
        return "ProtoTarget(outDirectory=" + this.outDirectory + ')';
    }

    public int hashCode() {
        return this.outDirectory.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProtoTarget)) {
            return false;
        }
        ProtoTarget protoTarget = (ProtoTarget)other;
        return Intrinsics.areEqual(this.outDirectory, protoTarget.outDirectory);
    }
}

