/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.CycleChecker;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.ErrorCollector;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.FileLinker;
import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Reserved;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SyntaxRules;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.UtilJVMKt;
import com.squareup.wire.schema.internal.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u000eB\u0019\b\u0012\u0012\u0006\u0010\u000f\u001a\u00020\u0000\u0012\u0006\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\u0004\b\f\u0010\u0011J\u0015\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b'J\u0014\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+J\u000e\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u0014J\u000e\u0010/\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u0014J\u0018\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u0007H\u0002J/\u00101\u001a\u0004\u0018\u0001H2\"\u0004\b\u0000\u001022\u0006\u0010.\u001a\u00020\u00142\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H204\u00a2\u0006\u0002\u00105J\u0006\u00106\u001a\u00020\u0014J\u0013\u00107\u001a\b\u0012\u0004\u0012\u00020\u00150\nH\u0000\u00a2\u0006\u0002\b8J\u0016\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\u001bJ\u0010\u0010=\u001a\u0004\u0018\u00010\u001b2\u0006\u0010;\u001a\u00020\u000bJ\u0010\u0010>\u001a\u0004\u0018\u00010\u001b2\u0006\u0010;\u001a\u00020\u000bJ\u000e\u0010?\u001a\u00020:2\u0006\u0010@\u001a\u00020 J\u0018\u0010A\u001a\u0004\u0018\u00010 2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020\u0014J*\u0010B\u001a\u00020:2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020 0+2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\n2\u0006\u0010F\u001a\u00020GJ\b\u0010H\u001a\u00020:H\u0002J\u0016\u0010I\u001a\u00020:2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00150\nH\u0002J\u0014\u0010J\u001a\u00020:2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001b0+J\u0016\u0010L\u001a\u00020:2\u0006\u0010M\u001a\u00020N2\u0006\u0010<\u001a\u00020\u000bJ\u0016\u0010O\u001a\u00020:2\u0006\u0010M\u001a\u00020N2\u0006\u0010P\u001a\u00020\u0014J\u000e\u0010Q\u001a\u00020\u00002\u0006\u0010R\u001a\u00020\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0017j\b\u0012\u0004\u0012\u00020\u0015`\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006S"}, d2={"Lcom/squareup/wire/schema/Linker;", "", "loader", "Lcom/squareup/wire/schema/Loader;", "errors", "Lcom/squareup/wire/schema/ErrorCollector;", "permitPackageCycles", "", "loadExhaustively", "opaqueTypes", "", "Lcom/squareup/wire/schema/ProtoType;", "<init>", "(Lcom/squareup/wire/schema/Loader;Lcom/squareup/wire/schema/ErrorCollector;ZZLjava/util/List;)V", "(Lcom/squareup/wire/schema/Loader;Lcom/squareup/wire/schema/ErrorCollector;ZZ)V", "enclosing", "additionalContext", "(Lcom/squareup/wire/schema/Linker;Ljava/lang/Object;)V", "fileLinkers", "", "", "Lcom/squareup/wire/schema/FileLinker;", "fileOptionsQueue", "Ljava/util/Queue;", "Lcom/squareup/wire/schema/internal/MutableQueue;", "Ljava/util/Queue;", "protoTypeNames", "Lcom/squareup/wire/schema/Type;", "contextStack", "requestedTypes", "", "requestedFields", "Lcom/squareup/wire/schema/Field;", "getLoadExhaustively", "()Z", "getErrors", "()Lcom/squareup/wire/schema/ErrorCollector;", "getFileLinker", "path", "getFileLinker$wire_schema", "link", "Lcom/squareup/wire/schema/Schema;", "sourceProtoFiles", "", "Lcom/squareup/wire/schema/ProtoFile;", "resolveType", "name", "resolveMessageType", "messageOnly", "resolve", "T", "map", "", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/Object;", "resolveContext", "contextImportedTypes", "contextImportedTypes$wire_schema", "addType", "", "protoType", "type", "get", "getForOptions", "request", "field", "dereference", "validateFields", "fields", "reserveds", "Lcom/squareup/wire/schema/Reserved;", "syntaxRules", "Lcom/squareup/wire/schema/SyntaxRules;", "validatePackages", "validateTypeUniqueness", "validateEnumConstantNameUniqueness", "nestedTypes", "validateImportForType", "location", "Lcom/squareup/wire/schema/Location;", "validateImportForPath", "requiredImport", "withContext", "context", "wire-schema"})
@SourceDebugExtension(value={"SMAP\nLinker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Linker.kt\ncom/squareup/wire/schema/Linker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,593:1\n1010#2,2:594\n1755#2,3:596\n1755#2,2:599\n1755#2,3:601\n1757#2:604\n1872#2,3:626\n1872#2,3:629\n1872#2,3:632\n1485#2:635\n1510#2,3:636\n1513#2,3:646\n1368#2:649\n1454#2,5:650\n1368#2:655\n1454#2,2:656\n1557#2:658\n1628#2,3:659\n1456#2,3:662\n1485#2:665\n1510#2,3:666\n1513#2,3:676\n774#2:679\n865#2,2:680\n1872#2,3:682\n1872#2,3:693\n381#3,7:605\n381#3,7:612\n381#3,7:619\n381#3,7:639\n381#3,7:669\n381#3,7:685\n1#4:692\n*S KotlinDebug\n*F\n+ 1 Linker.kt\ncom/squareup/wire/schema/Linker\n*L\n141#1:594,2\n199#1:596,3\n203#1:599,2\n204#1:601,3\n203#1:604\n467#1:626,3\n481#1:629,3\n493#1:632,3\n504#1:635\n504#1:636,3\n504#1:646,3\n510#1:649\n510#1:650,5\n517#1:655\n517#1:656,2\n517#1:658\n517#1:659,3\n517#1:662,3\n518#1:665\n518#1:666,3\n518#1:676,3\n519#1:679\n519#1:680,2\n525#1:682,3\n547#1:693,3\n451#1:605,7\n452#1:612,7\n456#1:619,7\n504#1:639,7\n518#1:669,7\n538#1:685,7\n*E\n"})
public final class Linker {
    @NotNull
    private final Loader loader;
    @NotNull
    private final Map<String, FileLinker> fileLinkers;
    @NotNull
    private final Queue<FileLinker> fileOptionsQueue;
    @NotNull
    private final Map<String, Type> protoTypeNames;
    @NotNull
    private final List<Object> contextStack;
    @NotNull
    private final Set<ProtoType> requestedTypes;
    @NotNull
    private final Set<Field> requestedFields;
    private final boolean permitPackageCycles;
    @NotNull
    private final List<ProtoType> opaqueTypes;
    private final boolean loadExhaustively;
    @NotNull
    private final ErrorCollector errors;

    public final boolean getLoadExhaustively() {
        return this.loadExhaustively;
    }

    @NotNull
    public final ErrorCollector getErrors() {
        return this.errors;
    }

    public Linker(@NotNull Loader loader, @NotNull ErrorCollector errors, boolean permitPackageCycles, boolean loadExhaustively, @NotNull List<ProtoType> opaqueTypes) {
        Intrinsics.checkNotNullParameter(loader, "loader");
        Intrinsics.checkNotNullParameter(errors, "errors");
        Intrinsics.checkNotNullParameter(opaqueTypes, "opaqueTypes");
        this.loader = loader;
        this.fileLinkers = new LinkedHashMap();
        this.fileOptionsQueue = UtilJVMKt.mutableQueueOf();
        this.protoTypeNames = new LinkedHashMap();
        this.contextStack = CollectionsKt.emptyList();
        this.requestedTypes = new LinkedHashSet();
        this.requestedFields = new LinkedHashSet();
        this.errors = errors;
        this.permitPackageCycles = permitPackageCycles;
        this.loadExhaustively = loadExhaustively;
        this.opaqueTypes = opaqueTypes;
    }

    public Linker(@NotNull Loader loader, @NotNull ErrorCollector errors, boolean permitPackageCycles, boolean loadExhaustively) {
        Intrinsics.checkNotNullParameter(loader, "loader");
        Intrinsics.checkNotNullParameter(errors, "errors");
        this(loader, errors, permitPackageCycles, loadExhaustively, CollectionsKt.emptyList());
    }

    private Linker(Linker enclosing, Object additionalContext) {
        this.loader = enclosing.loader;
        this.fileLinkers = enclosing.fileLinkers;
        this.fileOptionsQueue = enclosing.fileOptionsQueue;
        this.protoTypeNames = enclosing.protoTypeNames;
        this.contextStack = CollectionsKt.plus((Collection)enclosing.contextStack, additionalContext);
        this.requestedTypes = enclosing.requestedTypes;
        this.requestedFields = enclosing.requestedFields;
        this.errors = enclosing.errors.at(additionalContext);
        this.permitPackageCycles = false;
        this.loadExhaustively = enclosing.loadExhaustively;
        this.opaqueTypes = enclosing.opaqueTypes;
    }

    @NotNull
    public final FileLinker getFileLinker$wire_schema(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        FileLinker existing = this.fileLinkers.get(path);
        if (existing != null) {
            return existing;
        }
        ProtoFile protoFile = this.loader.withErrors(this.errors).load(path);
        FileLinker result2 = new FileLinker(protoFile, this.withContext(protoFile));
        this.fileLinkers.put(path, result2);
        ((Collection)this.fileOptionsQueue).add(result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Schema link(@NotNull Iterable<ProtoFile> sourceProtoFiles) {
        SyntaxRules syntaxRules;
        Intrinsics.checkNotNullParameter(sourceProtoFiles, "sourceProtoFiles");
        List sourceFiles = new ArrayList();
        for (ProtoFile sourceFile : sourceProtoFiles) {
            FileLinker fileLinker = new FileLinker(sourceFile, this.withContext(sourceFile));
            this.fileLinkers.put(sourceFile.getLocation().getPath(), fileLinker);
            ((Collection)sourceFiles).add(fileLinker);
        }
        if (this.fileLinkers.get("google/protobuf/descriptor.proto") == null) {
            ((Collection)sourceFiles).add(this.getFileLinker$wire_schema("google/protobuf/descriptor.proto"));
        }
        if (this.fileLinkers.get("wire/extensions.proto") == null) {
            ((Collection)sourceFiles).add(this.getFileLinker$wire_schema("wire/extensions.proto"));
        }
        if (this.loadExhaustively) {
            Queue queue = UtilJVMKt.mutableQueueOf();
            CollectionsKt.addAll((Collection)queue, (Iterable)this.fileLinkers.values());
            while ((FileLinker)queue.poll() != null) {
                FileLinker fileLinker;
                for (String importPath : CollectionsKt.plus((Collection)fileLinker.getProtoFile().getImports(), (Iterable)fileLinker.getProtoFile().getPublicImports())) {
                    if (this.fileLinkers.containsKey(importPath)) continue;
                    FileLinker imported = this.withContext(fileLinker.getProtoFile()).getFileLinker$wire_schema(importPath);
                    ((Collection)sourceFiles).add(imported);
                    ((Collection)queue).add(imported);
                }
            }
        }
        Iterator $this$sortBy$iv = sourceFiles;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    FileLinker it = (FileLinker)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getProtoFile().getLocation().getPath());
                    it = (FileLinker)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getProtoFile().getLocation().getPath()));
                }
            });
        }
        for (FileLinker fileLinker : sourceFiles) {
            fileLinker.requireTypesRegistered();
        }
        for (FileLinker fileLinker : sourceFiles) {
            fileLinker.requireExtensionsLinked();
        }
        for (FileLinker fileLinker : sourceFiles) {
            fileLinker.requireImportedExtensionsRegistered();
        }
        for (FileLinker fileLinker : sourceFiles) {
            fileLinker.linkMembers();
        }
        for (FileLinker fileLinker : sourceFiles) {
            syntaxRules = SyntaxRules.Companion.get(fileLinker.getProtoFile().getSyntax());
            fileLinker.linkOptions(syntaxRules, true);
        }
        for (FileLinker fileLinker : sourceFiles) {
            fileLinker.requireImportedExtensionOptionsLinked(false);
        }
        while (!((Collection)this.fileOptionsQueue).isEmpty()) {
            Object fileLinker;
            Intrinsics.checkNotNull(this.fileOptionsQueue.poll());
            ((FileLinker)fileLinker).requireFileOptionsLinked(false);
        }
        this.validatePackages();
        for (FileLinker fileLinker : sourceFiles) {
            syntaxRules = SyntaxRules.Companion.get(fileLinker.getProtoFile().getSyntax());
            fileLinker.validate(syntaxRules);
        }
        CycleChecker cycleChecker = new CycleChecker(this.fileLinkers, this.errors);
        cycleChecker.checkForImportCycles();
        if (!this.permitPackageCycles) {
            cycleChecker.checkForPackageCycles();
        }
        this.errors.throwIfNonEmpty();
        List result2 = new ArrayList();
        for (FileLinker fileLinker : this.fileLinkers.values()) {
            boolean anyFieldIsUsed;
            boolean anyTypeIsUsed;
            block29: {
                boolean bl;
                void $this$any$iv;
                boolean bl2;
                block27: {
                    void $this$any$iv2;
                    if (sourceFiles.contains(fileLinker)) {
                        result2.add(fileLinker.getProtoFile());
                        continue;
                    }
                    Iterable iterable = fileLinker.getProtoFile().typesAndNestedTypes();
                    boolean $i$f$any = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv2) {
                            Type type = (Type)element$iv;
                            boolean bl3 = false;
                            if (!this.requestedTypes.contains(type.getType())) continue;
                            bl2 = true;
                            break block27;
                        }
                        bl2 = false;
                    }
                }
                anyTypeIsUsed = bl2;
                Iterable $i$f$any = fileLinker.getProtoFile().getExtendList();
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl3;
                        block28: {
                            Extend extend = (Extend)element$iv;
                            boolean bl5 = false;
                            Iterable $this$any$iv3 = extend.getFields();
                            boolean $i$f$any3 = false;
                            if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv3) {
                                    Field it = (Field)element$iv2;
                                    boolean bl6 = false;
                                    if (!this.requestedFields.contains(it)) continue;
                                    bl3 = true;
                                    break block28;
                                }
                                bl3 = false;
                            }
                        }
                        if (!bl3) continue;
                        bl = true;
                        break block29;
                    }
                    bl = anyFieldIsUsed = false;
                }
            }
            if (!anyTypeIsUsed && !anyFieldIsUsed) continue;
            result2.add(fileLinker.getProtoFile().retainLinked(CollectionsKt.toSet((Iterable)this.requestedTypes), this.requestedFields));
        }
        return new Schema(result2);
    }

    @NotNull
    public final ProtoType resolveType(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.resolveType(name, false);
    }

    @NotNull
    public final ProtoType resolveMessageType(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.resolveType(name, true);
    }

    private final ProtoType resolveType(String name, boolean messageOnly) {
        ProtoType type = ProtoType.Companion.get(name);
        if (type.isScalar()) {
            if (messageOnly) {
                this.errors.plusAssign("expected a message but was " + name);
            }
            if (this.opaqueTypes.contains(type)) {
                this.errors.plusAssign("Scalar types like " + type + " cannot be opaqued");
            }
            return type;
        }
        if (type.isMap()) {
            if (messageOnly) {
                this.errors.plusAssign("expected a message but was " + name);
            }
            ProtoType keyType = this.resolveType(String.valueOf(type.getKeyType()), false);
            ProtoType valueType = this.resolveType(String.valueOf(type.getValueType()), false);
            return ProtoType.Companion.get(keyType, valueType, name);
        }
        Type resolved = this.resolve(name, this.protoTypeNames);
        if (resolved == null) {
            for (FileLinker fileLinker : this.contextImportedTypes$wire_schema()) {
                fileLinker.requireTypesRegistered();
            }
            resolved = this.resolve(name, this.protoTypeNames);
        }
        if (resolved == null) {
            this.errors.plusAssign("unable to resolve " + name);
            return ProtoType.BYTES;
        }
        if (messageOnly && !(resolved instanceof MessageType)) {
            this.errors.plusAssign("expected a message but was " + name);
            return ProtoType.BYTES;
        }
        ProtoType protoType = resolved.getType();
        if (this.opaqueTypes.contains(protoType)) {
            if (resolved instanceof EnumType) {
                this.errors.plusAssign("Enums like " + ((EnumType)resolved).getType() + " cannot be opaqued");
                return ((EnumType)resolved).getType();
            }
            return ProtoType.BYTES;
        }
        this.requestedTypes.add(resolved.getType());
        return resolved.getType();
    }

    @Nullable
    public final <T> T resolve(@NotNull String name, @NotNull Map<String, ? extends T> map2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(map2, "map");
        if (StringsKt.startsWith$default(name, ".", false, 2, null)) {
            T result2;
            String string = name.substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            T t2 = result2 = map2.get(string);
            if (t2 != null) {
                return t2;
            }
        } else {
            T result3;
            String prefix = this.resolveContext();
            while (((CharSequence)prefix).length() > 0) {
                String string;
                T t3 = result3 = map2.get(prefix + '.' + name);
                if (t3 != null) {
                    return t3;
                }
                int dot = StringsKt.lastIndexOf$default((CharSequence)prefix, '.', 0, false, 6, null);
                if (dot != -1) {
                    String string2 = prefix.substring(0, dot);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                } else {
                    string = "";
                }
                prefix = string;
            }
            result3 = map2.get(name);
            if (result3 != null) {
                return result3;
            }
        }
        return null;
    }

    @NotNull
    public final String resolveContext() {
        int n = ((Collection)this.contextStack).size() + -1;
        if (0 <= n) {
            do {
                int i;
                Object context;
                if ((context = this.contextStack.get(i = n--)) instanceof Type) {
                    return ((Type)context).getType().toString();
                }
                if (!(context instanceof ProtoFile)) continue;
                String packageName = ((ProtoFile)context).getPackageName();
                String string = packageName;
                if (string == null) {
                    string = "";
                }
                return string;
            } while (0 <= n);
        }
        throw new IllegalStateException();
    }

    @NotNull
    public final List<FileLinker> contextImportedTypes$wire_schema() {
        List result2 = new ArrayList();
        int n = ((Collection)this.contextStack).size() + -1;
        if (0 <= n) {
            do {
                Location location;
                int i = n--;
                Object context = this.contextStack.get(i);
                Location location2 = context instanceof ProtoFile ? ((ProtoFile)context).getLocation() : (location = context instanceof Field && ((Field)context).isExtension() ? ((Field)context).getLocation() : null);
                if (location == null) continue;
                String path = location.getPath();
                FileLinker fileLinker = this.getFileLinker$wire_schema(path);
                for (String effectiveImport : fileLinker.effectiveImports()) {
                    result2.add(this.getFileLinker$wire_schema(effectiveImport));
                }
            } while (0 <= n);
        }
        return result2;
    }

    public final void addType(@NotNull ProtoType protoType, @NotNull Type type) {
        Intrinsics.checkNotNullParameter(protoType, "protoType");
        Intrinsics.checkNotNullParameter(type, "type");
        this.protoTypeNames.put(protoType.toString(), type);
    }

    @Nullable
    public final Type get(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter(protoType, "protoType");
        Type result2 = this.protoTypeNames.get(protoType.toString());
        if (result2 == null) {
            for (FileLinker fileLinker : this.contextImportedTypes$wire_schema()) {
                fileLinker.requireTypesRegistered();
            }
            result2 = this.protoTypeNames.get(protoType.toString());
        }
        if (result2 != null) {
            this.requestedTypes.add(protoType);
        }
        return result2;
    }

    @Nullable
    public final Type getForOptions(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter(protoType, "protoType");
        Type type = this.get(protoType);
        if (type == null) {
            return null;
        }
        Type result2 = type;
        FileLinker fileLinker = this.getFileLinker$wire_schema(result2.getLocation().getPath());
        fileLinker.requireMembersLinked(result2);
        return result2;
    }

    public final void request(@NotNull Field field) {
        Intrinsics.checkNotNullParameter(field, "field");
        this.requestedFields.add(field);
    }

    @Nullable
    public final Field dereference(@NotNull ProtoType protoType, @NotNull String field) {
        Type type;
        Intrinsics.checkNotNullParameter(protoType, "protoType");
        Intrinsics.checkNotNullParameter(field, "field");
        String field2 = field;
        if (StringsKt.startsWith$default(field2, "[", false, 2, null) && StringsKt.endsWith$default(field2, "]", false, 2, null)) {
            String string = field2.substring(1, field2.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            field2 = string;
        }
        if ((type = this.getForOptions(protoType)) instanceof MessageType) {
            Field messageField;
            Field field3 = messageField = ((MessageType)type).field(field2);
            if (field3 != null) {
                return field3;
            }
            Map<String, Field> typeExtensions = ((MessageType)type).extensionFieldsMap();
            Field extensionField = this.resolve(field2, typeExtensions);
            if (extensionField != null) {
                return extensionField;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void validateFields(@NotNull Iterable<Field> fields2, @NotNull List<Reserved> reserveds, @NotNull SyntaxRules syntaxRules) {
        Field field;
        boolean bl;
        int n;
        StringBuilder error;
        Intrinsics.checkNotNullParameter(fields2, "fields");
        Intrinsics.checkNotNullParameter(reserveds, "reserveds");
        Intrinsics.checkNotNullParameter(syntaxRules, "syntaxRules");
        LinkedHashMap tagToField = new LinkedHashMap();
        LinkedHashMap nameToField = new LinkedHashMap();
        LinkedHashMap jsonNameToField = new LinkedHashMap();
        for (Field iterator2 : fields2) {
            Object object;
            Object object2;
            Set answer$iv;
            Map $this$getOrPut$iv;
            int tag = iterator2.getTag();
            if (!UtilKt.isValidTag(tag)) {
                this.errors.at(iterator2).plusAssign("tag is out of range: " + tag);
            }
            for (Reserved reserved : reserveds) {
                if (reserved.matchesTag(tag)) {
                    this.errors.at(iterator2).plusAssign("tag " + tag + " is reserved (" + reserved.getLocation() + ')');
                }
                if (!reserved.matchesName(iterator2.getName())) continue;
                this.errors.at(iterator2).plusAssign("name '" + iterator2.getName() + "' is reserved (" + reserved.getLocation() + ')');
            }
            Map map2 = tagToField;
            Object key$iv = tag;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ((Set)object2).add(iterator2);
            $this$getOrPut$iv = nameToField;
            key$iv = iterator2.getQualifiedName();
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl3 = false;
                answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(iterator2);
            if (!iterator2.isExtension()) {
                Object object3;
                $this$getOrPut$iv = jsonNameToField;
                key$iv = syntaxRules.jsonName(iterator2.getName(), iterator2.getDeclaredJsonName());
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl4 = false;
                    answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                ((Set)object3).add(iterator2);
            }
            ProtoType protoType = iterator2.getType();
            Intrinsics.checkNotNull(protoType);
            syntaxRules.validateTypeReference(this.get(protoType), this.errors.at(iterator2));
        }
        for (Map.Entry entry : ((Map)tagToField).entrySet()) {
            int key = ((Number)entry.getKey()).intValue();
            Set values2 = (Set)entry.getValue();
            if (values2.size() <= 1) continue;
            error = new StringBuilder();
            error.append("multiple fields share tag " + key + ':');
            Iterable $this$forEachIndexed$iv = values2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Field field2 = (Field)item$iv;
                int index = n;
                bl = false;
                error.append("\n  " + (index + 1) + ". " + field.getName() + " (" + field.getLocation() + ')');
            }
            String string = error.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            this.errors.plusAssign(string);
        }
        boolean hasCollidingFields = false;
        for (Object v : nameToField.values()) {
            Intrinsics.checkNotNullExpressionValue(v, "next(...)");
            Set collidingFields = (Set)v;
            if (collidingFields.size() <= 1) continue;
            hasCollidingFields = true;
            Field first2 = (Field)collidingFields.iterator().next();
            error = new StringBuilder();
            error.append("multiple fields share name " + first2.getName() + ':');
            Iterable $this$forEachIndexed$iv = collidingFields;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                field = (Field)item$iv;
                int index2 = n;
                bl = false;
                error.append("\n  " + (index2 + 1) + ". " + field.getName() + " (" + field.getLocation() + ')');
            }
            String string = error.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            this.errors.plusAssign(string);
        }
        if (!hasCollidingFields) {
            for (Map.Entry entry : ((Map)jsonNameToField).entrySet()) {
                String jsonName = (String)entry.getKey();
                Set fields3 = (Set)entry.getValue();
                if (fields3.size() <= 1) continue;
                StringBuilder error2 = new StringBuilder();
                error2.append("multiple fields share same JSON name '" + jsonName + "':");
                Iterable $this$forEachIndexed$iv = fields3;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void field4;
                    int n2;
                    if ((n2 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Field index2 = (Field)item$iv;
                    int index3 = n2;
                    boolean bl5 = false;
                    error2.append("\n  " + (index3 + 1) + ". " + field4.getName() + " (" + field4.getLocation() + ')');
                }
                String string = error2.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                this.errors.plusAssign(string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validatePackages() {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.fileLinkers.values();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            FileLinker it = (FileLinker)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getProtoFile().getPackageName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map filesByPackageName = destination$iv$iv;
        for (List fileLinkers : filesByPackageName.values()) {
            void $this$flatMapTo$iv$iv;
            this.validateTypeUniqueness(fileLinkers);
            Iterable $this$flatMap$iv = fileLinkers;
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                FileLinker it = (FileLinker)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getProtoFile().getTypes();
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            List types = (List)destination$iv$iv2;
            this.withContext(((FileLinker)fileLinkers.get(0)).getProtoFile()).validateEnumConstantNameUniqueness(types);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateTypeUniqueness(List<FileLinker> fileLinkers) {
        void $this$filterTo$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = fileLinkers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            FileLinker linker = (FileLinker)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = linker.getProtoFile().getTypes();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Type type = (Type)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to(it.getType(), it.getLocation()));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            list$iv$iv = (Pair)element$iv$iv;
            boolean bl = false;
            ProtoType type = (ProtoType)((Pair)list$iv$iv).component1();
            Location typeLocation = (Location)((Pair)list$iv$iv).component2();
            Pair<ProtoType, String> key$iv$iv = TuplesKt.to(type, typeLocation.toString());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = destination$iv$iv.values();
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List conflictingTypes = (List)destination$iv$iv;
        for (List typesAndLocations : conflictingTypes) {
            String error;
            StringBuilder stringBuilder;
            ProtoType type = (ProtoType)((Pair)CollectionsKt.first(typesAndLocations)).getFirst();
            StringBuilder $this$validateTypeUniqueness_u24lambda_u2417 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$validateTypeUniqueness_u24lambda_u2417.append("same type '" + type + "' from the same file loaded from different paths:");
            Iterable $this$forEachIndexed$iv = typesAndLocations;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = n;
                boolean bl4 = false;
                Location typeLocation = (Location)pair.component2();
                $this$validateTypeUniqueness_u24lambda_u2417.append("\n  " + (index + 1) + ". base:" + typeLocation.getBase() + ", path:" + Location.copy$default(typeLocation, "", null, 0, 0, 14, null));
            }
            Intrinsics.checkNotNullExpressionValue(stringBuilder.toString(), "toString(...)");
            this.errors.plusAssign(error);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void validateEnumConstantNameUniqueness(@NotNull Iterable<? extends Type> nestedTypes) {
        Intrinsics.checkNotNullParameter(nestedTypes, "nestedTypes");
        Map nameToType = new LinkedHashMap();
        for (Type entry : nestedTypes) {
            if (!(entry instanceof EnumType)) continue;
            for (EnumConstant enumConstant : ((EnumType)entry).getConstants()) {
                Set set;
                Set $this$getOrPut$iv;
                Map map2 = nameToType;
                String key$iv = enumConstant.getName();
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put((String)key$iv, (Set)answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                $this$getOrPut$iv = set;
                Set it = $this$getOrPut$iv;
                boolean bl = false;
                ((Collection)it).add(entry);
            }
        }
        for (Map.Entry entry : nameToType.entrySet()) {
            String error;
            StringBuilder stringBuilder;
            String constant = (String)entry.getKey();
            Set values2 = (Set)entry.getValue();
            if (values2.size() <= 1) continue;
            StringBuilder $this$validateEnumConstantNameUniqueness_u24lambda_u2421 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$validateEnumConstantNameUniqueness_u24lambda_u2421.append("multiple enums share constant " + constant + ':');
            Iterable $this$forEachIndexed$iv = values2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void enumType;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EnumType enumType2 = (EnumType)item$iv;
                int index = n;
                boolean bl2 = false;
                StringBuilder stringBuilder2 = new StringBuilder().append("\n  ").append(index + 1).append(". ").append(enumType.getType()).append('.').append(constant).append(" (");
                EnumConstant enumConstant = enumType.constant(constant);
                Intrinsics.checkNotNull(enumConstant);
                $this$validateEnumConstantNameUniqueness_u24lambda_u2421.append(stringBuilder2.append(enumConstant.getLocation()).append(')').toString());
            }
            Intrinsics.checkNotNullExpressionValue(stringBuilder.toString(), "toString(...)");
            this.errors.plusAssign(error);
        }
    }

    public final void validateImportForType(@NotNull Location location, @NotNull ProtoType type) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(type, "type");
        ProtoType type2 = type;
        if (type2.isMap()) {
            ProtoType protoType = type2.getValueType();
            Intrinsics.checkNotNull(protoType);
            type2 = protoType;
        }
        if (type2.isScalar()) {
            return;
        }
        String path = location.getPath();
        Type type3 = this.get(type2);
        Intrinsics.checkNotNull(type3);
        String requiredImport = type3.getLocation().getPath();
        FileLinker fileLinker = this.getFileLinker$wire_schema(path);
        if (!Intrinsics.areEqual(path, requiredImport) && !fileLinker.effectiveImports().contains(requiredImport)) {
            this.errors.plusAssign(path + " needs to import " + requiredImport);
        }
    }

    public final void validateImportForPath(@NotNull Location location, @NotNull String requiredImport) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(requiredImport, "requiredImport");
        String path = location.getPath();
        FileLinker fileLinker = this.getFileLinker$wire_schema(path);
        if (!Intrinsics.areEqual(path, requiredImport) && !fileLinker.effectiveImports().contains(requiredImport)) {
            this.errors.plusAssign(path + " needs to import " + requiredImport);
        }
    }

    @NotNull
    public final Linker withContext(@NotNull Object context) {
        Intrinsics.checkNotNullParameter(context, "context");
        return new Linker(this, context);
    }
}

