/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\u00020\u0007*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u0007*\u00020\fH\u0002J\f\u0010\u0011\u001a\u00020\u0007*\u00020\u000eH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/squareup/wire/schema/ClaimedPaths;", "", "<init>", "()V", "paths", "", "Lokio/Path;", "", "claim", "", "path", "type", "Lcom/squareup/wire/schema/Type;", "service", "Lcom/squareup/wire/schema/Service;", "extend", "Lcom/squareup/wire/schema/Extend;", "asErrorMessage", "wire-schema"})
public final class ClaimedPaths {
    @NotNull
    private final Map<Path, String> paths = new LinkedHashMap();

    public final void claim(@NotNull Path path, @NotNull Type type) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(type, "type");
        String errorMessage = this.asErrorMessage(type);
        String existingEntry = this.paths.get(path);
        if (!(existingEntry == null)) {
            boolean bl = false;
            String string = "Same file " + path + " is getting generated by different messages:\n  " + existingEntry + "\n  " + this.asErrorMessage(type);
            throw new IllegalStateException(string.toString());
        }
        this.paths.put(path, errorMessage);
    }

    public final void claim(@NotNull Path path, @NotNull Service service) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(service, "service");
        String errorMessage = this.asErrorMessage(service);
        String existingEntry = this.paths.get(path);
        if (!(existingEntry == null)) {
            boolean bl = false;
            String string = "Same file " + path + " is getting generated by different services:\n  " + existingEntry + "\n  " + this.asErrorMessage(service);
            throw new IllegalStateException(string.toString());
        }
        this.paths.put(path, errorMessage);
    }

    public final void claim(@NotNull Path path, @NotNull Extend extend) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(extend, "extend");
        String errorMessage = this.asErrorMessage(extend);
        String existingEntry = this.paths.get(path);
        if (!(existingEntry == null)) {
            boolean bl = false;
            String string = "Same file " + path + " is getting generated for different extends:\n  " + existingEntry + "\n  " + this.asErrorMessage(extend);
            throw new IllegalStateException(string.toString());
        }
        this.paths.put(path, errorMessage);
    }

    private final String asErrorMessage(Extend $this$asErrorMessage) {
        StringBuilder stringBuilder = new StringBuilder();
        ProtoType protoType = $this$asErrorMessage.getType();
        Intrinsics.checkNotNull(protoType);
        return stringBuilder.append(protoType.getSimpleName()).append('.').append(CollectionsKt.joinToString$default($this$asErrorMessage.getFields(), null, null, null, 0, null, null, 63, null)).append(" at ").append($this$asErrorMessage.getLocation()).toString();
    }

    private final String asErrorMessage(Type $this$asErrorMessage) {
        return $this$asErrorMessage.getType().getSimpleName() + " at " + $this$asErrorMessage.getLocation();
    }

    private final String asErrorMessage(Service $this$asErrorMessage) {
        return $this$asErrorMessage.type().getSimpleName() + " at " + $this$asErrorMessage.location();
    }
}

