/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.java;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import com.squareup.wire.EnumAdapter;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireEnumConstant;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import com.squareup.wire.schema.AdapterConstant;
import com.squareup.wire.schema.EnclosingType;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.Profile;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.JvmLanguages;
import com.squareup.wire.schema.internal.NameFactory;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import okio.ByteString;

public final class JavaGenerator {
    static final ClassName BYTE_STRING = ClassName.get(ByteString.class);
    static final ClassName STRING = ClassName.get(String.class);
    static final ClassName LIST = ClassName.get(List.class);
    static final ClassName MESSAGE = ClassName.get(Message.class);
    static final ClassName ANDROID_MESSAGE = MESSAGE.peerClass("AndroidMessage");
    static final ClassName ADAPTER = ClassName.get(ProtoAdapter.class);
    static final ClassName BUILDER = ClassName.get(Message.Builder.class);
    static final ClassName ENUM_ADAPTER = ClassName.get(EnumAdapter.class);
    static final ClassName NULLABLE = ClassName.get("androidx.annotation", "Nullable", new String[0]);
    static final ClassName CREATOR = ClassName.get("android.os", "Parcelable", "Creator");
    private static final Ordering<Field> TAG_ORDERING = Ordering.from(new Comparator<Field>(){

        @Override
        public int compare(Field o1, Field o2) {
            return Integer.compare(o1.getTag(), o2.getTag());
        }
    });
    private static final Map<ProtoType, TypeName> BUILT_IN_TYPES_MAP = ImmutableMap.builder().put(ProtoType.BOOL, TypeName.BOOLEAN).put(ProtoType.BYTES, ClassName.get(ByteString.class)).put(ProtoType.DOUBLE, TypeName.DOUBLE).put(ProtoType.FLOAT, TypeName.FLOAT).put(ProtoType.FIXED32, TypeName.INT).put(ProtoType.FIXED64, TypeName.LONG).put(ProtoType.INT32, TypeName.INT).put(ProtoType.INT64, TypeName.LONG).put(ProtoType.SFIXED32, TypeName.INT).put(ProtoType.SFIXED64, TypeName.LONG).put(ProtoType.SINT32, TypeName.INT).put(ProtoType.SINT64, TypeName.LONG).put(ProtoType.STRING, ClassName.get(String.class)).put(ProtoType.UINT32, TypeName.INT).put(ProtoType.UINT64, TypeName.LONG).put(ProtoType.ANY, ClassName.get("com.squareup.wire", "AnyMessage", new String[0])).put(ProtoType.DURATION, ClassName.get("java.time", "Duration", new String[0])).put(ProtoType.TIMESTAMP, ClassName.get("java.time", "Instant", new String[0])).put(ProtoType.EMPTY, ClassName.get("kotlin", "Unit", new String[0])).put(ProtoType.STRUCT_MAP, ParameterizedTypeName.get(ClassName.get("java.util", "Map", new String[0]), ClassName.get("java.lang", "String", new String[0]), WildcardTypeName.subtypeOf(Object.class))).put(ProtoType.STRUCT_VALUE, ClassName.get("java.lang", "Object", new String[0])).put(ProtoType.STRUCT_NULL, ClassName.get("java.lang", "Void", new String[0])).put(ProtoType.STRUCT_LIST, ParameterizedTypeName.get(ClassName.get("java.util", "List", new String[0]), WildcardTypeName.subtypeOf(Object.class))).put(ProtoType.DOUBLE_VALUE, TypeName.DOUBLE).put(ProtoType.FLOAT_VALUE, TypeName.FLOAT).put(ProtoType.INT64_VALUE, TypeName.LONG).put(ProtoType.UINT64_VALUE, TypeName.LONG).put(ProtoType.INT32_VALUE, TypeName.INT).put(ProtoType.UINT32_VALUE, TypeName.INT).put(ProtoType.BOOL_VALUE, TypeName.BOOLEAN).put(ProtoType.STRING_VALUE, ClassName.get(String.class)).put(ProtoType.BYTES_VALUE, ClassName.get(ByteString.class)).build();
    private static final Map<ProtoType, CodeBlock> PROTOTYPE_TO_IDENTITY_VALUES = ImmutableMap.builder().put(ProtoType.BOOL, CodeBlock.of("false", new Object[0])).put(ProtoType.STRING, CodeBlock.of("\"\"", new Object[0])).put(ProtoType.BYTES, CodeBlock.of("$T.$L", ByteString.class, "EMPTY")).put(ProtoType.DOUBLE, CodeBlock.of("0.0", new Object[0])).put(ProtoType.FLOAT, CodeBlock.of("0f", new Object[0])).put(ProtoType.FIXED64, CodeBlock.of("0L", new Object[0])).put(ProtoType.INT64, CodeBlock.of("0L", new Object[0])).put(ProtoType.SFIXED64, CodeBlock.of("0L", new Object[0])).put(ProtoType.SINT64, CodeBlock.of("0L", new Object[0])).put(ProtoType.UINT64, CodeBlock.of("0L", new Object[0])).put(ProtoType.FIXED32, CodeBlock.of("0", new Object[0])).put(ProtoType.INT32, CodeBlock.of("0", new Object[0])).put(ProtoType.SFIXED32, CodeBlock.of("0", new Object[0])).put(ProtoType.SINT32, CodeBlock.of("0", new Object[0])).put(ProtoType.UINT32, CodeBlock.of("0", new Object[0])).build();
    private static final String URL_CHARS = "[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]";
    private static final int MAX_PARAMS_IN_CONSTRUCTOR = 16;
    private static final String DOUBLE_FULL_BLOCK = "\u2588\u2588";
    private final LoadingCache<Type, NameAllocator> nameAllocators = CacheBuilder.newBuilder().build(new CacheLoader<Type, NameAllocator>(){

        @Override
        public NameAllocator load(Type type) throws Exception {
            NameAllocator nameAllocator;
            block4: {
                block3: {
                    nameAllocator = new NameAllocator();
                    if (!(type instanceof MessageType)) break block3;
                    nameAllocator.newName("serialVersionUID", "serialVersionUID");
                    nameAllocator.newName("ADAPTER", "ADAPTER");
                    nameAllocator.newName("MESSAGE_OPTIONS", "MESSAGE_OPTIONS");
                    if (JavaGenerator.this.emitAndroid) {
                        nameAllocator.newName("CREATOR", "CREATOR");
                    }
                    List<Field> fieldsAndOneOfFields = ((MessageType)type).getFieldsAndOneOfFields();
                    Set collidingNames = JavaGenerator.this.collidingFieldNames(fieldsAndOneOfFields);
                    for (Field field : fieldsAndOneOfFields) {
                        String suggestion = collidingNames.contains(field.getName()) || field.getName().equals(field.getType().getSimpleName()) && !field.getType().isScalar() || JvmLanguages.hasEponymousType(JavaGenerator.this.schema, field) ? JvmLanguages.legacyQualifiedFieldName(field) : field.getName();
                        nameAllocator.newName(suggestion, field);
                    }
                    break block4;
                }
                if (!(type instanceof EnumType)) break block4;
                nameAllocator.newName("value", "value");
                nameAllocator.newName("i", "i");
                nameAllocator.newName("reader", "reader");
                nameAllocator.newName("writer", "writer");
                for (EnumConstant constant : ((EnumType)type).getConstants()) {
                    nameAllocator.newName(constant.getName(), constant);
                }
            }
            return nameAllocator;
        }
    });
    private final Schema schema;
    private final ImmutableMap<ProtoType, TypeName> typeToJavaName;
    private final ImmutableMap<ProtoMember, TypeName> memberToJavaName;
    private final Profile profile;
    private final boolean emitAndroid;
    private final boolean emitAndroidAnnotations;
    private final boolean emitCompact;
    private final boolean emitDeclaredOptions;
    private final boolean emitAppliedOptions;
    private final boolean buildersOnly;

    public static boolean builtInType(ProtoType protoType) {
        return BUILT_IN_TYPES_MAP.containsKey(protoType);
    }

    private JavaGenerator(Schema schema, Map<ProtoType, TypeName> typeToJavaName, Map<ProtoMember, TypeName> memberToJavaName, Profile profile, boolean emitAndroid, boolean emitAndroidAnnotations, boolean emitCompact, boolean emitDeclaredOptions, boolean emitAppliedOptions, boolean buildersOnly) {
        this.schema = schema;
        this.typeToJavaName = ImmutableMap.copyOf(typeToJavaName);
        this.memberToJavaName = ImmutableMap.copyOf(memberToJavaName);
        this.profile = profile;
        this.emitAndroid = emitAndroid;
        this.emitAndroidAnnotations = emitAndroidAnnotations;
        this.emitCompact = emitCompact;
        this.emitDeclaredOptions = emitDeclaredOptions;
        this.emitAppliedOptions = emitAppliedOptions;
        this.buildersOnly = buildersOnly;
    }

    public JavaGenerator withAndroid(boolean emitAndroid) {
        return new JavaGenerator(this.schema, this.typeToJavaName, this.memberToJavaName, this.profile, emitAndroid, this.emitAndroidAnnotations, this.emitCompact, this.emitDeclaredOptions, this.emitAppliedOptions, this.buildersOnly);
    }

    public JavaGenerator withAndroidAnnotations(boolean emitAndroidAnnotations) {
        return new JavaGenerator(this.schema, this.typeToJavaName, this.memberToJavaName, this.profile, this.emitAndroid, emitAndroidAnnotations, this.emitCompact, this.emitDeclaredOptions, this.emitAppliedOptions, this.buildersOnly);
    }

    public JavaGenerator withCompact(boolean emitCompact) {
        return new JavaGenerator(this.schema, this.typeToJavaName, this.memberToJavaName, this.profile, this.emitAndroid, this.emitAndroidAnnotations, emitCompact, this.emitDeclaredOptions, this.emitAppliedOptions, this.buildersOnly);
    }

    public JavaGenerator withProfile(Profile profile) {
        return new JavaGenerator(this.schema, this.typeToJavaName, this.memberToJavaName, profile, this.emitAndroid, this.emitAndroidAnnotations, this.emitCompact, this.emitDeclaredOptions, this.emitAppliedOptions, this.buildersOnly);
    }

    public JavaGenerator withOptions(boolean emitDeclaredOptions, boolean emitAppliedOptions) {
        return new JavaGenerator(this.schema, this.typeToJavaName, this.memberToJavaName, this.profile, this.emitAndroid, this.emitAndroidAnnotations, this.emitCompact, emitDeclaredOptions, emitAppliedOptions, this.buildersOnly);
    }

    public JavaGenerator withBuildersOnly(boolean buildersOnly) {
        return new JavaGenerator(this.schema, this.typeToJavaName, this.memberToJavaName, this.profile, this.emitAndroid, this.emitAndroidAnnotations, this.emitCompact, this.emitDeclaredOptions, this.emitAppliedOptions, buildersOnly);
    }

    public static JavaGenerator get(Schema schema) {
        LinkedHashMap<ProtoType, TypeName> nameToJavaName = new LinkedHashMap<ProtoType, TypeName>();
        LinkedHashMap<ProtoMember, TypeName> memberToJavaName = new LinkedHashMap<ProtoMember, TypeName>();
        for (ProtoFile protoFile : schema.getProtoFiles()) {
            String javaPackage = JvmLanguages.javaPackage(protoFile);
            JavaGenerator.putAll(nameToJavaName, javaPackage, null, protoFile.getTypes());
            for (Service service : protoFile.getServices()) {
                ClassName className = ClassName.get(javaPackage, service.type().getSimpleName(), new String[0]);
                nameToJavaName.put(service.type(), className);
            }
            JavaGenerator.putAllExtensions(schema, protoFile, protoFile.getTypes(), protoFile.getExtendList(), memberToJavaName);
        }
        nameToJavaName.putAll(BUILT_IN_TYPES_MAP);
        return new JavaGenerator(schema, nameToJavaName, memberToJavaName, new Profile(), false, false, false, false, false, false);
    }

    private static void putAllExtensions(Schema schema, ProtoFile protoFile, List<Type> types, List<Extend> extendList, Map<ProtoMember, TypeName> memberToJavaName) {
        for (Extend extend : extendList) {
            if (JvmLanguages.annotationTargetType(extend) == null) continue;
            for (Field field : extend.getFields()) {
                if (!JvmLanguages.eligibleAsAnnotationMember(schema, field)) continue;
                ProtoMember protoMember = extend.member(field);
                ClassName annotationName = JvmLanguages.annotationName(protoFile, field, new ClassNameFactory(), "Option");
                if (memberToJavaName.containsValue(annotationName)) {
                    String extendSimpleName = extend.getType().getSimpleName();
                    memberToJavaName.put(protoMember, JvmLanguages.annotationName(protoFile, field, new ClassNameFactory(), extendSimpleName.substring(0, extendSimpleName.length() - 1)));
                    continue;
                }
                memberToJavaName.put(protoMember, annotationName);
            }
        }
        for (Type type : types) {
            JavaGenerator.putAllExtensions(schema, protoFile, type.getNestedTypes(), type.getNestedExtendList(), memberToJavaName);
        }
    }

    private static void putAll(Map<ProtoType, TypeName> wireToJava, String javaPackage, ClassName enclosingClassName, List<Type> types) {
        for (Type type : types) {
            ClassName className = enclosingClassName != null ? enclosingClassName.nestedClass(type.getType().getSimpleName()) : ClassName.get(javaPackage, type.getType().getSimpleName(), new String[0]);
            wireToJava.put(type.getType(), className);
            JavaGenerator.putAll(wireToJava, javaPackage, className, type.getNestedTypes());
        }
    }

    public Schema schema() {
        return this.schema;
    }

    public TypeName typeName(ProtoType protoType) {
        TypeName profileJavaName = this.profile.javaTarget(protoType);
        if (profileJavaName != null) {
            return profileJavaName;
        }
        TypeName candidate = this.typeToJavaName.get(protoType);
        Preconditions.checkArgument(candidate != null, "unexpected type %s", (Object)protoType);
        return candidate;
    }

    @Nullable
    public ClassName abstractAdapterName(ProtoType protoType) {
        ClassName javaName;
        TypeName profileJavaName = this.profile.javaTarget(protoType);
        if (profileJavaName == null) {
            return null;
        }
        TypeName typeName = this.typeToJavaName.get(protoType);
        Type type = this.schema.getType(protoType);
        if (typeName instanceof ClassName) {
            javaName = (ClassName)typeName;
        } else if (typeName instanceof ParameterizedTypeName) {
            javaName = ((ParameterizedTypeName)typeName).rawType;
        } else {
            throw new IllegalArgumentException("Unexpected typeName :" + typeName);
        }
        return type instanceof EnumType ? javaName.peerClass(javaName.simpleName() + "Adapter") : javaName.peerClass("Abstract" + javaName.simpleName() + "Adapter");
    }

    private CodeBlock singleAdapterFor(Field field, NameAllocator nameAllocator) {
        return field.getType().isMap() ? CodeBlock.of("$NAdapter()", nameAllocator.get(field)) : this.singleAdapterFor(field.getType());
    }

    private CodeBlock singleAdapterFor(ProtoType type) {
        CodeBlock.Builder result2 = CodeBlock.builder();
        if (type.isScalar()) {
            result2.add("$T.$L", ADAPTER, type.getSimpleName().toUpperCase(Locale.US));
        } else if (type.equals(ProtoType.DURATION)) {
            result2.add("$T.$L", ADAPTER, "DURATION");
        } else if (type.equals(ProtoType.TIMESTAMP)) {
            result2.add("$T.$L", ADAPTER, "INSTANT");
        } else if (type.equals(ProtoType.EMPTY)) {
            result2.add("$T.$L", ADAPTER, "EMPTY");
        } else if (type.equals(ProtoType.STRUCT_MAP)) {
            result2.add("$T.$L", ADAPTER, "STRUCT_MAP");
        } else if (type.equals(ProtoType.STRUCT_VALUE)) {
            result2.add("$T.$L", ADAPTER, "STRUCT_VALUE");
        } else if (type.equals(ProtoType.STRUCT_NULL)) {
            result2.add("$T.$L", ADAPTER, "STRUCT_NULL");
        } else if (type.equals(ProtoType.STRUCT_LIST)) {
            result2.add("$T.$L", ADAPTER, "STRUCT_LIST");
        } else if (type.equals(ProtoType.DOUBLE_VALUE)) {
            result2.add("$T.$L", ADAPTER, "DOUBLE_VALUE");
        } else if (type.equals(ProtoType.FLOAT_VALUE)) {
            result2.add("$T.$L", ADAPTER, "FLOAT_VALUE");
        } else if (type.equals(ProtoType.INT64_VALUE)) {
            result2.add("$T.$L", ADAPTER, "INT64_VALUE");
        } else if (type.equals(ProtoType.UINT64_VALUE)) {
            result2.add("$T.$L", ADAPTER, "UINT64_VALUE");
        } else if (type.equals(ProtoType.INT32_VALUE)) {
            result2.add("$T.$L", ADAPTER, "INT32_VALUE");
        } else if (type.equals(ProtoType.UINT32_VALUE)) {
            result2.add("$T.$L", ADAPTER, "UINT32_VALUE");
        } else if (type.equals(ProtoType.BOOL_VALUE)) {
            result2.add("$T.$L", ADAPTER, "BOOL_VALUE");
        } else if (type.equals(ProtoType.STRING_VALUE)) {
            result2.add("$T.$L", ADAPTER, "STRING_VALUE");
        } else if (type.equals(ProtoType.BYTES_VALUE)) {
            result2.add("$T.$L", ADAPTER, "BYTES_VALUE");
        } else {
            if (type.isMap()) {
                throw new IllegalArgumentException("Cannot create single adapter for map type " + type);
            }
            AdapterConstant adapterConstant = this.profile.getAdapter(type);
            if (adapterConstant != null) {
                result2.add("$T.$L", adapterConstant.javaClassName, adapterConstant.memberName);
            } else {
                result2.add("$T.ADAPTER", this.typeName(type));
            }
        }
        return result2.build();
    }

    private CodeBlock adapterFor(Field field, NameAllocator nameAllocator) {
        CodeBlock.Builder result2 = this.singleAdapterFor(field, nameAllocator).toBuilder();
        if (field.isPacked()) {
            result2.add(".asPacked()", new Object[0]);
        } else if (field.isRepeated()) {
            result2.add(".asRepeated()", new Object[0]);
        }
        return result2.build();
    }

    public boolean isEnum(ProtoType type) {
        return this.schema.getType(type) instanceof EnumType;
    }

    EnumConstant enumDefault(ProtoType type) {
        EnumType wireEnum = (EnumType)this.schema.getType(type);
        return wireEnum.getConstants().get(0);
    }

    static TypeName listOf(TypeName type) {
        return ParameterizedTypeName.get(LIST, type);
    }

    static TypeName messageOf(ClassName messageType, TypeName type, ClassName builderType) {
        return ParameterizedTypeName.get(messageType, type, builderType);
    }

    static TypeName adapterOf(TypeName messageType) {
        return ParameterizedTypeName.get(ADAPTER, messageType);
    }

    static TypeName builderOf(TypeName messageType, ClassName builderType) {
        return ParameterizedTypeName.get(BUILDER, messageType, builderType);
    }

    static TypeName creatorOf(TypeName messageType) {
        return ParameterizedTypeName.get(CREATOR, messageType);
    }

    static TypeName enumAdapterOf(TypeName enumType) {
        return ParameterizedTypeName.get(ENUM_ADAPTER, enumType);
    }

    static String sanitizeJavadoc(String documentation) {
        documentation = documentation.replaceAll("[^\\S\n]+\n", "\n");
        documentation = documentation.replaceAll("\\s+$", "");
        documentation = documentation.replaceAll("\\*/", "&#42;/");
        documentation = documentation.replaceAll("@see (http:[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]+)", "@see <a href=\"$1\">$1</a>");
        return documentation;
    }

    public ClassName generatedTypeName(Type type) {
        ClassName abstractAdapterName = this.abstractAdapterName(type.getType());
        return abstractAdapterName != null ? abstractAdapterName : (ClassName)this.typeName(type.getType());
    }

    public TypeSpec generateType(Type type) {
        AdapterConstant adapterConstant = this.profile.getAdapter(type.getType());
        if (adapterConstant != null) {
            return this.generateAdapterForCustomType(type);
        }
        if (type instanceof MessageType) {
            return this.generateMessage((MessageType)type);
        }
        if (type instanceof EnumType) {
            return this.generateEnum((EnumType)type);
        }
        if (type instanceof EnclosingType) {
            return this.generateEnclosingType((EnclosingType)type);
        }
        throw new IllegalStateException("Unknown type: " + type);
    }

    private TypeSpec generateEnum(EnumType type) {
        NameAllocator nameAllocator = this.nameAllocators.getUnchecked(type);
        String value = nameAllocator.get("value");
        ClassName javaType = (ClassName)this.typeName(type.getType());
        TypeSpec.Builder builder = TypeSpec.enumBuilder(javaType.simpleName()).addModifiers(Modifier.PUBLIC).addSuperinterface((java.lang.reflect.Type)((Object)WireEnum.class));
        if (!type.getDocumentation().isEmpty()) {
            builder.addJavadoc("$L\n", JavaGenerator.sanitizeJavadoc(type.getDocumentation()));
        }
        for (AnnotationSpec annotation : this.optionAnnotations(type.getOptions())) {
            builder.addAnnotation(annotation);
        }
        if (type.isDeprecated()) {
            builder.addAnnotation(Deprecated.class);
        }
        builder.addField(TypeName.INT, value, Modifier.PRIVATE, Modifier.FINAL);
        builder.addMethod(MethodSpec.constructorBuilder().addStatement("this.$1N = $1N", value).addParameter(TypeName.INT, value, new Modifier[0]).build());
        MethodSpec.Builder fromValueBuilder = MethodSpec.methodBuilder("fromValue").addJavadoc("Return the constant for {@code $N} or null.\n", value).addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(javaType).addParameter(Integer.TYPE, value, new Modifier[0]).beginControlFlow("switch ($N)", value);
        LinkedHashSet<Integer> seenTags = new LinkedHashSet<Integer>();
        for (EnumConstant constant : type.getConstants()) {
            TypeSpec.Builder constantBuilder = TypeSpec.anonymousClassBuilder("$L", constant.getTag());
            if (!constant.getDocumentation().isEmpty()) {
                constantBuilder.addJavadoc("$L\n", JavaGenerator.sanitizeJavadoc(constant.getDocumentation()));
            }
            for (AnnotationSpec annotation : this.optionAnnotations(constant.getOptions())) {
                constantBuilder.addAnnotation(annotation);
            }
            AnnotationSpec wireEnumConstantAnnotation = this.wireEnumConstantAnnotation(nameAllocator, constant);
            if (wireEnumConstantAnnotation != null) {
                constantBuilder.addAnnotation(wireEnumConstantAnnotation);
            }
            if (constant.isDeprecated()) {
                constantBuilder.addAnnotation(Deprecated.class);
            }
            builder.addEnumConstant(nameAllocator.get(constant), constantBuilder.build());
            if (!seenTags.add(constant.getTag())) continue;
            fromValueBuilder.addStatement("case $L: return $L", constant.getTag(), nameAllocator.get(constant));
        }
        builder.addMethod(fromValueBuilder.addStatement("default: return null", new Object[0]).endControlFlow().build());
        FieldSpec.Builder adapterBuilder = FieldSpec.builder(JavaGenerator.adapterOf(javaType), "ADAPTER", new Modifier[0]).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
        ClassName adapterJavaType = javaType.nestedClass("ProtoAdapter_" + javaType.simpleName());
        if (!this.emitCompact) {
            adapterBuilder.initializer("new $T()", adapterJavaType);
        } else {
            adapterBuilder.initializer("$T.newEnumAdapter($T.class)", ProtoAdapter.class, javaType);
        }
        builder.addField(adapterBuilder.build());
        builder.addMethod(MethodSpec.methodBuilder("getValue").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(TypeName.INT).addStatement("return $N", value).build());
        if (!this.emitCompact) {
            builder.addType(this.enumAdapter(javaType, adapterJavaType, type));
        }
        return builder.build();
    }

    private TypeSpec generateMessage(MessageType type) {
        boolean constructorTakesAllFields = this.constructorTakesAllFields(type);
        NameAllocator nameAllocator = this.nameAllocators.getUnchecked(type);
        ClassName javaType = (ClassName)this.typeName(type.getType());
        ClassName builderJavaType = javaType.nestedClass("Builder");
        TypeSpec.Builder builder = TypeSpec.classBuilder(javaType.simpleName());
        builder.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        if (javaType.enclosingClassName() != null) {
            builder.addModifiers(Modifier.STATIC);
        }
        if (!type.getDocumentation().isEmpty()) {
            builder.addJavadoc("$L\n", JavaGenerator.sanitizeJavadoc(type.getDocumentation()));
        }
        for (AnnotationSpec annotation : this.optionAnnotations(type.getOptions())) {
            builder.addAnnotation(annotation);
        }
        if (type.isDeprecated()) {
            builder.addAnnotation(Deprecated.class);
        }
        ClassName messageType = this.emitAndroid ? ANDROID_MESSAGE : MESSAGE;
        builder.superclass(JavaGenerator.messageOf(messageType, javaType, builderJavaType));
        String adapterName = nameAllocator.get("ADAPTER");
        String protoAdapterName = "ProtoAdapter_" + javaType.simpleName();
        String protoAdapterClassName = nameAllocator.newName(protoAdapterName);
        ClassName adapterJavaType = javaType.nestedClass(protoAdapterClassName);
        builder.addField(this.messageAdapterField(adapterName, javaType, adapterJavaType, type.getType(), type.getSyntax()));
        if (this.emitAndroid) {
            TypeName creatorType = JavaGenerator.creatorOf(javaType);
            String creatorName = nameAllocator.get("CREATOR");
            builder.addField(FieldSpec.builder(creatorType, creatorName, Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("$T.newCreator($L)", ANDROID_MESSAGE, adapterName).build());
        }
        builder.addField(FieldSpec.builder(TypeName.LONG, nameAllocator.get("serialVersionUID"), new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).initializer("$LL", 0L).build());
        for (Field field : type.getFieldsAndOneOfFields()) {
            TypeName fieldJavaType = this.fieldType(field);
            Field.EncodeMode encodeMode = field.getEncodeMode();
            if ((field.getType().isScalar() || this.isEnum(field.getType())) && !field.getType().equals(ProtoType.STRUCT_NULL) && encodeMode != Field.EncodeMode.REPEATED && encodeMode != Field.EncodeMode.PACKED && encodeMode != Field.EncodeMode.OMIT_IDENTITY) {
                builder.addField(this.defaultField(nameAllocator, field, fieldJavaType));
            }
            String fieldName = nameAllocator.get(field);
            FieldSpec.Builder fieldBuilder = FieldSpec.builder(fieldJavaType, fieldName, Modifier.PUBLIC, Modifier.FINAL);
            if (!field.getDocumentation().isEmpty()) {
                fieldBuilder.addJavadoc("$L\n", JavaGenerator.sanitizeJavadoc(field.getDocumentation()));
            }
            for (AnnotationSpec annotation : this.optionAnnotations(field.getOptions())) {
                fieldBuilder.addAnnotation(annotation);
            }
            fieldBuilder.addAnnotation(this.wireFieldAnnotation(nameAllocator, field, type));
            if (field.isExtension()) {
                fieldBuilder.addJavadoc("Extension source: $L\n", field.getLocation().withPathOnly());
            }
            if (field.isDeprecated()) {
                fieldBuilder.addAnnotation(Deprecated.class);
            }
            if (this.emitAndroidAnnotations && encodeMode == Field.EncodeMode.NULL_IF_ABSENT) {
                fieldBuilder.addAnnotation(NULLABLE);
            }
            builder.addField(fieldBuilder.build());
        }
        if (constructorTakesAllFields) {
            builder.addMethod(this.messageFieldsConstructor(nameAllocator, type));
        }
        builder.addMethod(this.messageConstructor(nameAllocator, type, builderJavaType));
        builder.addMethod(this.newBuilder(nameAllocator, type));
        builder.addMethod(this.messageEquals(nameAllocator, type));
        builder.addMethod(this.messageHashCode(nameAllocator, type));
        if (!this.emitCompact) {
            builder.addMethod(this.messageToString(nameAllocator, type));
        }
        builder.addType(this.builder(nameAllocator, type, javaType, builderJavaType));
        for (Type nestedType : type.getNestedTypes()) {
            builder.addType(this.generateType(nestedType));
        }
        for (Extend nestedExtend : type.getNestedExtendList()) {
            for (Field extension : nestedExtend.getFields()) {
                TypeSpec extensionOption = this.generateOptionType(nestedExtend, extension);
                if (extensionOption == null) continue;
                builder.addType(extensionOption);
            }
        }
        if (!this.emitCompact) {
            builder.addType(this.messageAdapter(nameAllocator, type, javaType, adapterJavaType, builderJavaType));
        }
        return builder.build();
    }

    private boolean constructorTakesAllFields(MessageType type) {
        return type.fields().size() < 16;
    }

    private TypeSpec generateEnclosingType(EnclosingType type) {
        String documentation;
        ClassName javaType = (ClassName)this.typeName(type.getType());
        TypeSpec.Builder builder = TypeSpec.classBuilder(javaType.simpleName()).addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        if (javaType.enclosingClassName() != null) {
            builder.addModifiers(Modifier.STATIC);
        }
        if (!(documentation = type.getDocumentation()).isEmpty()) {
            documentation = documentation + "\n\n<p>";
        }
        documentation = documentation + "<b>NOTE:</b> This type only exists to maintain class structure for its nested types and is not an actual message.";
        builder.addJavadoc("$L\n", documentation);
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addStatement("throw new $T()", AssertionError.class).build());
        for (Type nestedType : type.getNestedTypes()) {
            builder.addType(this.generateType(nestedType));
        }
        return builder.build();
    }

    public TypeSpec generateAdapterForCustomType(Type type) {
        NameAllocator nameAllocator = this.nameAllocators.getUnchecked(type);
        ClassName adapterTypeName = this.abstractAdapterName(type.getType());
        ClassName typeName = (ClassName)this.typeName(type.getType());
        TypeSpec.Builder adapter = type instanceof MessageType ? this.messageAdapter(nameAllocator, (MessageType)type, typeName, adapterTypeName, null).toBuilder() : this.enumAdapter(nameAllocator, (EnumType)type, typeName, adapterTypeName).toBuilder();
        if (adapterTypeName.enclosingClassName() != null) {
            adapter.addModifiers(Modifier.STATIC);
        }
        for (Type nestedType : type.getNestedTypes()) {
            if (this.profile.getAdapter(nestedType.getType()) == null) {
                throw new IllegalArgumentException("Missing custom proto adapter for " + nestedType.getType().getEnclosingTypeOrPackage() + "." + nestedType.getType().getSimpleName() + " when enclosing proto has custom proto adapter.");
            }
            adapter.addType(this.generateAdapterForCustomType(nestedType));
        }
        return adapter.build();
    }

    private Set<String> collidingFieldNames(List<Field> fields2) {
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        LinkedHashSet<String> collidingNames = new LinkedHashSet<String>();
        for (Field field : fields2) {
            if (fieldNames.add(field.getName())) continue;
            collidingNames.add(field.getName());
        }
        return collidingNames;
    }

    private FieldSpec messageAdapterField(String adapterName, ClassName javaType, ClassName adapterJavaType, ProtoType protoType, Syntax syntax) {
        FieldSpec.Builder result2 = FieldSpec.builder(JavaGenerator.adapterOf(javaType), adapterName, new Modifier[0]).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
        if (this.emitCompact) {
            result2.initializer("$T.newMessageAdapter($T.class, $S, $T.$L)", ProtoAdapter.class, javaType, protoType.getTypeUrl(), Syntax.class, syntax.name());
        } else {
            result2.initializer("new $T()", adapterJavaType);
        }
        return result2.build();
    }

    private TypeSpec enumAdapter(NameAllocator nameAllocator, EnumType type, ClassName javaType, ClassName adapterJavaType) {
        String value = nameAllocator.get("value");
        String i = nameAllocator.get("i");
        String reader = nameAllocator.get("reader");
        String writer = nameAllocator.get("writer");
        TypeSpec.Builder builder = TypeSpec.classBuilder(adapterJavaType.simpleName());
        builder.superclass(JavaGenerator.adapterOf(javaType));
        builder.addModifiers(Modifier.PUBLIC);
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
        constructorBuilder.addModifiers(Modifier.PUBLIC);
        constructorBuilder.addStatement("super($T.VARINT, $T.class)", FieldEncoding.class, javaType);
        for (EnumConstant enumConstant : type.getConstants()) {
            String name = nameAllocator.get(enumConstant);
            FieldSpec.Builder fieldBuilder = FieldSpec.builder(javaType, name, new Modifier[0]).addModifiers(Modifier.PROTECTED, Modifier.FINAL);
            if (!enumConstant.getDocumentation().isEmpty()) {
                fieldBuilder.addJavadoc("$L\n", JavaGenerator.sanitizeJavadoc(enumConstant.getDocumentation()));
            }
            if (enumConstant.isDeprecated()) {
                fieldBuilder.addAnnotation(Deprecated.class);
            }
            builder.addField(fieldBuilder.build());
            constructorBuilder.addParameter(javaType, name, new Modifier[0]);
            constructorBuilder.addStatement("this.$N = $N", name, name);
        }
        builder.addMethod(constructorBuilder.build());
        MethodSpec.Builder toValueBuilder = MethodSpec.methodBuilder("toValue").addModifiers(Modifier.PROTECTED).returns(Integer.TYPE).addParameter(javaType, value, new Modifier[0]);
        for (EnumConstant constant : type.getConstants()) {
            String name = nameAllocator.get(constant);
            toValueBuilder.addStatement("if ($N.equals($N)) return $L", value, name, constant.getTag());
        }
        toValueBuilder.addStatement("return $L", -1);
        builder.addMethod(toValueBuilder.build());
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder("fromValue").addModifiers(Modifier.PROTECTED).returns(javaType).addParameter(Integer.TYPE, value, new Modifier[0]);
        builder2.beginControlFlow("switch ($N)", value);
        for (EnumConstant constant : type.getConstants()) {
            String name = nameAllocator.get(constant);
            builder2.addStatement("case $L: return $N", constant.getTag(), name);
        }
        builder2.addStatement("default: throw new $T($N, $T.class)", ProtoAdapter.EnumConstantNotFoundException.class, value, javaType);
        builder2.endControlFlow();
        builder.addMethod(builder2.build());
        builder.addMethod(MethodSpec.methodBuilder("encodedSize").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(Integer.TYPE).addParameter(javaType, value, new Modifier[0]).addStatement("return $T.UINT32.encodedSize(toValue($N))", ProtoAdapter.class, value).build());
        builder.addMethod(this.enumEncode(javaType, value, i, writer, false));
        builder.addMethod(this.enumEncode(javaType, value, i, writer, true));
        builder.addMethod(MethodSpec.methodBuilder("decode").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(javaType).addParameter((java.lang.reflect.Type)((Object)ProtoReader.class), reader, new Modifier[0]).addException((java.lang.reflect.Type)((Object)IOException.class)).addStatement("int $N = $N.readVarint32()", value, reader).addStatement("return fromValue($N)", value).build());
        builder.addMethod(MethodSpec.methodBuilder("redact").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(javaType).addParameter(javaType, "value", new Modifier[0]).addStatement("return value", new Object[0]).build());
        return builder.build();
    }

    private MethodSpec enumEncode(ClassName javaType, String value, String localInt, String localWriter, boolean reverse) {
        return MethodSpec.methodBuilder("encode").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addParameter((java.lang.reflect.Type)((Object)(reverse ? ReverseProtoWriter.class : ProtoWriter.class)), localWriter, new Modifier[0]).addParameter(javaType, value, new Modifier[0]).addException((java.lang.reflect.Type)((Object)IOException.class)).addStatement("int $N = toValue($N)", localInt, value).addStatement("if ($N == $L) throw new $T($S + $N)", localInt, -1, ProtocolException.class, "Unexpected enum constant: ", value).addStatement("$N.writeVarint32($N)", localWriter, localInt).build();
    }

    private TypeSpec enumAdapter(ClassName javaType, ClassName adapterJavaType, EnumType enumType) {
        return TypeSpec.classBuilder(adapterJavaType.simpleName()).superclass(JavaGenerator.enumAdapterOf(javaType)).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addMethod(MethodSpec.constructorBuilder().addStatement("super($T.class, $T.$L, $L)", javaType, Syntax.class, enumType.getSyntax().name(), this.identity(enumType)).build()).addMethod(MethodSpec.methodBuilder("fromValue").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(javaType).addParameter(Integer.TYPE, "value", new Modifier[0]).addStatement("return $T.fromValue(value)", javaType).build()).build();
    }

    private TypeSpec messageAdapter(NameAllocator nameAllocator, MessageType type, ClassName javaType, ClassName adapterJavaType, ClassName builderType) {
        boolean useBuilder = builderType != null;
        TypeSpec.Builder adapter = TypeSpec.classBuilder(adapterJavaType.simpleName()).superclass(JavaGenerator.adapterOf(javaType));
        if (useBuilder) {
            adapter.addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
        } else {
            adapter.addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT);
        }
        adapter.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addStatement("super($T.LENGTH_DELIMITED, $T.class, $S, $T.$L, null, $S)", FieldEncoding.class, javaType, type.getType().getTypeUrl(), Syntax.class, type.getSyntax().name(), type.getLocation().getPath()).build());
        if (!useBuilder) {
            MethodSpec.Builder fromProto = MethodSpec.methodBuilder("fromProto").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(javaType);
            for (Field field : type.getFieldsAndOneOfFields()) {
                TypeName fieldType = this.fieldType(field);
                String fieldName = nameAllocator.get(field);
                fromProto.addParameter(fieldType, fieldName, new Modifier[0]);
                adapter.addMethod(MethodSpec.methodBuilder(fieldName).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).addParameter(javaType, "value", new Modifier[0]).returns(fieldType).build());
            }
            adapter.addMethod(fromProto.build());
        }
        adapter.addMethod(this.messageAdapterEncodedSize(nameAllocator, type, javaType, useBuilder));
        adapter.addMethod(this.messageAdapterEncode(nameAllocator, type, javaType, useBuilder, false));
        adapter.addMethod(this.messageAdapterEncode(nameAllocator, type, javaType, useBuilder, true));
        adapter.addMethod(this.messageAdapterDecode(nameAllocator, type, javaType, useBuilder, builderType));
        adapter.addMethod(this.messageAdapterRedact(nameAllocator, type, javaType, useBuilder, builderType));
        for (Field field : type.getFieldsAndOneOfFields()) {
            if (!field.getType().isMap()) continue;
            TypeName adapterType = JavaGenerator.adapterOf(this.fieldType(field));
            String fieldName = nameAllocator.get(field);
            adapter.addField(FieldSpec.builder(adapterType, fieldName, Modifier.PRIVATE).build());
            adapter.addMethod(this.mapAdapter(nameAllocator, adapterType, fieldName, field.getType()));
        }
        return adapter.build();
    }

    private MethodSpec messageAdapterEncodedSize(NameAllocator nameAllocator, MessageType type, TypeName javaType, boolean useBuilder) {
        MethodSpec.Builder result2 = MethodSpec.methodBuilder("encodedSize").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(Integer.TYPE).addParameter(javaType, "value", new Modifier[0]);
        String resultName = nameAllocator.clone().newName("result");
        result2.addStatement("int $L = 0", resultName);
        for (Field field : type.getFieldsAndOneOfFields()) {
            int fieldTag = field.getTag();
            String fieldName = nameAllocator.get(field);
            CodeBlock adapter = this.adapterFor(field, nameAllocator);
            boolean omitIdentity = field.getEncodeMode().equals((Object)Field.EncodeMode.OMIT_IDENTITY);
            if (omitIdentity) {
                result2.beginControlFlow("if (!$T.equals(value.$L, $L))", ClassName.get(Objects.class), fieldName, this.identityValue(field));
            }
            result2.addCode("$L += ", resultName).addCode("$L.encodedSizeWithTag($L, ", adapter, fieldTag).addCode(useBuilder ? "value.$L" : "$L(value)", fieldName).addCode(");\n", new Object[0]);
            if (!omitIdentity) continue;
            result2.endControlFlow();
        }
        if (useBuilder) {
            result2.addStatement("$L += value.unknownFields().size()", resultName);
        }
        result2.addStatement("return $L", resultName);
        return result2.build();
    }

    private MethodSpec messageAdapterEncode(NameAllocator nameAllocator, MessageType type, TypeName javaType, boolean useBuilder, boolean reverse) {
        MethodSpec.Builder result2 = MethodSpec.methodBuilder("encode").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addParameter((java.lang.reflect.Type)((Object)(reverse ? ReverseProtoWriter.class : ProtoWriter.class)), "writer", new Modifier[0]).addParameter(javaType, "value", new Modifier[0]).addException((java.lang.reflect.Type)((Object)IOException.class));
        ArrayList<CodeBlock> encodeCalls = new ArrayList<CodeBlock>();
        for (Field field : type.getFieldsAndOneOfFields()) {
            int fieldTag = field.getTag();
            CodeBlock adapter = this.adapterFor(field, nameAllocator);
            String fieldName = nameAllocator.get(field);
            CodeBlock.Builder encodeCall = CodeBlock.builder();
            if (field.getEncodeMode().equals((Object)Field.EncodeMode.OMIT_IDENTITY)) {
                encodeCall.add("if (!$T.equals(value.$L, $L)) ", ClassName.get(Objects.class), fieldName, this.identityValue(field));
            }
            encodeCall.add("$L.encodeWithTag(writer, $L, ", adapter, fieldTag).add(useBuilder ? "value.$L" : "$L(value)", fieldName).add(");\n", new Object[0]);
            encodeCalls.add(encodeCall.build());
        }
        if (useBuilder) {
            encodeCalls.add(CodeBlock.builder().addStatement("writer.writeBytes(value.unknownFields())", new Object[0]).build());
        }
        if (reverse) {
            Collections.reverse(encodeCalls);
        }
        for (CodeBlock encodeCall : encodeCalls) {
            result2.addCode(encodeCall);
        }
        return result2.build();
    }

    private MethodSpec messageAdapterDecode(NameAllocator nameAllocator, MessageType type, TypeName javaType, boolean useBuilder, ClassName builderJavaType) {
        MethodSpec.Builder result2 = MethodSpec.methodBuilder("decode").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(javaType).addParameter((java.lang.reflect.Type)((Object)ProtoReader.class), "reader", new Modifier[0]).addException((java.lang.reflect.Type)((Object)IOException.class));
        List<Field> fields2 = TAG_ORDERING.sortedCopy(type.getFieldsAndOneOfFields());
        if (useBuilder) {
            result2.addStatement("$1T builder = new $1T()", builderJavaType);
        } else {
            for (Field field : fields2) {
                result2.addStatement("$T $N = $L", this.fieldType(field), nameAllocator.get(field), this.initialValue(field));
            }
        }
        result2.addStatement("long token = reader.beginMessage()", new Object[0]);
        result2.beginControlFlow("for (int tag; (tag = reader.nextTag()) != -1;)", new Object[0]);
        result2.beginControlFlow("switch (tag)", new Object[0]);
        for (Field field : fields2) {
            int fieldTag = field.getTag();
            if (this.isEnum(field.getType()) && !field.getType().equals(ProtoType.STRUCT_NULL)) {
                result2.beginControlFlow("case $L:", fieldTag);
                result2.beginControlFlow("try", new Object[0]);
                result2.addCode(this.decodeAndAssign(field, nameAllocator, useBuilder));
                result2.addCode(";\n", new Object[0]);
                if (useBuilder) {
                    result2.nextControlFlow("catch ($T e)", ProtoAdapter.EnumConstantNotFoundException.class);
                    result2.addStatement("builder.addUnknownField(tag, $T.VARINT, (long) e.value)", FieldEncoding.class);
                    result2.endControlFlow();
                } else {
                    result2.nextControlFlow("catch ($T ignored)", ProtoAdapter.EnumConstantNotFoundException.class);
                    result2.endControlFlow();
                }
                result2.addStatement("break", new Object[0]);
                result2.endControlFlow();
                continue;
            }
            result2.addCode("case $L: $L; break;\n", fieldTag, this.decodeAndAssign(field, nameAllocator, useBuilder));
        }
        result2.beginControlFlow("default:", new Object[0]);
        if (useBuilder) {
            result2.addStatement("reader.readUnknownField(tag)", new Object[0]);
        } else {
            result2.addStatement("reader.skip()", new Object[0]);
        }
        result2.endControlFlow();
        result2.endControlFlow();
        result2.endControlFlow();
        if (useBuilder) {
            result2.addStatement("builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token))", new Object[0]);
        } else {
            result2.addStatement("reader.endMessageAndGetUnknownFields(token)", new Object[0]);
        }
        if (useBuilder) {
            result2.addStatement("return builder.build()", new Object[0]);
        } else {
            result2.addCode("return fromProto(", new Object[0]);
            boolean first2 = true;
            for (Field field : type.getFieldsAndOneOfFields()) {
                if (!first2) {
                    result2.addCode(", ", new Object[0]);
                }
                result2.addCode("$N", nameAllocator.get(field));
                first2 = false;
            }
            result2.addCode(");\n", new Object[0]);
        }
        return result2.build();
    }

    private CodeBlock decodeAndAssign(Field field, NameAllocator nameAllocator, boolean useBuilder) {
        String fieldName = nameAllocator.get(field);
        CodeBlock decode = CodeBlock.of("$L.decode(reader)", this.singleAdapterFor(field, nameAllocator));
        if (field.isRepeated()) {
            return useBuilder ? (field.getType().equals(ProtoType.STRUCT_NULL) ? CodeBlock.of("builder.$L.add(($T) $L)", fieldName, Void.class, decode) : CodeBlock.of("builder.$L.add($L)", fieldName, decode)) : CodeBlock.of("$L.add($L)", fieldName, decode);
        }
        if (field.getType().isMap()) {
            return useBuilder ? CodeBlock.of("builder.$L.putAll($L)", fieldName, decode) : CodeBlock.of("$L.putAll($L)", fieldName, decode);
        }
        return useBuilder ? (field.getType().equals(ProtoType.STRUCT_NULL) ? CodeBlock.of("builder.$L(($T) $L)", fieldName, Void.class, decode) : CodeBlock.of("builder.$L($L)", fieldName, decode)) : CodeBlock.of("$L = $L", fieldName, decode);
    }

    private MethodSpec messageAdapterRedact(NameAllocator nameAllocator, MessageType type, ClassName javaType, boolean useBuilder, ClassName builderJavaType) {
        MethodSpec.Builder result2 = MethodSpec.methodBuilder("redact").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(javaType).addParameter(javaType, "value", new Modifier[0]);
        int redactedFieldCount = 0;
        ArrayList<String> requiredRedacted = new ArrayList<String>();
        for (Field field : type.getFieldsAndOneOfFields()) {
            if (!field.isRedacted()) continue;
            ++redactedFieldCount;
            if (!field.isRequired()) continue;
            requiredRedacted.add(nameAllocator.get(field));
        }
        if (!useBuilder) {
            result2.addStatement(redactedFieldCount == 0 ? "return value" : "return null", new Object[0]);
            return result2.build();
        }
        if (!requiredRedacted.isEmpty()) {
            boolean isPlural = requiredRedacted.size() != 1;
            result2.addStatement("throw new $T($S)", UnsupportedOperationException.class, (isPlural ? "Fields" : "Field") + " '" + Joiner.on("', '").join(requiredRedacted) + "' " + (isPlural ? "are" : "is") + " required and cannot be redacted.");
            return result2.build();
        }
        result2.addStatement("$1T builder = value.newBuilder()", builderJavaType);
        for (Field field : type.getFieldsAndOneOfFields()) {
            CodeBlock adapter;
            String fieldName = nameAllocator.get(field);
            if (field.isRedacted()) {
                if (field.isRepeated()) {
                    result2.addStatement("builder.$N = $T.emptyList()", fieldName, Collections.class);
                    continue;
                }
                if (field.getType().isMap()) {
                    result2.addStatement("builder.$N = $T.emptyMap()", fieldName, Collections.class);
                    continue;
                }
                result2.addStatement("builder.$N = null", fieldName);
                continue;
            }
            if (field.getType().isScalar() || this.isEnum(field.getType())) continue;
            if (field.isRepeated()) {
                adapter = this.singleAdapterFor(field, nameAllocator);
                result2.addStatement("$T.redactElements(builder.$N, $L)", Internal.class, fieldName, adapter);
                continue;
            }
            if (field.getType().isMap()) {
                if (field.getType().getValueType().isScalar() || this.isEnum(field.getType().getValueType())) continue;
                adapter = this.singleAdapterFor(field.getType().getValueType());
                result2.addStatement("$T.redactElements(builder.$N, $L)", Internal.class, fieldName, adapter);
                continue;
            }
            adapter = this.adapterFor(field, nameAllocator);
            if (!field.isRequired()) {
                result2.addCode("if (builder.$N != null) ", fieldName);
            }
            result2.addStatement("builder.$1N = $2L.redact(builder.$1N)", fieldName, adapter);
        }
        result2.addStatement("builder.clearUnknownFields()", new Object[0]);
        result2.addStatement("return builder.build()", new Object[0]);
        return result2.build();
    }

    private String fieldName(ProtoType type, Field field) {
        MessageType messageType = (MessageType)this.schema.getType(type);
        NameAllocator names = this.nameAllocators.getUnchecked(messageType);
        return names.get(field);
    }

    private TypeName fieldType(Field field) {
        ProtoType type = field.getType();
        if (type.isMap()) {
            return ParameterizedTypeName.get(ClassName.get(Map.class), this.typeName(type.getKeyType()).box(), this.typeName(type.getValueType()).box());
        }
        TypeName messageType = this.typeName(type);
        switch (field.getEncodeMode()) {
            case REPEATED: 
            case PACKED: {
                return JavaGenerator.listOf(messageType.box());
            }
            case NULL_IF_ABSENT: 
            case REQUIRED: {
                return messageType.box();
            }
        }
        if (this.isWrapper(field.getType())) {
            return messageType.box();
        }
        return messageType;
    }

    private FieldSpec defaultField(NameAllocator nameAllocator, Field field, TypeName fieldType) {
        String defaultFieldName = "DEFAULT_" + nameAllocator.get(field).toUpperCase(Locale.US);
        return FieldSpec.builder(fieldType, defaultFieldName, Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer(this.defaultValue(field)).build();
    }

    private AnnotationSpec wireFieldAnnotation(NameAllocator nameAllocator, Field field, MessageType message) {
        String generatedName;
        WireField.Label wireFieldLabel;
        AnnotationSpec.Builder result2 = AnnotationSpec.builder(WireField.class);
        NameAllocator localNameAllocator = nameAllocator.clone();
        int tag = field.getTag();
        result2.addMember("tag", String.valueOf(tag), new Object[0]);
        if (field.getType().isMap()) {
            result2.addMember("keyAdapter", "$S", this.adapterString(field.getType().getKeyType()));
            result2.addMember("adapter", "$S", this.adapterString(field.getType().getValueType()));
        } else {
            result2.addMember("adapter", "$S", this.adapterString(field.getType()));
        }
        switch (field.getEncodeMode()) {
            case REQUIRED: {
                wireFieldLabel = WireField.Label.REQUIRED;
                break;
            }
            case OMIT_IDENTITY: {
                if (field.getType().isWrapper()) {
                    wireFieldLabel = null;
                    break;
                }
                wireFieldLabel = WireField.Label.OMIT_IDENTITY;
                break;
            }
            case REPEATED: {
                wireFieldLabel = WireField.Label.REPEATED;
                break;
            }
            case PACKED: {
                wireFieldLabel = WireField.Label.PACKED;
                break;
            }
            default: {
                wireFieldLabel = null;
            }
        }
        if (wireFieldLabel != null) {
            result2.addMember("label", "$T.$L", new Object[]{WireField.Label.class, wireFieldLabel});
        }
        if (field.isRedacted()) {
            result2.addMember("redacted", "true", new Object[0]);
        }
        if (!(generatedName = localNameAllocator.get(field)).equals(field.getName())) {
            result2.addMember("declaredName", "$S", field.getName());
        }
        if (!field.getJsonName().equals(field.getName())) {
            result2.addMember("jsonName", "$S", field.getJsonName());
        }
        if (field.isOneOf()) {
            String oneofName = null;
            for (OneOf oneOf : message.getOneOfs()) {
                if (!oneOf.getFields().contains(field)) continue;
                oneofName = oneOf.getName();
                break;
            }
            if (oneofName == null) {
                throw new IllegalArgumentException("No oneof found for field: " + field.getQualifiedName());
            }
            result2.addMember("oneofName", "$S", oneofName);
        }
        return result2.build();
    }

    @Nullable
    private AnnotationSpec wireEnumConstantAnnotation(NameAllocator nameAllocator, EnumConstant constant) {
        AnnotationSpec.Builder result2 = AnnotationSpec.builder(WireEnumConstant.class);
        NameAllocator localNameAllocator = nameAllocator.clone();
        String generatedName = localNameAllocator.get(constant);
        if (generatedName.equals(constant.getName())) {
            return null;
        }
        result2.addMember("declaredName", "$S", constant.getName());
        return result2.build();
    }

    private String adapterString(ProtoType type) {
        String builtInAdapterString = JvmLanguages.builtInAdapterString(type, false);
        if (builtInAdapterString != null) {
            return builtInAdapterString;
        }
        AdapterConstant adapterConstant = this.profile.getAdapter(type);
        if (adapterConstant != null) {
            return this.reflectionName(adapterConstant.javaClassName) + "#" + adapterConstant.memberName;
        }
        return this.reflectionName(this.typeName(type)) + "#ADAPTER";
    }

    private String reflectionName(TypeName typeName) {
        ClassName className = typeName instanceof ParameterizedTypeName ? ((ParameterizedTypeName)typeName).rawType : (ClassName)typeName;
        return className.packageName().isEmpty() ? Joiner.on('$').join(className.simpleNames()) : className.packageName() + '.' + Joiner.on('$').join(className.simpleNames());
    }

    private MethodSpec messageFieldsConstructor(NameAllocator nameAllocator, MessageType type) {
        MethodSpec.Builder result2 = MethodSpec.constructorBuilder();
        if (!this.buildersOnly) {
            result2.addModifiers(Modifier.PUBLIC);
        }
        result2.addCode("this(", new Object[0]);
        for (Field field : type.getFieldsAndOneOfFields()) {
            TypeName javaType = this.fieldType(field);
            String fieldName = nameAllocator.get(field);
            ParameterSpec.Builder param = ParameterSpec.builder(javaType, fieldName, new Modifier[0]);
            if (this.emitAndroidAnnotations && field.getEncodeMode() == Field.EncodeMode.NULL_IF_ABSENT) {
                param.addAnnotation(NULLABLE);
            }
            result2.addParameter(param.build());
            result2.addCode("$L, ", fieldName);
        }
        result2.addCode("$T.EMPTY);\n", BYTE_STRING);
        return result2.build();
    }

    private MethodSpec messageConstructor(NameAllocator nameAllocator, MessageType type, ClassName builderJavaType) {
        boolean constructorTakesAllFields = this.constructorTakesAllFields(type);
        NameAllocator localNameAllocator = nameAllocator.clone();
        String adapterName = localNameAllocator.get("ADAPTER");
        String unknownFieldsName = localNameAllocator.newName("unknownFields");
        String builderName = localNameAllocator.newName("builder");
        MethodSpec.Builder result2 = MethodSpec.constructorBuilder().addStatement("super($N, $N)", adapterName, unknownFieldsName);
        if (!this.buildersOnly) {
            result2.addModifiers(Modifier.PUBLIC);
        }
        for (OneOf oneOf : type.getOneOfs()) {
            if (oneOf.getFields().size() < 2) continue;
            CodeBlock.Builder fieldNamesBuilder = CodeBlock.builder();
            boolean first2 = true;
            for (Field field : oneOf.getFields()) {
                if (!first2) {
                    fieldNamesBuilder.add(", ", new Object[0]);
                }
                if (constructorTakesAllFields) {
                    fieldNamesBuilder.add("$N", localNameAllocator.get(field));
                } else {
                    fieldNamesBuilder.add("$N.$N", builderName, localNameAllocator.get(field));
                }
                first2 = false;
            }
            CodeBlock fieldNames = fieldNamesBuilder.build();
            result2.beginControlFlow("if ($T.countNonNull($L) > 1)", Internal.class, fieldNames);
            result2.addStatement("throw new IllegalArgumentException($S)", "at most one of " + fieldNames + " may be non-null");
            result2.endControlFlow();
        }
        for (Field field : type.getFieldsAndOneOfFields()) {
            String fieldAccessName;
            TypeName javaType = this.fieldType(field);
            String fieldName = localNameAllocator.get(field);
            String string = fieldAccessName = constructorTakesAllFields ? fieldName : builderName + "." + fieldName;
            if (constructorTakesAllFields) {
                ParameterSpec.Builder param = ParameterSpec.builder(javaType, fieldName, new Modifier[0]);
                if (this.emitAndroidAnnotations && field.getEncodeMode() == Field.EncodeMode.NULL_IF_ABSENT) {
                    param.addAnnotation(NULLABLE);
                }
                result2.addParameter(param.build());
            }
            if (field.getEncodeMode() == Field.EncodeMode.OMIT_IDENTITY && (field.getType().isScalar() && (field.getType() == ProtoType.STRING || field.getType() == ProtoType.BYTES) || this.isEnum(field.getType()) && !field.getType().equals(ProtoType.STRUCT_NULL))) {
                result2.beginControlFlow("if ($L == null)", fieldAccessName);
                result2.addStatement("throw new IllegalArgumentException($S)", fieldAccessName + " == null");
                result2.endControlFlow();
            }
            if (field.getType().isMap() && this.isStruct(field.getType().getValueType())) {
                result2.addStatement("this.$1L = $2T.immutableCopyOfMapWithStructValues($1S, $3L)", fieldName, Internal.class, fieldAccessName);
                continue;
            }
            if (this.isStruct(field.getType())) {
                result2.addStatement("this.$1L = $2T.immutableCopyOfStruct($1S, $3L)", fieldName, Internal.class, fieldAccessName);
                continue;
            }
            if (field.isRepeated() || field.getType().isMap()) {
                result2.addStatement("this.$1L = $2T.immutableCopyOf($1S, $3L)", fieldName, Internal.class, fieldAccessName);
                continue;
            }
            result2.addStatement("this.$1L = $2L", fieldName, fieldAccessName);
        }
        if (!constructorTakesAllFields) {
            result2.addParameter(builderJavaType, builderName, new Modifier[0]);
        }
        result2.addParameter(BYTE_STRING, unknownFieldsName, new Modifier[0]);
        return result2.build();
    }

    private boolean isStruct(ProtoType protoType) {
        return protoType.equals(ProtoType.STRUCT_MAP) || protoType.equals(ProtoType.STRUCT_LIST) || protoType.equals(ProtoType.STRUCT_VALUE) || protoType.equals(ProtoType.STRUCT_NULL);
    }

    private boolean isWrapper(ProtoType protoType) {
        return protoType.equals(ProtoType.DOUBLE_VALUE) || protoType.equals(ProtoType.FLOAT_VALUE) || protoType.equals(ProtoType.INT64_VALUE) || protoType.equals(ProtoType.UINT64_VALUE) || protoType.equals(ProtoType.INT32_VALUE) || protoType.equals(ProtoType.UINT32_VALUE) || protoType.equals(ProtoType.BOOL_VALUE) || protoType.equals(ProtoType.STRING_VALUE) || protoType.equals(ProtoType.BYTES_VALUE);
    }

    private MethodSpec messageEquals(NameAllocator nameAllocator, MessageType type) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        String otherName = localNameAllocator.newName("other");
        String oName = localNameAllocator.newName("o");
        TypeName javaType = this.typeName(type.getType());
        MethodSpec.Builder result2 = MethodSpec.methodBuilder("equals").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(Boolean.TYPE).addParameter((java.lang.reflect.Type)((Object)Object.class), otherName, new Modifier[0]);
        result2.addStatement("if ($N == this) return true", otherName);
        result2.addStatement("if (!($N instanceof $T)) return false", otherName, javaType);
        result2.addStatement("$T $N = ($T) $N", javaType, oName, javaType, otherName);
        result2.addCode("$[return unknownFields().equals($N.unknownFields())", oName);
        List<Field> fields2 = type.getFieldsAndOneOfFields();
        for (Field field : fields2) {
            String fieldName = localNameAllocator.get(field);
            if (field.isRequired() || field.isRepeated() || field.getType().isMap()) {
                result2.addCode("\n&& $1L.equals($2N.$1L)", fieldName, oName);
                continue;
            }
            result2.addCode("\n&& $1T.equals($2L, $3N.$2L)", Internal.class, fieldName, oName);
        }
        result2.addCode(";\n$]", new Object[0]);
        return result2.build();
    }

    private MethodSpec messageHashCode(NameAllocator nameAllocator, MessageType type) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        String resultName = localNameAllocator.newName("result");
        MethodSpec.Builder result2 = MethodSpec.methodBuilder("hashCode").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(Integer.TYPE);
        List<Field> fields2 = type.getFieldsAndOneOfFields();
        if (fields2.isEmpty()) {
            result2.addStatement("return unknownFields().hashCode()", new Object[0]);
            return result2.build();
        }
        result2.addStatement("int $N = super.hashCode", resultName);
        result2.beginControlFlow("if ($N == 0)", resultName);
        result2.addStatement("$N = unknownFields().hashCode()", resultName);
        for (Field field : fields2) {
            String fieldName = localNameAllocator.get(field);
            TypeName typeName = this.fieldType(field);
            result2.addCode("$1N = $1N * 37 + ", resultName);
            if (typeName == TypeName.BOOLEAN) {
                result2.addStatement("$T.hashCode($N)", Boolean.class, fieldName);
                continue;
            }
            if (typeName == TypeName.INT) {
                result2.addStatement("$T.hashCode($N)", Integer.class, fieldName);
                continue;
            }
            if (typeName == TypeName.LONG) {
                result2.addStatement("$T.hashCode($N)", Long.class, fieldName);
                continue;
            }
            if (typeName == TypeName.FLOAT) {
                result2.addStatement("$T.hashCode($N)", Float.class, fieldName);
                continue;
            }
            if (typeName == TypeName.DOUBLE) {
                result2.addStatement("$T.hashCode($N)", Double.class, fieldName);
                continue;
            }
            if (field.isRequired() || field.isRepeated() || field.getType().isMap()) {
                result2.addStatement("$L.hashCode()", fieldName);
                continue;
            }
            result2.addStatement("($1L != null ? $1L.hashCode() : 0)", fieldName);
        }
        result2.addStatement("super.hashCode = $N", resultName);
        result2.endControlFlow();
        result2.addStatement("return $N", resultName);
        return result2.build();
    }

    private MethodSpec mapAdapter(NameAllocator nameAllocator, TypeName adapterType, String fieldName, ProtoType mapType) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        String resultName = localNameAllocator.newName("result");
        MethodSpec.Builder result2 = MethodSpec.methodBuilder(fieldName + "Adapter").addModifiers(Modifier.PRIVATE).returns(adapterType);
        result2.addStatement("$T $N = $N", adapterType, resultName, fieldName);
        result2.beginControlFlow("if ($N == null)", resultName);
        result2.addStatement("$N = $T.newMapAdapter($L, $L)", resultName, ADAPTER, this.singleAdapterFor(mapType.getKeyType()), this.singleAdapterFor(mapType.getValueType()));
        result2.addStatement("$N = $N", fieldName, resultName);
        result2.endControlFlow();
        result2.addStatement("return $N", resultName);
        return result2.build();
    }

    private MethodSpec messageToString(NameAllocator nameAllocator, MessageType type) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        MethodSpec.Builder result2 = MethodSpec.methodBuilder("toString").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns((java.lang.reflect.Type)((Object)String.class));
        String builderName = localNameAllocator.newName("builder");
        result2.addStatement("$1T $2N = new $1T()", StringBuilder.class, builderName);
        for (Field field : type.getFieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get(field);
            TypeName fieldType = this.fieldType(field);
            if (field.isRepeated() || field.getType().isMap()) {
                result2.addCode("if (!$N.isEmpty()) ", fieldName);
            } else if (!field.isRequired() && !fieldType.isPrimitive()) {
                result2.addCode("if ($N != null) ", fieldName);
            }
            if (field.isRedacted()) {
                result2.addStatement("$N.append(\", $N=$L\")", builderName, field.getName(), DOUBLE_FULL_BLOCK);
                continue;
            }
            if (field.getType().equals(ProtoType.STRING)) {
                result2.addStatement("$N.append(\", $N=\").append($T.sanitize($L))", builderName, field.getName(), Internal.class, fieldName);
                continue;
            }
            result2.addStatement("$N.append(\", $N=\").append($L)", builderName, field.getName(), fieldName);
        }
        result2.addStatement("return builder.replace(0, 2, \"$L{\").append('}').toString()", type.getType().getSimpleName());
        return result2.build();
    }

    private TypeSpec builder(NameAllocator nameAllocator, MessageType type, ClassName javaType, ClassName builderType) {
        TypeSpec.Builder result2 = TypeSpec.classBuilder("Builder").addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
        result2.superclass(JavaGenerator.builderOf(javaType, builderType));
        for (Field field : type.getFieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get(field);
            result2.addField(this.fieldType(field), fieldName, Modifier.PUBLIC);
        }
        result2.addMethod(this.builderNoArgsConstructor(nameAllocator, type));
        for (Field field : type.fields()) {
            result2.addMethod(this.setter(nameAllocator, builderType, null, field));
        }
        for (OneOf oneOf : type.getOneOfs()) {
            for (Field field : oneOf.getFields()) {
                result2.addMethod(this.setter(nameAllocator, builderType, oneOf, field));
            }
        }
        result2.addMethod(this.builderBuild(nameAllocator, type, javaType));
        return result2.build();
    }

    private MethodSpec builderNoArgsConstructor(NameAllocator nameAllocator, MessageType type) {
        MethodSpec.Builder result2 = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC);
        for (Field field : type.getFieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get(field);
            CodeBlock initialValue = this.initialValue(field);
            if (initialValue == null) continue;
            result2.addStatement("$L = $L", fieldName, initialValue);
        }
        return result2.build();
    }

    @Nullable
    private CodeBlock initialValue(Field field) {
        if (field.isPacked() || field.isRepeated()) {
            return CodeBlock.of("$T.newMutableList()", Internal.class);
        }
        if (field.getType().isMap()) {
            return CodeBlock.of("$T.newMutableMap()", Internal.class);
        }
        if (field.getEncodeMode() == Field.EncodeMode.OMIT_IDENTITY) {
            CodeBlock identityValue = this.identityValue(field);
            if (identityValue.equals(CodeBlock.of("null", new Object[0]))) {
                return null;
            }
            return this.identityValue(field);
        }
        return null;
    }

    private MethodSpec newBuilder(NameAllocator nameAllocator, MessageType message) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        String builderName = localNameAllocator.newName("builder");
        ClassName javaType = (ClassName)this.typeName(message.getType());
        ClassName builderJavaType = javaType.nestedClass("Builder");
        MethodSpec.Builder result2 = MethodSpec.methodBuilder("newBuilder").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(builderJavaType).addStatement("$1T $2L = new $1T()", builderJavaType, builderName);
        List<Field> fields2 = message.getFieldsAndOneOfFields();
        for (Field field : fields2) {
            String fieldName = localNameAllocator.get(field);
            if (field.isRepeated() || field.getType().isMap()) {
                result2.addStatement("$1L.$2L = $3T.copyOf($2L)", builderName, fieldName, Internal.class);
                continue;
            }
            result2.addStatement("$1L.$2L = $2L", builderName, fieldName);
        }
        result2.addStatement("$L.addUnknownFields(unknownFields())", builderName);
        result2.addStatement("return $L", builderName);
        return result2.build();
    }

    private MethodSpec setter(NameAllocator nameAllocator, TypeName builderType, OneOf oneOf, Field field) {
        TypeName javaType = this.fieldType(field);
        String fieldName = nameAllocator.get(field);
        MethodSpec.Builder result2 = MethodSpec.methodBuilder(fieldName).addModifiers(Modifier.PUBLIC).addParameter(javaType, fieldName, new Modifier[0]).returns(builderType);
        if (!field.getDocumentation().isEmpty()) {
            result2.addJavadoc("$L\n", JavaGenerator.sanitizeJavadoc(field.getDocumentation()));
        }
        if (field.isDeprecated()) {
            result2.addAnnotation(Deprecated.class);
        }
        if (field.isRepeated() || field.getType().isMap()) {
            result2.addStatement("$T.checkElementsNotNull($L)", Internal.class, fieldName);
        }
        result2.addStatement("this.$L = $L", fieldName, fieldName);
        if (oneOf != null) {
            for (Field other : oneOf.getFields()) {
                if (field == other) continue;
                result2.addStatement("this.$L = null", nameAllocator.get(other));
            }
        }
        result2.addStatement("return this", new Object[0]);
        return result2.build();
    }

    private MethodSpec builderBuild(NameAllocator nameAllocator, MessageType message, ClassName javaType) {
        MethodSpec.Builder result2 = MethodSpec.methodBuilder("build").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(javaType);
        List<Field> requiredFields = message.getRequiredFields();
        if (!requiredFields.isEmpty()) {
            CodeBlock.Builder conditionals = CodeBlock.builder().add("$[", new Object[0]);
            CodeBlock.Builder missingArgs = CodeBlock.builder();
            for (int i = 0; i < requiredFields.size(); ++i) {
                Field requiredField = requiredFields.get(i);
                if (i > 0) {
                    conditionals.add("\n|| ", new Object[0]);
                }
                conditionals.add("$L == null", nameAllocator.get(requiredField));
                if (i > 0) {
                    missingArgs.add(",\n", new Object[0]);
                }
                missingArgs.add("$1L, $2S", nameAllocator.get(requiredField), requiredField.getName());
            }
            result2.beginControlFlow("if ($L)", conditionals.add("$]", new Object[0]).build()).addStatement("throw $T.missingRequiredFields($L)", Internal.class, missingArgs.build()).endControlFlow();
        }
        boolean constructorTakesAllFields = this.constructorTakesAllFields(message);
        result2.addCode("return new $T(", javaType);
        if (constructorTakesAllFields) {
            for (Field field : message.getFieldsAndOneOfFields()) {
                result2.addCode("$L, ", nameAllocator.get(field));
            }
        } else {
            result2.addCode("this, ", new Object[0]);
        }
        result2.addCode("super.buildUnknownFields());\n", new Object[0]);
        return result2.build();
    }

    private CodeBlock defaultValue(Field field) {
        String defaultValue = field.getDefault();
        if (defaultValue == null && this.isEnum(field.getType())) {
            defaultValue = this.enumDefault(field.getType()).getName();
        }
        if (field.getType().isScalar() || defaultValue != null) {
            return this.fieldInitializer(field.getType(), defaultValue, false);
        }
        throw new IllegalStateException("Field " + field + " cannot have default value");
    }

    private CodeBlock fieldInitializer(ProtoType type, @Nullable Object value, boolean annotation) {
        TypeName javaType = this.typeName(type);
        if (value instanceof List) {
            CodeBlock.Builder builder = CodeBlock.builder();
            if (annotation) {
                builder.add("{", new Object[0]);
            } else {
                builder.add("$T.asList(", Arrays.class);
            }
            boolean first2 = true;
            for (Object o : (List)value) {
                if (!first2) {
                    builder.add(",", new Object[0]);
                }
                first2 = false;
                builder.add("\n$>$>$L$<$<", this.fieldInitializer(type, o, annotation));
            }
            builder.add(annotation ? "}" : ")", new Object[0]);
            return builder.build();
        }
        if (value instanceof Map) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("new $T.Builder()", javaType);
            for (Map.Entry entry : ((Map)value).entrySet()) {
                ProtoMember protoMember = (ProtoMember)entry.getKey();
                Field field = this.schema.getField(protoMember);
                CodeBlock valueInitializer = this.fieldInitializer(field.getType(), entry.getValue(), annotation);
                builder.add("\n$>$>.$L($L)$<$<", this.fieldName(type, field), valueInitializer);
            }
            builder.add("\n$>$>.build()$<$<", new Object[0]);
            return builder.build();
        }
        if (javaType.equals(TypeName.BOOLEAN)) {
            return CodeBlock.of("$L", value != null ? value : Boolean.valueOf(false));
        }
        if (javaType.equals(TypeName.INT)) {
            return CodeBlock.of("$L", JvmLanguages.optionValueToInt(value));
        }
        if (javaType.equals(TypeName.LONG)) {
            return CodeBlock.of("$LL", JvmLanguages.optionValueToLong(value));
        }
        if (javaType.equals(TypeName.FLOAT)) {
            if (value == null) {
                return CodeBlock.of("0.0f", new Object[0]);
            }
            if ("inf".equals(value)) {
                return CodeBlock.of("Float.POSITIVE_INFINITY", new Object[0]);
            }
            if ("-inf".equals(value)) {
                return CodeBlock.of("Float.NEGATIVE_INFINITY", new Object[0]);
            }
            if ("nan".equals(value) || "-nan".equals(value)) {
                return CodeBlock.of("Float.NaN", new Object[0]);
            }
            return CodeBlock.of("$Lf", String.valueOf(value));
        }
        if (javaType.equals(TypeName.DOUBLE)) {
            if (value == null) {
                return CodeBlock.of("0.0d", new Object[0]);
            }
            if ("inf".equals(value)) {
                return CodeBlock.of("Double.POSITIVE_INFINITY", new Object[0]);
            }
            if ("-inf".equals(value)) {
                return CodeBlock.of("Double.NEGATIVE_INFINITY", new Object[0]);
            }
            if ("nan".equals(value) || "-nan".equals(value)) {
                return CodeBlock.of("Double.NaN", new Object[0]);
            }
            return CodeBlock.of("$Ld", String.valueOf(value));
        }
        if (javaType.equals(STRING)) {
            return CodeBlock.of("$S", value != null ? value : "");
        }
        if (javaType.equals(BYTE_STRING)) {
            if (value == null) {
                return CodeBlock.of("$T.EMPTY", ByteString.class);
            }
            return CodeBlock.of("$T.decodeBase64($S)", ByteString.class, ByteString.encodeString(String.valueOf(value), Charsets.ISO_8859_1).base64());
        }
        if (this.isEnum(type) && value != null) {
            return CodeBlock.of("$T.$L", javaType, value);
        }
        throw new IllegalStateException(type + " is not an allowed scalar type");
    }

    private CodeBlock identityValue(Field field) {
        switch (field.getEncodeMode()) {
            case MAP: {
                return CodeBlock.of("$T.emptyMap()", Collections.class);
            }
            case REPEATED: 
            case PACKED: {
                return CodeBlock.of("$T.emptyList()", Collections.class);
            }
            case NULL_IF_ABSENT: {
                return CodeBlock.of("null", new Object[0]);
            }
            case OMIT_IDENTITY: {
                ProtoType protoType = field.getType();
                Type type = this.schema.getType(protoType);
                if (protoType.equals(ProtoType.STRUCT_NULL)) {
                    return CodeBlock.of("null", new Object[0]);
                }
                if (field.isOneOf()) {
                    return CodeBlock.of("null", new Object[0]);
                }
                if (protoType.isScalar()) {
                    CodeBlock value = PROTOTYPE_TO_IDENTITY_VALUES.get(protoType);
                    if (value == null) {
                        throw new IllegalArgumentException("Unexpected scalar proto type: " + protoType);
                    }
                    return value;
                }
                if (type instanceof MessageType) {
                    return CodeBlock.of("null", new Object[0]);
                }
                if (!(type instanceof EnumType)) break;
                return this.identity((EnumType)type);
            }
        }
        throw new IllegalArgumentException("No identity value for field: " + field + "(" + (Object)((Object)field.getEncodeMode()) + ")");
    }

    private CodeBlock identity(EnumType enumType) {
        EnumConstant constantZero = enumType.constant(0);
        if (constantZero == null) {
            return CodeBlock.of("null", new Object[0]);
        }
        return CodeBlock.of("$T.$L", this.typeName(enumType.getType()), this.nameAllocators.getUnchecked(enumType).get(constantZero));
    }

    public ClassName generatedTypeName(ProtoMember member) {
        return (ClassName)this.memberToJavaName.get(member);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public TypeSpec generateOptionType(Extend extend, Field field) {
        TypeName returnType;
        Preconditions.checkArgument(extend.getFields().contains(field));
        if (!this.emitDeclaredOptions) {
            return null;
        }
        ElementType elementType = JvmLanguages.annotationTargetType(extend);
        if (elementType == null) {
            return null;
        }
        if (!JvmLanguages.eligibleAsAnnotationMember(this.schema, field)) {
            return null;
        }
        if (field.getLabel().equals((Object)Field.Label.REPEATED)) {
            TypeName typeName = this.typeName(field.getType());
            if (!typeName.equals(TypeName.LONG) && !typeName.equals(TypeName.INT) && !typeName.equals(TypeName.FLOAT) && !typeName.equals(TypeName.DOUBLE) && !typeName.equals(TypeName.BOOLEAN) && !typeName.equals(ClassName.get(String.class)) && !this.isEnum(field.getType())) throw new IllegalStateException("Unsupported annotation for " + field.getType());
            returnType = ArrayTypeName.of(typeName);
        } else {
            returnType = this.typeName(field.getType());
        }
        ClassName javaType = this.generatedTypeName(extend.member(field));
        TypeSpec.Builder builder = TypeSpec.annotationBuilder(javaType.simpleName()).addModifiers(Modifier.PUBLIC).addAnnotation(AnnotationSpec.builder(Retention.class).addMember("value", "$T.$L", new Object[]{RetentionPolicy.class, RetentionPolicy.RUNTIME}).build()).addAnnotation(AnnotationSpec.builder(Target.class).addMember("value", "$T.$L", new Object[]{ElementType.class, elementType}).build());
        if (!field.getDocumentation().isEmpty()) {
            builder.addJavadoc("$L\n", field.getDocumentation());
        }
        builder.addMethod(MethodSpec.methodBuilder("value").returns(returnType).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).build());
        return builder.build();
    }

    private List<AnnotationSpec> optionAnnotations(Options options) {
        ArrayList<AnnotationSpec> result2 = new ArrayList<AnnotationSpec>();
        for (Map.Entry<ProtoMember, Object> entry : options.getMap().entrySet()) {
            AnnotationSpec annotationSpec = this.optionAnnotation(entry.getKey(), entry.getValue());
            if (annotationSpec == null) continue;
            result2.add(annotationSpec);
        }
        return result2;
    }

    @Nullable
    private AnnotationSpec optionAnnotation(ProtoMember protoMember, Object value) {
        if (!this.emitAppliedOptions) {
            return null;
        }
        Field field = this.schema.getField(protoMember);
        if (field == null) {
            return null;
        }
        if (!JvmLanguages.eligibleAsAnnotationMember(this.schema, field)) {
            return null;
        }
        ClassName type = (ClassName)this.memberToJavaName.get(protoMember);
        CodeBlock fieldValue = this.fieldInitializer(field.getType(), value, true);
        return AnnotationSpec.builder(type).addMember("value", fieldValue).build();
    }

    private static class ClassNameFactory
    implements NameFactory<ClassName> {
        private ClassNameFactory() {
        }

        @Override
        public ClassName newName(String packageName, String simpleName) {
            return ClassName.get(packageName, simpleName, new String[0]);
        }

        @Override
        public ClassName nestedName(ClassName enclosing, String simpleName) {
            return enclosing.nestedClass(simpleName);
        }
    }
}

