/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.GrpcCall;
import com.squareup.wire.GrpcMethod;
import com.squareup.wire.WireGrpcClient;
import com.squareup.wire.internal.GrpcKt;
import com.squareup.wire.internal.GrpcMessageSource;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.ForwardingTimeout;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0010H\u0016J\u0016\u0010\"\u001a\u00028\u00012\u0006\u0010#\u001a\u00028\u0000H\u0096@\u00a2\u0006\u0002\u0010$J\u0015\u0010%\u001a\u00028\u00012\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J)\u0010'\u001a\u00020 2\u0006\u0010#\u001a\u00028\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010)H\u0016\u00a2\u0006\u0002\u0010*J\u0011\u0010+\u001a\u00028\u0001*\u00020,H\u0002\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u00020\u0010H\u0016J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u0015\u00100\u001a\u00020\u000e2\u0006\u0010#\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00101R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR:\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019\u00a8\u00062"}, d2={"Lcom/squareup/wire/internal/RealGrpcCall;", "S", "", "R", "Lcom/squareup/wire/GrpcCall;", "grpcClient", "Lcom/squareup/wire/WireGrpcClient;", "method", "Lcom/squareup/wire/GrpcMethod;", "<init>", "(Lcom/squareup/wire/WireGrpcClient;Lcom/squareup/wire/GrpcMethod;)V", "getMethod", "()Lcom/squareup/wire/GrpcMethod;", "call", "Lokhttp3/Call;", "canceled", "", "timeout", "Lokio/Timeout;", "getTimeout", "()Lokio/Timeout;", "requestMetadata", "", "", "getRequestMetadata", "()Ljava/util/Map;", "setRequestMetadata", "(Ljava/util/Map;)V", "value", "responseMetadata", "getResponseMetadata", "cancel", "", "isCanceled", "execute", "request", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeBlocking", "(Ljava/lang/Object;)Ljava/lang/Object;", "enqueue", "callback", "Lcom/squareup/wire/GrpcCall$Callback;", "(Ljava/lang/Object;Lcom/squareup/wire/GrpcCall$Callback;)V", "readExactlyOneAndClose", "Lokhttp3/Response;", "(Lokhttp3/Response;)Ljava/lang/Object;", "isExecuted", "clone", "initCall", "(Ljava/lang/Object;)Lokhttp3/Call;", "wire-grpc-client"})
@SourceDebugExtension(value={"SMAP\nRealGrpcCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealGrpcCall.kt\ncom/squareup/wire/internal/RealGrpcCall\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n318#2,11:151\n1#3:162\n*S KotlinDebug\n*F\n+ 1 RealGrpcCall.kt\ncom/squareup/wire/internal/RealGrpcCall\n*L\n54#1:151,11\n*E\n"})
public final class RealGrpcCall<S, R>
implements GrpcCall<S, R> {
    @NotNull
    private final WireGrpcClient grpcClient;
    @NotNull
    private final GrpcMethod<S, R> method;
    @Nullable
    private Call call;
    private boolean canceled;
    @NotNull
    private final Timeout timeout;
    @NotNull
    private Map<String, String> requestMetadata;
    @Nullable
    private Map<String, String> responseMetadata;

    public RealGrpcCall(@NotNull WireGrpcClient grpcClient, @NotNull GrpcMethod<S, R> method) {
        Intrinsics.checkNotNullParameter(grpcClient, "grpcClient");
        Intrinsics.checkNotNullParameter(method, "method");
        this.grpcClient = grpcClient;
        this.method = method;
        this.timeout = new ForwardingTimeout(new Timeout());
        this.requestMetadata = MapsKt.emptyMap();
    }

    @Override
    @NotNull
    public GrpcMethod<S, R> getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public Timeout getTimeout() {
        return this.timeout;
    }

    @Override
    @NotNull
    public Map<String, String> getRequestMetadata() {
        return this.requestMetadata;
    }

    @Override
    public void setRequestMetadata(@NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.requestMetadata = map2;
    }

    @Override
    @Nullable
    public Map<String, String> getResponseMetadata() {
        return this.responseMetadata;
    }

    @Override
    public void cancel() {
        block0: {
            this.canceled = true;
            Call call = this.call;
            if (call == null) break block0;
            call.cancel();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCanceled() {
        if (this.canceled) return true;
        Call call = this.call;
        if (call == null) return false;
        if (!call.isCanceled()) return false;
        return true;
    }

    @Override
    @Nullable
    public Object execute(@NotNull S request, @NotNull Continuation<? super R> $completion) {
        Call call = this.initCall(request);
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super R> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl<R> cancellable$iv = new CancellableContinuationImpl<R>(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = cancellable$iv;
        boolean bl2 = false;
        continuation.invokeOnCancellation((Function1<Throwable, Unit>)new Function1<Throwable, Unit>(this){
            final /* synthetic */ RealGrpcCall<S, R> this$0;
            {
                this.this$0 = $receiver;
            }

            public final void invoke(Throwable it) {
                this.this$0.cancel();
            }
        });
        call.enqueue(new Callback(continuation, this){
            final /* synthetic */ CancellableContinuation<R> $continuation;
            final /* synthetic */ RealGrpcCall<S, R> this$0;
            {
                this.$continuation = $continuation;
                this.this$0 = $receiver;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter(call, "call");
                Intrinsics.checkNotNullParameter(e, "e");
                ((Continuation)this.$continuation).resumeWith(Result.constructor-impl(ResultKt.createFailure(e)));
            }

            public void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter(call, "call");
                Intrinsics.checkNotNullParameter(response, "response");
                try {
                    RealGrpcCall.access$setResponseMetadata$p(this.this$0, MapsKt.toMap(response.headers()));
                    Object message = RealGrpcCall.access$readExactlyOneAndClose(this.this$0, response);
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl(message));
                }
                catch (IOException e) {
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl(ResultKt.createFailure(e)));
                }
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Override
    @NotNull
    public R executeBlocking(@NotNull S request) {
        Intrinsics.checkNotNullParameter(request, "request");
        Call call = this.initCall(request);
        Response response = call.execute();
        this.responseMetadata = MapsKt.toMap(response.headers());
        return this.readExactlyOneAndClose(response);
    }

    @Override
    public void enqueue(@NotNull S request, @NotNull GrpcCall.Callback<S, R> callback) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(callback, "callback");
        Call call = this.initCall(request);
        call.enqueue(new Callback(callback, this){
            final /* synthetic */ GrpcCall.Callback<S, R> $callback;
            final /* synthetic */ RealGrpcCall<S, R> this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter(call, "call");
                Intrinsics.checkNotNullParameter(e, "e");
                this.$callback.onFailure(this.this$0, e);
            }

            public void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter(call, "call");
                Intrinsics.checkNotNullParameter(response, "response");
                try {
                    RealGrpcCall.access$setResponseMetadata$p(this.this$0, MapsKt.toMap(response.headers()));
                    Object message = RealGrpcCall.access$readExactlyOneAndClose(this.this$0, response);
                    this.$callback.onSuccess((GrpcCall)this.this$0, message);
                }
                catch (IOException e) {
                    this.$callback.onFailure(this.this$0, e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R readExactlyOneAndClose(Response $this$readExactlyOneAndClose) {
        Closeable closeable = $this$readExactlyOneAndClose;
        Throwable throwable = null;
        try {
            Object t2;
            Response it = (Response)closeable;
            boolean bl = false;
            Closeable closeable2 = GrpcKt.messageSource($this$readExactlyOneAndClose, this.getMethod().getResponseAdapter());
            Throwable throwable2 = null;
            try {
                IOException exception;
                Object t3;
                GrpcMessageSource reader = (GrpcMessageSource)closeable2;
                boolean bl2 = false;
                try {
                    t3 = reader.readExactlyOneAndClose();
                }
                catch (IOException e) {
                    IOException iOException = GrpcKt.grpcResponseToException($this$readExactlyOneAndClose, e);
                    Intrinsics.checkNotNull(iOException);
                    throw iOException;
                }
                Object result2 = t3;
                IOException iOException = exception = GrpcKt.grpcResponseToException$default($this$readExactlyOneAndClose, null, 1, null);
                if (iOException != null) {
                    throw iOException;
                }
                t2 = result2;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally(closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally(closeable2, throwable2);
            Object t4 = t2;
            return (R)t4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @Override
    public boolean isExecuted() {
        Call call = this.call;
        return call != null ? call.isExecuted() : false;
    }

    @Override
    @NotNull
    public GrpcCall<S, R> clone() {
        Timeout timeout2;
        RealGrpcCall<S, R> result2 = new RealGrpcCall<S, R>(this.grpcClient, this.getMethod());
        Timeout oldTimeout = this.getTimeout();
        Timeout newTimeout = timeout2 = result2.getTimeout();
        boolean bl = false;
        newTimeout.timeout(oldTimeout.timeoutNanos(), TimeUnit.NANOSECONDS);
        if (oldTimeout.hasDeadline()) {
            newTimeout.deadlineNanoTime(oldTimeout.deadlineNanoTime());
        }
        result2.setRequestMetadata(MapsKt.plus(result2.getRequestMetadata(), this.getRequestMetadata()));
        return result2;
    }

    private final Call initCall(S request) {
        Call result2;
        if (!(this.call == null)) {
            boolean $i$a$-check-RealGrpcCall$initCall$22 = false;
            String $i$a$-check-RealGrpcCall$initCall$22 = "already executed";
            throw new IllegalStateException($i$a$-check-RealGrpcCall$initCall$22.toString());
        }
        RequestBody requestBody = GrpcKt.newRequestBody(this.grpcClient.getMinMessageToCompress$wire_grpc_client(), this.getMethod().getRequestAdapter(), request);
        this.call = result2 = this.grpcClient.newCall$wire_grpc_client(this.getMethod(), this.getRequestMetadata(), requestBody, this.getTimeout());
        if (this.canceled) {
            result2.cancel();
        }
        if (!this.getTimeout().hasDeadline() && this.getTimeout().timeoutNanos() == 0L) {
            Timeout timeout2 = this.getTimeout();
            Intrinsics.checkNotNull(timeout2, "null cannot be cast to non-null type okio.ForwardingTimeout");
            ((ForwardingTimeout)timeout2).setDelegate(result2.timeout());
        }
        return result2;
    }

    public static final /* synthetic */ void access$setResponseMetadata$p(RealGrpcCall $this, Map map2) {
        $this.responseMetadata = map2;
    }

    public static final /* synthetic */ Object access$readExactlyOneAndClose(RealGrpcCall $this, Response $receiver) {
        return $this.readExactlyOneAndClose($receiver);
    }
}

