/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.WireLogger;
import com.squareup.wire.schema.ProtoType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\rH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/squareup/wire/ConsoleWireLogger;", "Lcom/squareup/wire/WireLogger;", "<init>", "()V", "quiet", "", "getQuiet", "()Z", "setQuiet", "(Z)V", "unusedRoots", "", "", "", "unusedPrunes", "unusedIncludesInTarget", "unusedIncludes", "unusedExcludesInTarget", "unusedExcludes", "artifactHandled", "outputPath", "Lokio/Path;", "qualifiedName", "targetName", "artifactSkipped", "type", "Lcom/squareup/wire/schema/ProtoType;", "wire-compiler"})
public final class ConsoleWireLogger
implements WireLogger {
    private boolean quiet;

    public final boolean getQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    @Override
    public void unusedRoots(@NotNull Set<String> unusedRoots) {
        Intrinsics.checkNotNullParameter(unusedRoots, "unusedRoots");
        if (this.quiet) {
            return;
        }
        String string = StringsKt.trimMargin$default("Unused element in treeShakingRoots:\n      |  " + CollectionsKt.joinToString$default(unusedRoots, "\n  ", null, null, 0, null, null, 62, null) + "\n      ", null, 1, null);
        System.out.println((Object)string);
    }

    @Override
    public void unusedPrunes(@NotNull Set<String> unusedPrunes) {
        Intrinsics.checkNotNullParameter(unusedPrunes, "unusedPrunes");
        if (this.quiet) {
            return;
        }
        String string = StringsKt.trimMargin$default("Unused element in treeShakingRubbish:\n      |  " + CollectionsKt.joinToString$default(unusedPrunes, "\n  ", null, null, 0, null, null, 62, null) + "\n      ", null, 1, null);
        System.out.println((Object)string);
    }

    @Override
    public void unusedIncludesInTarget(@NotNull Set<String> unusedIncludes) {
        Intrinsics.checkNotNullParameter(unusedIncludes, "unusedIncludes");
        if (this.quiet) {
            return;
        }
        String string = StringsKt.trimMargin$default("Unused includes in targets:\n      |  " + CollectionsKt.joinToString$default(unusedIncludes, "\n  ", null, null, 0, null, null, 62, null) + "\n      ", null, 1, null);
        System.out.println((Object)string);
    }

    @Override
    public void unusedExcludesInTarget(@NotNull Set<String> unusedExcludes) {
        Intrinsics.checkNotNullParameter(unusedExcludes, "unusedExcludes");
        if (this.quiet) {
            return;
        }
        String string = StringsKt.trimMargin$default("Unused excludes in targets:\n      |  " + CollectionsKt.joinToString$default(unusedExcludes, "\n  ", null, null, 0, null, null, 62, null) + "\n      ", null, 1, null);
        System.out.println((Object)string);
    }

    @Override
    public void artifactHandled(@NotNull Path outputPath, @NotNull String qualifiedName, @NotNull String targetName) {
        Intrinsics.checkNotNullParameter(outputPath, "outputPath");
        Intrinsics.checkNotNullParameter(qualifiedName, "qualifiedName");
        Intrinsics.checkNotNullParameter(targetName, "targetName");
        if (this.quiet) {
            return;
        }
        System.out.println((Object)("Writing " + qualifiedName + " to " + outputPath + " (target=" + targetName + ')'));
    }

    @Override
    public void artifactSkipped(@NotNull ProtoType type, @NotNull String targetName) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(targetName, "targetName");
        if (this.quiet) {
            return;
        }
        System.out.println((Object)("Skipping " + type + " (target=" + targetName + ')'));
    }
}

