/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ingestion.telemetry;

import com.mulesoft.ingestion.client.IngestionClientFactory;
import com.mulesoft.ingestion.client.TelemetryIngestionClient;
import com.mulesoft.ingestion.telemetry.TelemetryReporter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.Validate;

public class TelemetryReporterBuilder {
    private TelemetryIngestionClient telemetryIngestionClient;
    private final Properties properties = new Properties();
    private final Map<String, Object> commonDataPointAttributes = new HashMap<String, Object>();
    private static final String ERROR_MSG_SET_PROP_WHEN_CLIENT_SET = "Cannot set properties when TelemetryIngestionClient is already set";
    private static final String ERROR_MSG_SET_RESOURCE_ATTRIBUTES_WHEN_CLIENT_SET = "Cannot set resource attributes when TelemetryIngestionClient is already set";

    TelemetryReporterBuilder() {
    }

    public TelemetryReporterBuilder withProperty(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Validate.isTrue(this.telemetryIngestionClient == null, ERROR_MSG_SET_PROP_WHEN_CLIENT_SET, new Object[0]);
        this.properties.put(key, value);
        return this;
    }

    public TelemetryReporterBuilder withProperties(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        Validate.isTrue(this.telemetryIngestionClient == null, ERROR_MSG_SET_PROP_WHEN_CLIENT_SET, new Object[0]);
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public TelemetryReporterBuilder withResourceAttribute(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Validate.isTrue(this.telemetryIngestionClient == null, ERROR_MSG_SET_RESOURCE_ATTRIBUTES_WHEN_CLIENT_SET, new Object[0]);
        this.properties.put(String.format("%s.%s", "telemetry.resource", key), value);
        return this;
    }

    public TelemetryReporterBuilder withResourceAttributes(@NonNull Map<String, String> resourceAttributes) {
        if (resourceAttributes == null) {
            throw new NullPointerException("resourceAttributes is marked non-null but is null");
        }
        Validate.isTrue(this.telemetryIngestionClient == null, ERROR_MSG_SET_RESOURCE_ATTRIBUTES_WHEN_CLIENT_SET, new Object[0]);
        resourceAttributes.forEach((key, value) -> this.properties.put(String.format("%s.%s", "telemetry.resource", key), value));
        return this;
    }

    public TelemetryReporterBuilder withCommonDataPointAttributes(@NonNull Map<String, Object> commonDataPointAttributes) {
        if (commonDataPointAttributes == null) {
            throw new NullPointerException("commonDataPointAttributes is marked non-null but is null");
        }
        this.commonDataPointAttributes.putAll(commonDataPointAttributes);
        return this;
    }

    public TelemetryReporterBuilder withCommonDataPointAttribute(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.commonDataPointAttributes.put(key, value);
        return this;
    }

    public TelemetryReporterBuilder withIngestionClient(@NonNull TelemetryIngestionClient telemetryIngestionClient) {
        if (telemetryIngestionClient == null) {
            throw new NullPointerException("telemetryIngestionClient is marked non-null but is null");
        }
        Validate.isTrue(this.properties.isEmpty(), "Cannot set TelemetryIngestionClient when properties/resource attributes are already set", new Object[0]);
        this.telemetryIngestionClient = telemetryIngestionClient;
        return this;
    }

    public TelemetryReporter build() throws ConfigurationException {
        if (this.telemetryIngestionClient == null) {
            IngestionClientFactory ingestionClientFactory = IngestionClientFactory.getInstance();
            this.telemetryIngestionClient = ingestionClientFactory.getTelemetryIngestionClient(this.properties);
        }
        return new TelemetryReporter(this.telemetryIngestionClient, new HashMap<String, Object>(this.commonDataPointAttributes));
    }
}

