/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ingestion.telemetry;

import com.mulesoft.ingestion.client.TelemetryIngestionClient;
import com.mulesoft.ingestion.telemetry.DiskBufferStatus;
import com.mulesoft.ingestion.telemetry.MapToAttributesMapper;
import com.mulesoft.ingestion.telemetry.TelemetryReporterBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongGauge;
import io.opentelemetry.api.metrics.Meter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryReporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelemetryReporter.class);
    private final Meter meter;
    final Map<String, Object> commonDataPointAttributes;
    private final Map<String, LongCounter> registryLongCounter = new HashMap<String, LongCounter>();
    private final Map<String, LongGauge> registryLongGauge = new HashMap<String, LongGauge>();
    private final MapToAttributesMapper mapToAttributesMapper = MapToAttributesMapper.getInstance();
    TelemetryIngestionClient telemetryIngestionClient;

    public static TelemetryReporterBuilder builder() {
        return new TelemetryReporterBuilder();
    }

    TelemetryReporter(@NonNull TelemetryIngestionClient telemetryIngestionClient, @NonNull Map<String, Object> commonDataPointAttributes) {
        if (telemetryIngestionClient == null) {
            throw new NullPointerException("telemetryIngestionClient is marked non-null but is null");
        }
        if (commonDataPointAttributes == null) {
            throw new NullPointerException("commonDataPointAttributes is marked non-null but is null");
        }
        this.telemetryIngestionClient = telemetryIngestionClient;
        this.meter = telemetryIngestionClient.getOpenTelemetry().getMeter(TelemetryReporter.class.getName());
        this.commonDataPointAttributes = commonDataPointAttributes;
    }

    public void registerLongCounter(String name, String description, String unit) {
        log.debug("Registering long counter: {}", (Object)name);
        this.registryLongCounter.put(name, this.meter.counterBuilder(name).setDescription(description).setUnit(unit).build());
        this.telemetryIngestionClient.startMetricsDiskBufferExporterIfNeeded();
    }

    public void incrementLongCounter(String name, long value) {
        log.debug("Incrementing long counter: {} by {}", (Object)name, (Object)value);
        this.incrementLongCounter(name, value, Collections.emptyMap());
        this.telemetryIngestionClient.startMetricsDiskBufferExporterIfNeeded();
    }

    public void incrementLongCounter(String name, long value, Map<String, Object> attributes) {
        log.debug("Incrementing long counter: {} by {} with attributes", (Object)name, (Object)value);
        if (this.registryLongCounter.containsKey(name)) {
            this.registryLongCounter.get(name).add(value, this.mapToAttributesMapper.map(Arrays.asList(this.commonDataPointAttributes, attributes)));
        }
        this.telemetryIngestionClient.startMetricsDiskBufferExporterIfNeeded();
    }

    public void registerLongGauge(String name, String description, String unit) {
        log.debug("Registering long gauge: {}", (Object)name);
        this.registryLongGauge.put(name, this.meter.gaugeBuilder(name).ofLongs().setDescription(description).setUnit(unit).build());
        this.telemetryIngestionClient.startMetricsDiskBufferExporterIfNeeded();
    }

    public void setLongGauge(String name, long value) {
        log.debug("Setting long gauge: {} to {}", (Object)name, (Object)value);
        this.setLongGauge(name, value, Collections.emptyMap());
        this.telemetryIngestionClient.startMetricsDiskBufferExporterIfNeeded();
    }

    public void setLongGauge(String name, long value, Map<String, Object> attributes) {
        log.debug("Setting long gauge: {} to {} with attributes", (Object)name, (Object)value);
        if (this.registryLongGauge.containsKey(name)) {
            this.registryLongGauge.get(name).set(value, this.mapToAttributesMapper.map(Arrays.asList(this.commonDataPointAttributes, attributes)));
        }
        this.telemetryIngestionClient.startMetricsDiskBufferExporterIfNeeded();
    }

    public Optional<DiskBufferStatus> getDiskBufferStatus() {
        return this.telemetryIngestionClient.getDiskBufferStatus();
    }

    @Generated
    public TelemetryIngestionClient getTelemetryIngestionClient() {
        return this.telemetryIngestionClient;
    }
}

