/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ingestion.telemetry;

import com.mulesoft.ingestion.telemetry.MultiTelemetryReporter;
import java.util.Map;
import java.util.Properties;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class MultiTelemetryReporterBuilder {
    private final Properties properties = new Properties();
    private String key;

    MultiTelemetryReporterBuilder() {
    }

    public MultiTelemetryReporterBuilder withKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        return this;
    }

    public MultiTelemetryReporterBuilder withProperty(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.properties.put(key, value);
        return this;
    }

    public MultiTelemetryReporterBuilder withProperties(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public MultiTelemetryReporterBuilder withResourceAttribute(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.properties.put("telemetry.resource." + key, value);
        return this;
    }

    public MultiTelemetryReporterBuilder withResourceAttributes(@NonNull Map<String, String> resourceAttributes) {
        if (resourceAttributes == null) {
            throw new NullPointerException("resourceAttributes is marked non-null but is null");
        }
        resourceAttributes.forEach((key, value) -> this.properties.put("telemetry.resource." + key, value));
        return this;
    }

    public MultiTelemetryReporter build() throws ConfigurationException {
        if (this.key == null) {
            throw new ConfigurationException("Key must be specified using withKey() method");
        }
        Properties propertiesCopy = new Properties();
        propertiesCopy.putAll((Map<?, ?>)this.properties);
        return new MultiTelemetryReporter(this.key, propertiesCopy);
    }
}

