/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ingestion.telemetry;

import com.mulesoft.ingestion.telemetry.MultiTelemetryReporterBuilder;
import com.mulesoft.ingestion.telemetry.TelemetryReporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTelemetryReporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiTelemetryReporter.class);
    final Map<String, TelemetryReporter> telemetryReportersMap = new ConcurrentHashMap<String, TelemetryReporter>();
    final Properties properties;
    final String key;
    final List<Map<String, String>> registeredLongCounterMetric = new ArrayList<Map<String, String>>();
    final List<Map<String, String>> registeredLongGaugeMetric = new ArrayList<Map<String, String>>();

    public static MultiTelemetryReporterBuilder builder() {
        return new MultiTelemetryReporterBuilder();
    }

    MultiTelemetryReporter(@NonNull String customKey, @NonNull Properties properties) {
        if (customKey == null) {
            throw new NullPointerException("customKey is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.key = customKey;
        this.properties = properties;
    }

    public void registerLongCounter(String name, String description, String unit) {
        log.debug("Registering long counter metric: {}", (Object)name);
        HashMap<String, String> metric = new HashMap<String, String>();
        metric.put("name", name);
        metric.put("desc", description);
        metric.put("unit", unit);
        this.registeredLongCounterMetric.add(metric);
    }

    public void registerLongGauge(String name, String description, String unit) {
        log.debug("Registering long gauge metric: {}", (Object)name);
        HashMap<String, String> metric = new HashMap<String, String>(3);
        metric.put("name", name);
        metric.put("desc", description);
        metric.put("unit", unit);
        this.registeredLongGaugeMetric.add(metric);
    }

    public void incrementLongCounter(String value, String name, long increment) {
        TelemetryReporter reporter = this.telemetryReportersMap.computeIfAbsent(value, v -> {
            try {
                return this.createReporter((String)v);
            }
            catch (ConfigurationException | ConfigurationRuntimeException e) {
                log.warn("Failed to create reporter to increment long counter for value: {}", (Object)value, (Object)e);
                return null;
            }
        });
        if (reporter != null) {
            reporter.incrementLongCounter(name, increment);
        }
    }

    public void incrementLongCounter(String value, String name, long increment, Map<String, Object> attributes) {
        TelemetryReporter reporter = this.telemetryReportersMap.computeIfAbsent(value, v -> {
            try {
                return this.createReporter((String)v);
            }
            catch (ConfigurationException | ConfigurationRuntimeException e) {
                log.warn("Failed to create reporter to increment long counter for value: {}", (Object)value, (Object)e);
                return null;
            }
        });
        if (reporter != null) {
            reporter.incrementLongCounter(name, increment, attributes);
        }
    }

    public void setLongGauge(String value, String name, long gaugeValue) {
        TelemetryReporter reporter = this.telemetryReportersMap.computeIfAbsent(value, v -> {
            try {
                return this.createReporter((String)v);
            }
            catch (ConfigurationException | ConfigurationRuntimeException e) {
                log.warn("Failed to create reporter to set long gauge for value: {}", (Object)value, (Object)e);
                return null;
            }
        });
        if (reporter != null) {
            reporter.setLongGauge(name, gaugeValue);
        }
    }

    public void setLongGauge(String value, String name, long gaugeValue, Map<String, Object> attributes) {
        TelemetryReporter reporter = this.telemetryReportersMap.computeIfAbsent(value, v -> {
            try {
                return this.createReporter((String)v);
            }
            catch (ConfigurationException | ConfigurationRuntimeException e) {
                log.warn("Failed to create reporter to set long gauge for value: {}", (Object)value, (Object)e);
                return null;
            }
        });
        if (reporter != null) {
            reporter.setLongGauge(name, gaugeValue, attributes);
        }
    }

    private TelemetryReporter createReporter(String value) throws ConfigurationException {
        Properties reporterProperties = new Properties();
        reporterProperties.putAll((Map<?, ?>)this.properties);
        if (reporterProperties.get("telemetry.metrics.sending_queue.type") != null && reporterProperties.get("telemetry.metrics.sending_queue.type").toString().equals("disk")) {
            String originalRootDir = reporterProperties.get("telemetry.metrics.sending_queue.disk.root_dir").toString();
            String uniqueRootDir = originalRootDir + "/" + value;
            reporterProperties.setProperty("telemetry.metrics.sending_queue.disk.root_dir", uniqueRootDir);
        }
        TelemetryReporter reporter = TelemetryReporter.builder().withProperties(reporterProperties).withResourceAttribute(this.key, value).build();
        for (Map<String, String> metric : this.registeredLongCounterMetric) {
            reporter.registerLongCounter(metric.get("name"), metric.get("desc"), metric.get("unit"));
        }
        for (Map<String, String> metric : this.registeredLongGaugeMetric) {
            reporter.registerLongGauge(metric.get("name"), metric.get("desc"), metric.get("unit"));
        }
        return reporter;
    }
}

