/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ingestion.telemetry;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapToAttributesMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapToAttributesMapper.class);
    private static MapToAttributesMapper instance;

    private MapToAttributesMapper() {
    }

    static synchronized MapToAttributesMapper getInstance() {
        if (instance == null) {
            instance = new MapToAttributesMapper();
        }
        return instance;
    }

    Attributes map(List<Map<String, Object>> attributesList) {
        AttributesBuilder builder = Attributes.builder();
        attributesList.forEach(attributes -> attributes.forEach((key, value) -> {
            if (value == null) {
                log.warn("Null value provide for attribute key {}. Skipping.", key);
            } else if (value instanceof String) {
                builder.put((String)key, (String)value);
            } else if (value instanceof Boolean) {
                builder.put((String)key, (boolean)((Boolean)value));
            } else if (value instanceof Long) {
                builder.put((String)key, (long)((Long)value));
            } else if (value instanceof Double) {
                builder.put((String)key, (double)((Double)value));
            } else {
                log.warn("Unsupported attribute type {} for key {}. Skipping.", (Object)value.getClass().getName(), key);
            }
        }));
        return builder.build();
    }
}

