/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ingestion.telemetry;

import java.io.File;
import java.time.Duration;
import lombok.Generated;

public class DiskBufferStatus {
    private final boolean diskBufferingEnabled;
    private final boolean exporterRunning;
    private final String diskBufferDirectory;
    private final int totalBufferedFiles;
    private final long totalBufferedSizeBytes;
    private final Long oldestBufferedAgeMs;
    private final Long newestBufferedAgeMs;
    private final long bufferStuckThresholdMs;

    public DiskBufferStatus(boolean diskBufferingEnabled, boolean exporterRunning, String diskBufferDirectory, int totalBufferedFiles, long totalBufferedSizeBytes, Long oldestBufferedAgeMs, Long newestBufferedAgeMs, long bufferStuckThresholdMs) {
        this.diskBufferingEnabled = diskBufferingEnabled;
        this.exporterRunning = exporterRunning;
        this.diskBufferDirectory = diskBufferDirectory;
        this.totalBufferedFiles = totalBufferedFiles;
        this.totalBufferedSizeBytes = totalBufferedSizeBytes;
        this.oldestBufferedAgeMs = oldestBufferedAgeMs;
        this.newestBufferedAgeMs = newestBufferedAgeMs;
        this.bufferStuckThresholdMs = bufferStuckThresholdMs;
    }

    public static DiskBufferStatus createWithFileScanning(String diskBufferDirectory, boolean exporterRunning, Duration exportInterval, Duration maxFileAgeWrite, Duration initialBackoff, double backoffMultiplier, Duration maxBackoff, int maxAttempts) {
        if (diskBufferDirectory == null) {
            return new DiskBufferStatus(false, false, null, 0, 0L, null, null, 0L);
        }
        long bufferStuckThresholdMs = DiskBufferStatus.calculateBufferStuckThreshold(exportInterval, maxFileAgeWrite, initialBackoff, backoffMultiplier, maxBackoff, maxAttempts);
        String metricsDir = diskBufferDirectory + "/metrics";
        File dir = new File(metricsDir);
        if (!dir.exists() || !dir.isDirectory()) {
            return new DiskBufferStatus(true, exporterRunning, diskBufferDirectory, 0, 0L, null, null, bufferStuckThresholdMs);
        }
        File[] files = dir.listFiles(file -> {
            if (!file.isFile()) {
                return false;
            }
            try {
                Long.parseLong(file.getName());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        if (files == null || files.length == 0) {
            return new DiskBufferStatus(true, exporterRunning, diskBufferDirectory, 0, 0L, null, null, bufferStuckThresholdMs);
        }
        long totalSize = 0L;
        long oldestTimestamp = Long.MAX_VALUE;
        long newestTimestamp = Long.MIN_VALUE;
        long currentTime = System.currentTimeMillis();
        for (File file2 : files) {
            totalSize += file2.length();
            try {
                long timestamp = Long.parseLong(file2.getName());
                oldestTimestamp = Math.min(oldestTimestamp, timestamp);
                newestTimestamp = Math.max(newestTimestamp, timestamp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Long oldestAge = oldestTimestamp == Long.MAX_VALUE ? null : Long.valueOf(currentTime - oldestTimestamp);
        Long newestAge = newestTimestamp == Long.MIN_VALUE ? null : Long.valueOf(currentTime - newestTimestamp);
        return new DiskBufferStatus(true, exporterRunning, diskBufferDirectory, files.length, totalSize, oldestAge, newestAge, bufferStuckThresholdMs);
    }

    public boolean isBufferStuck() {
        return this.oldestBufferedAgeMs != null && this.oldestBufferedAgeMs > this.bufferStuckThresholdMs;
    }

    private static long calculateBufferStuckThreshold(Duration exportInterval, Duration maxFileAgeWrite, Duration initialBackoff, double backoffMultiplier, Duration maxBackoff, int maxAttempts) {
        long exportIntervalMs = exportInterval.toMillis();
        long maxFileAgeWriteMs = maxFileAgeWrite.toMillis();
        long totalRetryTimeMs = 0L;
        long currentBackoffMs = initialBackoff.toMillis();
        long maxBackoffMs = maxBackoff.toMillis();
        for (int attempt = 1; attempt < maxAttempts; ++attempt) {
            totalRetryTimeMs += currentBackoffMs;
            long nextBackoffMs = Math.round((double)currentBackoffMs * backoffMultiplier);
            currentBackoffMs = Math.min(nextBackoffMs, maxBackoffMs);
        }
        long thresholdFromRetries = maxFileAgeWriteMs + totalRetryTimeMs;
        return Math.max(exportIntervalMs, thresholdFromRetries);
    }

    @Generated
    public boolean isDiskBufferingEnabled() {
        return this.diskBufferingEnabled;
    }

    @Generated
    public boolean isExporterRunning() {
        return this.exporterRunning;
    }

    @Generated
    public String getDiskBufferDirectory() {
        return this.diskBufferDirectory;
    }

    @Generated
    public int getTotalBufferedFiles() {
        return this.totalBufferedFiles;
    }

    @Generated
    public long getTotalBufferedSizeBytes() {
        return this.totalBufferedSizeBytes;
    }

    @Generated
    public Long getOldestBufferedAgeMs() {
        return this.oldestBufferedAgeMs;
    }

    @Generated
    public Long getNewestBufferedAgeMs() {
        return this.newestBufferedAgeMs;
    }

    @Generated
    public long getBufferStuckThresholdMs() {
        return this.bufferStuckThresholdMs;
    }
}

