/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ingestion.client;

import com.mulesoft.ingestion.client.ClientUtils;
import com.mulesoft.ingestion.client.DiskBufferExporter;
import com.mulesoft.ingestion.client.MetricsDiskBufferExporter;
import com.mulesoft.ingestion.telemetry.DiskBufferStatus;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.contrib.disk.buffering.MetricToDiskExporter;
import io.opentelemetry.contrib.disk.buffering.StorageConfiguration;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.export.ProxyOptions;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryIngestionClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelemetryIngestionClient.class);
    private final Configuration config;
    private final Resource resource;
    private final OpenTelemetry openTelemetry;
    private DiskBufferExporter metricsDiskBufferExporter;
    private CompletableFuture<Void> metricsDiskBufferExporterFuture;

    protected TelemetryIngestionClient(@NonNull Configuration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.resource = this.buildResource();
        this.openTelemetry = this.buildOpenTelemetry();
    }

    private OpenTelemetry buildOpenTelemetry() {
        String format = this.config.getString("telemetry.format");
        if (format.equals("otlp")) {
            try {
                return this.buildOtlpHttpOpenTelemetry();
            }
            catch (Exception e) {
                throw new ConfigurationRuntimeException("Invalid configuration found", e);
            }
        }
        throw new UnsupportedOperationException("Unsupported telemetry format: " + format);
    }

    private OpenTelemetry buildOtlpHttpOpenTelemetry() throws IOException, UnrecoverableKeyException, CertificateException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        OtlpHttpMetricExporter httpMetricExporter;
        MetricExporter finalMetricExporter = httpMetricExporter = this.getOtlpHttpMetricExporter();
        if (ClientUtils.isSendingQueueDisk(this.config)) {
            StorageConfiguration storageConfiguration = ClientUtils.buildDiskStorageConfiguration(this.config);
            finalMetricExporter = MetricToDiskExporter.create(httpMetricExporter, storageConfiguration, httpMetricExporter::getAggregationTemporality);
            this.metricsDiskBufferExporter = new MetricsDiskBufferExporter(httpMetricExporter, storageConfiguration, this.config.getDuration("telemetry.metrics.sending_queue.disk.scan_frequency"), this.config.getDuration("ingestion.endpoint.timeout"));
            Runtime.getRuntime().addShutdownHook(new Thread(this.metricsDiskBufferExporter::close));
        }
        SdkMeterProvider sdkMeterProvider = SdkMeterProvider.builder().setResource(this.resource).registerMetricReader(PeriodicMetricReader.builder(finalMetricExporter).setInterval(this.config.getDuration("telemetry.metrics.export.interval")).build()).build();
        OpenTelemetrySdk otlpSdk = OpenTelemetrySdk.builder().setMeterProvider(sdkMeterProvider).build();
        Runtime.getRuntime().addShutdownHook(new Thread(otlpSdk.getSdkMeterProvider()::shutdown));
        return otlpSdk;
    }

    private OtlpHttpMetricExporter getOtlpHttpMetricExporter() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        String baseIngestionEndpoint = ClientUtils.getBaseIngestionEndpoint(this.config);
        OtlpHttpMetricExporterBuilder metricExporterBuilder = OtlpHttpMetricExporter.builder().setEndpoint(baseIngestionEndpoint + "/metrics").setTimeout(this.config.getDuration("ingestion.endpoint.timeout")).setConnectTimeout(this.config.getDuration("ingestion.endpoint.connect_timeout")).setCompression("gzip").setAggregationTemporalitySelector(AggregationTemporalitySelector.deltaPreferred()).setRetryPolicy(ClientUtils.getRetryPolicy(this.config));
        if (ClientUtils.isTlsStoreFile(this.config)) {
            TrustManager[] trustManagers = ClientUtils.getTrustManagers(this.config.getString("ingestion.tls.truststore_file"), this.config.getString("ingestion.tls.truststore_password"), this.config.getString("ingestion.tls.keystore_type"));
            SSLContext sslContext = ClientUtils.getSslContext(trustManagers, this.config.getString("ingestion.tls.keystore_file"), this.config.getString("ingestion.tls.keystore_password"), this.config.getString("ingestion.tls.keystore_type"));
            metricExporterBuilder.setSslContext(sslContext, (X509TrustManager)trustManagers[0]);
        } else if (ClientUtils.isTlsContent(this.config) || ClientUtils.isTlsContentFile(this.config)) {
            metricExporterBuilder.setClientTls(ClientUtils.getContentFromStringOrFile(this.config, "ingestion.tls.key", "ingestion.tls.key_file"), ClientUtils.getContentFromStringOrFile(this.config, "ingestion.tls.cert", "ingestion.tls.cert_file"));
            byte[] caFileContent = ClientUtils.getContentFromStringOrFile(this.config, "ingestion.tls.ca", "ingestion.tls.ca_file");
            if (caFileContent.length > 0) {
                metricExporterBuilder.setTrustedCertificates(caFileContent);
            }
        }
        ProxyOptions proxyOptions = ClientUtils.getProxyOptions(this.config);
        if (proxyOptions != null) {
            metricExporterBuilder.setProxyOptions(proxyOptions);
        }
        return metricExporterBuilder.build();
    }

    private Resource buildResource() {
        ResourceBuilder builder = Resource.getDefault().toBuilder();
        Iterator<String> it = this.config.getKeys("telemetry.resource");
        while (it.hasNext()) {
            String key = it.next();
            String value = this.config.getString(key);
            if (value == null) continue;
            builder.put(key.substring("telemetry.resource".length() + 1), value);
        }
        return builder.build();
    }

    public void startMetricsDiskBufferExporterIfNeeded() {
        if (ClientUtils.isSendingQueueDisk(this.config)) {
            Validate.notNull(this.metricsDiskBufferExporter, "Telemetry disk buffer exporter is not initialized.", new Object[0]);
            if (this.metricsDiskBufferExporterFuture == null) {
                log.info("Starting telemetry disk buffer exporter.");
                this.startMetricsDiskBufferExporter();
            } else if (this.metricsDiskBufferExporterFuture.isDone()) {
                log.warn("Telemetry disk buffer exporter has been stopped. Starting it again.");
                this.startMetricsDiskBufferExporter();
            } else {
                log.debug("Telemetry disk buffer exporter is already running. Doing nothing.");
            }
        } else {
            log.debug("Telemetry disk buffer exporter is not needed. Doing nothing.");
        }
    }

    private synchronized void startMetricsDiskBufferExporter() {
        if (this.metricsDiskBufferExporterFuture == null || this.metricsDiskBufferExporterFuture.isDone()) {
            this.metricsDiskBufferExporterFuture = CompletableFuture.runAsync(this.metricsDiskBufferExporter);
        }
    }

    private boolean isDiskBufferExporterRunning() {
        return this.metricsDiskBufferExporterFuture != null && !this.metricsDiskBufferExporterFuture.isDone();
    }

    public Optional<DiskBufferStatus> getDiskBufferStatus() {
        String diskBufferDirectory = ClientUtils.getDiskBufferDirectory(this.config);
        if (diskBufferDirectory == null) {
            return Optional.empty();
        }
        try {
            DiskBufferStatus status = DiskBufferStatus.createWithFileScanning(diskBufferDirectory, this.isDiskBufferExporterRunning(), this.config.getDuration("telemetry.metrics.export.interval"), this.config.getDuration("telemetry.metrics.sending_queue.disk.max_file_age_write"), this.config.getDuration("telemetry.metrics.retry_on_failure.initial_backoff"), this.config.getDouble("telemetry.metrics.retry_on_failure.backoff_multiplier"), this.config.getDuration("telemetry.metrics.retry_on_failure.max_backoff"), this.config.getInt("telemetry.metrics.retry_on_failure.max_attempts"));
            return Optional.of(status);
        }
        catch (Exception e) {
            log.warn("Failed to get disk buffer status: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    @Generated
    public Resource getResource() {
        return this.resource;
    }

    @Generated
    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }
}

