/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ingestion.client;

import com.mulesoft.ingestion.client.DiskBufferExporter;
import io.opentelemetry.contrib.disk.buffering.MetricFromDiskExporter;
import io.opentelemetry.contrib.disk.buffering.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.utils.SignalTypes;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.time.Duration;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsDiskBufferExporter
extends DiskBufferExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsDiskBufferExporter.class);
    private final MetricExporter metricExporter;
    private final StorageConfiguration storageConfiguration;

    protected MetricsDiskBufferExporter(@NonNull MetricExporter metricExporter, @NonNull StorageConfiguration storageConfiguration, @NonNull Duration scanFrequency, @NonNull Duration exportTimeout) {
        super(scanFrequency, exportTimeout);
        if (metricExporter == null) {
            throw new NullPointerException("metricExporter is marked non-null but is null");
        }
        if (storageConfiguration == null) {
            throw new NullPointerException("storageConfiguration is marked non-null but is null");
        }
        if (scanFrequency == null) {
            throw new NullPointerException("scanFrequency is marked non-null but is null");
        }
        if (exportTimeout == null) {
            throw new NullPointerException("exportTimeout is marked non-null but is null");
        }
        this.metricExporter = metricExporter;
        this.storageConfiguration = storageConfiguration;
    }

    @Override
    void initialize() throws IOException {
        log.debug("Initializing metrics disk buffer exporter...");
        this.fromDiskExporter = MetricFromDiskExporter.create(this.metricExporter, this.storageConfiguration);
    }

    @Override
    void purgeUnrecognizedFiles() throws IOException {
        this.purgeUnrecognizedFiles(this.storageConfiguration.getRootDir() + "/" + SignalTypes.metrics.name());
    }
}

