/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ingestion.client;

import com.mulesoft.ingestion.client.TelemetryIngestionClient;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class IngestionClientFactory {
    private static IngestionClientFactory instance;
    private final Configuration defaultCommonConfig;
    private final Configuration defaultTelemetryConfig;
    private final Set<String> uniqueDiskRootDirs = ConcurrentHashMap.newKeySet();

    public static synchronized IngestionClientFactory getInstance() throws ConfigurationException {
        if (instance == null) {
            instance = new IngestionClientFactory();
        }
        return instance;
    }

    private IngestionClientFactory() throws ConfigurationException {
        Configurations configurations = new Configurations();
        this.defaultCommonConfig = configurations.properties("configurations/default-common.properties");
        this.defaultTelemetryConfig = configurations.properties("configurations/default-telemetry.properties");
    }

    public TelemetryIngestionClient getTelemetryIngestionClient(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.getTelemetryIngestionClient(ConfigurationConverter.getConfiguration(properties));
    }

    public TelemetryIngestionClient getTelemetryIngestionClient(@NonNull Configuration overrideConfig) {
        if (overrideConfig == null) {
            throw new NullPointerException("overrideConfig is marked non-null but is null");
        }
        CompositeConfiguration configuration = new CompositeConfiguration();
        configuration.addConfiguration(overrideConfig);
        configuration.addConfiguration(this.defaultCommonConfig);
        String ingestionType = configuration.getString("ingestion.type");
        if (ingestionType.equals("telemetry")) {
            configuration.addConfiguration(this.defaultTelemetryConfig);
            this.validateUniqueDiskRootDir(configuration);
            return new TelemetryIngestionClient(configuration);
        }
        throw new UnsupportedOperationException("Unsupported ingestion type: " + ingestionType);
    }

    private synchronized void validateUniqueDiskRootDir(@NonNull Configuration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (config.getString("telemetry.metrics.sending_queue.type").equals("disk")) {
            String rootDir = config.getString("telemetry.metrics.sending_queue.disk.root_dir");
            if (this.uniqueDiskRootDirs.contains(rootDir)) {
                throw new IllegalArgumentException(String.format("Property %s with value %s already in use. Please provide a different value.", "telemetry.metrics.sending_queue.disk.root_dir", rootDir));
            }
            this.uniqueDiskRootDirs.add(rootDir);
        }
    }
}

