/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ingestion.client;

import com.mulesoft.ingestion.client.ClientUtils;
import io.opentelemetry.contrib.disk.buffering.internal.exporter.FromDiskExporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DiskBufferExporter
implements Runnable,
Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiskBufferExporter.class);
    FromDiskExporter fromDiskExporter;
    private final Duration scanFrequency;
    private final Duration exportTimeout;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);

    protected DiskBufferExporter(@NonNull Duration scanFrequency, @NonNull Duration exportTimeout) {
        if (scanFrequency == null) {
            throw new NullPointerException("scanFrequency is marked non-null but is null");
        }
        if (exportTimeout == null) {
            throw new NullPointerException("exportTimeout is marked non-null but is null");
        }
        this.scanFrequency = scanFrequency;
        this.exportTimeout = exportTimeout;
    }

    @Override
    public void run() {
        this.isRunning.set(true);
        try {
            this.initialize();
            this.purgeUnrecognizedFiles();
            while (this.isRunning.get()) {
                if (this.exportBatch()) continue;
                log.debug("No batch to export. Sleeping for scan frequency: {}", (Object)this.scanFrequency);
                try {
                    ThreadUtils.sleep(this.scanFrequency);
                }
                catch (InterruptedException e) {
                    log.error("Disk buffer exporter thread interrupted", e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Throwable e) {
            log.error("Disk buffer exporter failed", e);
        }
        finally {
            try {
                this.fromDiskExporter.shutdown();
            }
            catch (IOException e) {
                log.error("Failed to shutdown disk buffer exporter", e);
            }
            log.info("Disk buffer exporter stopped");
        }
    }

    abstract void initialize() throws IOException;

    abstract void purgeUnrecognizedFiles() throws IOException;

    protected void purgeUnrecognizedFiles(String directory) throws IOException {
        log.debug("Purging unrecognized files in directory: {}", (Object)directory);
        File dir = ClientUtils.ensureDirectory(directory);
        File[] files = dir.listFiles((dir1, name) -> {
            try {
                Long.parseLong(name);
                return false;
            }
            catch (Exception e) {
                return true;
            }
        });
        if (files != null) {
            for (File file : files) {
                log.warn("Deleting unrecognized file: {}", (Object)file.getName());
                FileUtils.forceDelete(file);
            }
        }
    }

    private boolean exportBatch() {
        try {
            if (this.fromDiskExporter.exportStoredBatch(this.exportTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                log.debug("Exported stored batch");
                return true;
            }
            log.debug("Either there was no stored batch in the disk or the http exporter failed");
        }
        catch (IOException e) {
            log.error("Failed to export batch", e);
        }
        return false;
    }

    @Override
    public void close() {
        log.info("Closing disk buffer exporter...");
        this.isRunning.set(false);
    }
}

