/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ingestion.client;

import io.opentelemetry.contrib.disk.buffering.StorageConfiguration;
import io.opentelemetry.sdk.common.export.ProxyOptions;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);

    private ClientUtils() {
    }

    static String getBaseIngestionEndpoint(@NonNull Configuration config) throws MalformedURLException {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        String endpointUrl = config.getString("ingestion.endpoint.url", null);
        Validate.notBlank(endpointUrl, "ingestion.endpoint.url property is required", new Object[0]);
        URL url = new URL(endpointUrl);
        return url.toString();
    }

    static boolean isTlsStoreFile(@NonNull Configuration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (config.containsKey("ingestion.tls.keystore_file") && config.containsKey("ingestion.tls.keystore_password")) {
            if (config.containsKey("ingestion.tls.truststore_file") && config.containsKey("ingestion.tls.truststore_password")) {
                return true;
            }
            if (config.containsKey("ingestion.tls.truststore_file") || config.containsKey("ingestion.tls.truststore_password")) {
                log.warn("Both truststore file and password should be provided in configuration");
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean isTlsContent(@NonNull Configuration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        return config.containsKey("ingestion.tls.key") && config.containsKey("ingestion.tls.cert");
    }

    static boolean isTlsContentFile(@NonNull Configuration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        return config.containsKey("ingestion.tls.key_file") && config.containsKey("ingestion.tls.cert_file");
    }

    static TrustManager[] getTrustManagers(String trustStoreFile, String trustStorePassword, String trustStoreType) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        if (StringUtils.isEmpty(trustStoreFile)) {
            log.info("No truststore file provided. Using default truststore");
            trustManagerFactory.init((KeyStore)null);
        } else {
            KeyStore trustStore = KeyStore.getInstance(StringUtils.isEmpty(trustStoreType) ? KeyStore.getDefaultType() : trustStoreType);
            log.info("Using trustStore Type: {}", (Object)trustStore.getType());
            trustStore.load(Files.newInputStream(Paths.get(trustStoreFile, new String[0]), new OpenOption[0]), trustStorePassword.toCharArray());
            trustManagerFactory.init(trustStore);
        }
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        return trustManagers;
    }

    static SSLContext getSslContext(TrustManager[] trustManagers, String keyStoreFile, String keyStorePassword, String keyStoreType) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance(StringUtils.isEmpty(keyStoreType) ? KeyStore.getDefaultType() : keyStoreType);
        log.info("Using keyStore Type: {}", (Object)keyStore.getType());
        keyStore.load(Files.newInputStream(Paths.get(keyStoreFile, new String[0]), new OpenOption[0]), keyStorePassword.toCharArray());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagers, null);
        return sslContext;
    }

    static byte[] getContentFromStringOrFile(@NonNull Configuration config, String stringKey, String fileKey) throws IOException {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (config.containsKey(stringKey)) {
            return config.getString(stringKey).getBytes(StandardCharsets.UTF_8);
        }
        if (config.containsKey(fileKey)) {
            File file = new File(config.getString(fileKey));
            return FileUtils.readFileToByteArray(file);
        }
        return new byte[0];
    }

    static boolean isSendingQueueDisk(@NonNull Configuration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        return config.getString("telemetry.metrics.sending_queue.type").equals("disk");
    }

    static StorageConfiguration buildDiskStorageConfiguration(@NonNull Configuration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        return StorageConfiguration.builder().setRootDir(new File(config.getString("telemetry.metrics.sending_queue.disk.root_dir"))).setDebugEnabled(config.getBoolean("telemetry.metrics.sending_queue.disk.debug_enabled")).setMaxFileSize(config.getInt("telemetry.metrics.sending_queue.disk.max_file_size")).setMaxFolderSize(config.getInt("telemetry.metrics.sending_queue.disk.max_folder_size")).setMaxFileAgeForWriteMillis(config.getDuration("telemetry.metrics.sending_queue.disk.max_file_age_write").toMillis()).setMinFileAgeForReadMillis(config.getDuration("telemetry.metrics.sending_queue.disk.min_file_age_read").toMillis()).setMaxFileAgeForReadMillis(config.getDuration("telemetry.metrics.sending_queue.disk.max_file_age_read").toMillis()).build();
    }

    public static ProxyOptions getProxyOptions(@NonNull Configuration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (config.containsKey("ingestion.proxy.host") && config.containsKey("ingestion.proxy.port")) {
            String host = config.getString("ingestion.proxy.host");
            int port = config.getInt("ingestion.proxy.port");
            return ProxyOptions.create(InetSocketAddress.createUnresolved(host, port));
        }
        if (config.containsKey("ingestion.proxy.host") || config.containsKey("ingestion.proxy.port")) {
            log.warn("Both proxy host and port should be provided in configuration");
        }
        return null;
    }

    static RetryPolicy getRetryPolicy(@NonNull Configuration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        return RetryPolicy.builder().setInitialBackoff(config.getDuration("telemetry.metrics.retry_on_failure.initial_backoff")).setBackoffMultiplier(config.getDouble("telemetry.metrics.retry_on_failure.backoff_multiplier")).setMaxBackoff(config.getDuration("telemetry.metrics.retry_on_failure.max_backoff")).setMaxAttempts(config.getInt("telemetry.metrics.retry_on_failure.max_attempts")).build();
    }

    static File ensureDirectory(String directory) throws IOException {
        File dir = new File(directory);
        if (dir.exists() || dir.mkdirs()) {
            return dir;
        }
        throw new IOException("Failed to create directory: " + directory);
    }

    static String getDiskBufferDirectory(@NonNull Configuration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (!ClientUtils.isSendingQueueDisk(config)) {
            return null;
        }
        return config.getString("telemetry.metrics.sending_queue.disk.root_dir");
    }
}

