/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.reader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.weave.v2.core.util.CharsetUtil$;
import org.mule.weave.v2.model.structure.BufferedCharSequence;
import org.mule.weave.v2.module.reader.BufferedCharSequenceProvider;
import org.mule.weave.v2.module.reader.FileSourceProvider;
import org.mule.weave.v2.module.reader.FileSourceProvider$;
import org.mule.weave.v2.module.reader.InputStreamSourceProvider;
import org.mule.weave.v2.module.reader.InputStreamSourceProvider$;
import org.mule.weave.v2.module.reader.JavaObjectSourceProvider;
import org.mule.weave.v2.module.reader.SourceProvider;
import org.mule.weave.v2.module.reader.StringSourceProvider;
import org.mule.weave.v2.module.reader.StringSourceProvider$;
import org.mule.weave.v2.parser.module.MimeType;
import scala.None$;
import scala.Option;
import scala.Some;

public final class SourceProvider$ {
    public static SourceProvider$ MODULE$;

    static {
        new SourceProvider$();
    }

    public SourceProvider apply(File file, Charset charset) {
        return new FileSourceProvider(file, charset, FileSourceProvider$.MODULE$.$lessinit$greater$default$3());
    }

    public SourceProvider apply(File file, Charset charset, MimeType mediaType) {
        return new FileSourceProvider(file, charset, (Option<MimeType>)new Some((Object)mediaType));
    }

    public SourceProvider apply(String str) {
        return new StringSourceProvider(str, StringSourceProvider$.MODULE$.$lessinit$greater$default$2(), StringSourceProvider$.MODULE$.$lessinit$greater$default$3());
    }

    public SourceProvider apply(InputStream is, Charset charset) {
        return new InputStreamSourceProvider(is, charset, InputStreamSourceProvider$.MODULE$.$lessinit$greater$default$3());
    }

    public SourceProvider apply(InputStream is, Charset charset, MimeType mediaType) {
        return new InputStreamSourceProvider(is, charset, (Option<MimeType>)new Some((Object)mediaType));
    }

    public SourceProvider apply(Object source, Charset charset) {
        return this.apply(source, charset, (Option<MimeType>)None$.MODULE$);
    }

    public SourceProvider apply(Object source, Charset charset, Option<MimeType> mediaType) {
        Object object = source;
        if (object instanceof BufferedCharSequence) {
            BufferedCharSequence bufferedCharSequence = (BufferedCharSequence)object;
            return new BufferedCharSequenceProvider(bufferedCharSequence, charset, mediaType);
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return new InputStreamSourceProvider(new ByteArrayInputStream(byArray), charset, mediaType);
        }
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            return new InputStreamSourceProvider(inputStream, charset, mediaType);
        }
        if (object instanceof File) {
            File file = (File)object;
            return new FileSourceProvider(file, charset, mediaType);
        }
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            return new StringSourceProvider(((Object)charSequence).toString(), charset, mediaType);
        }
        return new JavaObjectSourceProvider(source, mediaType);
    }

    public SourceProvider apply(Object source) {
        Object object = source;
        if (object instanceof SourceProvider) {
            SourceProvider sourceProvider = (SourceProvider)object;
            return sourceProvider;
        }
        return this.apply(source, CharsetUtil$.MODULE$.defaultCharset());
    }

    private SourceProvider$() {
        MODULE$ = this;
    }
}

