/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.editor.io;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.mule.tooling.editor.io.INamespaceDeserializer;
import org.mule.tooling.editor.io.INamespaceSerializer;
import org.mule.tooling.editor.model.Namespace;

public class Utils
implements INamespaceDeserializer<File>,
INamespaceSerializer<File> {
    @Override
    public void serialize(Namespace namespace, File output) {
        if (output == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream outputStream = new FileOutputStream(output);){
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Namespace.class});
                Marshaller m = jaxbContext.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)true);
                m.marshal((Object)namespace, (OutputStream)outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JAXBException | IOException e) {
            e.printStackTrace();
        }
    }

    public static void serialize(Namespace namespace, OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null");
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Namespace.class});
            Marshaller m = jaxbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)namespace, outputStream);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Namespace deserialize(File input) {
        if (input == null) {
            throw new IllegalArgumentException("Could not adapt input to IFile");
        }
        Namespace namspace = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Namespace.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            namspace = (Namespace)jaxbUnmarshaller.unmarshal(input);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return namspace;
    }
}

