/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.jdk.core;

import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.launching.IVMInstall;
import org.mule.tooling.jdk.core.CompilerComplianceUpdater;
import org.mule.tooling.jdk.core.ExecutionEnvironmentUpdater;
import org.mule.tooling.jdk.core.InstalledJREUpdater;
import org.mule.tooling.jdk.core.JDK8CorePlugin;
import org.osgi.service.prefs.BackingStoreException;

public class StudioJREManager {
    private static final String ALREADY_RUN_PREF_KEY = "org.mule.tooling.jdk.core." + JDK8CorePlugin.VERSION + ".ALREADY_RUN";
    private ILog logger;

    public StudioJREManager(ILog logger) {
        this.logger = logger;
    }

    public void addAndSetAsDefaultJDKv17Plugin() {
        this.runWhenInstanceLocationIsSet("Add JDK 17 as default", monitor -> {
            if (this.wasAlreadyRun()) {
                return;
            }
            InstalledJREUpdater installedJREUpdater = new InstalledJREUpdater(this.logger);
            ExecutionEnvironmentUpdater executionEnvironmentUpdater = new ExecutionEnvironmentUpdater();
            CompilerComplianceUpdater compilerComplianceUpdater = new CompilerComplianceUpdater();
            Optional<IVMInstall> createdVM = installedJREUpdater.addStudioEmbeddedJDK(17);
            createdVM.ifPresent(installedJREUpdater::updateDefaultJRE);
            createdVM.ifPresent(compilerComplianceUpdater::updateCompliance);
            createdVM.ifPresent(executionEnvironmentUpdater::updateJDK17DefaultEE);
            installedJREUpdater.removeStudioEmbeddedJDK(8);
            this.markAsAlreadyRun();
        });
    }

    private void markAsAlreadyRun() {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.mule.tooling.jdk.core");
            if (prefs != null) {
                prefs.putBoolean(ALREADY_RUN_PREF_KEY, true);
            }
            prefs.flush();
        }
        catch (BackingStoreException e) {
            this.logger.error("Failed to save 'already run' preference", (Throwable)e);
        }
    }

    private boolean wasAlreadyRun() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.mule.tooling.jdk.core");
        if (prefs == null) {
            return false;
        }
        return prefs.getBoolean(ALREADY_RUN_PREF_KEY, false);
    }

    private void runWhenInstanceLocationIsSet(String jobName, final ICoreRunnable runnable) {
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (!Platform.getInstanceLocation().isSet()) {
                    this.schedule(500L);
                    return Status.OK_STATUS;
                }
                try {
                    runnable.run(monitor);
                }
                catch (CoreException e) {
                    IStatus st = e.getStatus();
                    return new Status(st.getSeverity(), st.getPlugin(), st.getCode(), st.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "org.mule.tooling.jdk.core.jobs".equals(family);
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.schedule();
    }
}

