/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.jdk.core;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.launching.VMDefinitionsContainer;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.osgi.framework.Bundle;

public class InstalledJREUpdater {
    private static final String EMBEDDED_JDK_ID_PREFIX_WITH_VERSION = "org.mule.tooling.jdk.v%d";
    private static final String EMBEDDED_JDK_ID_PREFIX = "org.mule.tooling.jdk";
    private static final String EMBEDDED_JDK_NAME = "JDK %d (Embedded)";
    private static final String ID_MACOSX_VM_TYPE = "org.eclipse.jdt.internal.launching.macosx.MacOSXType";
    private static final String JDK_LOCATION_IN_MACOSX_VM_BUNDLE = "/Contents/Home";
    private ILog logger;

    public InstalledJREUpdater(ILog logger) {
        this.logger = logger;
    }

    public Optional<IVMInstall> addStudioEmbeddedJDK(int jdkVersion) {
        Optional<IVMInstall> vmInstall = this.createVMInstallForStudioEmbeddedJDK(jdkVersion);
        vmInstall.ifPresent(vm -> {
            IVMInstall[] allVMs = this.getAllVMs();
            allVMs = Arrays.copyOf(allVMs, allVMs.length + 1);
            allVMs[allVMs.length - 1] = vm;
            IVMInstall defaultJRE = JavaRuntime.getDefaultVMInstall();
            this.updateJRESettings(allVMs, defaultJRE);
            this.logger.info("Added JRE: " + vm.getId());
        });
        return vmInstall;
    }

    public void updateDefaultJRE(IVMInstall defaultVM) {
        IVMInstall[] allVMs = this.getAllVMs();
        this.updateJRESettings(allVMs, defaultVM);
        this.logger.info("Default JRE set: " + defaultVM.getId());
    }

    private Optional<IVMInstall> createVMInstallForStudioEmbeddedJDK(int jdkVersion) {
        try {
            Bundle bundle;
            Optional optionalBundleParent;
            String os = Platform.getOS();
            String arch = Platform.getOSArch();
            String jdkPrefix = EMBEDDED_JDK_ID_PREFIX;
            if (jdkVersion <= 8) {
                arch = "x86_64";
                jdkPrefix = String.format(EMBEDDED_JDK_ID_PREFIX_WITH_VERSION, jdkVersion);
            }
            String bundleId = String.format("%s.%s.%s", jdkPrefix, os, arch);
            String vmInstallTypeId = "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
            String vmInstallLocationInBundle = "/";
            if ("macosx".equals(os)) {
                vmInstallTypeId = ID_MACOSX_VM_TYPE;
                vmInstallLocationInBundle = JDK_LOCATION_IN_MACOSX_VM_BUNDLE;
            }
            if (!(optionalBundleParent = FileLocator.getBundleFileLocation((Bundle)(bundle = Platform.getBundle((String)bundleId)))).isPresent()) {
                this.logger.error(String.format("Bundle for JDK %d does not exist. Bundle: %s", jdkVersion, bundle.toString()));
                return Optional.empty();
            }
            File installLocation = new File((File)optionalBundleParent.get(), vmInstallLocationInBundle);
            if (!installLocation.exists()) {
                this.logger.error(String.format("VM Install location inside JDK %d bundle does not exist. Location: %s", jdkVersion, installLocation.getCanonicalPath()));
                return Optional.empty();
            }
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)vmInstallTypeId);
            VMStandin vmstandin = new VMStandin(vmInstallType, bundleId);
            vmstandin.setName(String.format(EMBEDDED_JDK_NAME, jdkVersion));
            vmstandin.setInstallLocation(installLocation);
            return Optional.of(vmstandin.convertToRealVM());
        }
        catch (IOException e) {
            this.logger.error(String.format("Could not get the JDK %d bundle location", jdkVersion), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error(String.format("Could not create the JDK %d definition", jdkVersion), (Throwable)e);
        }
        return Optional.empty();
    }

    private IVMInstall[] getAllVMs() {
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        return (IVMInstall[])Arrays.stream(types).map(type -> Arrays.stream(type.getVMInstalls())).flatMap(Function.identity()).toArray(IVMInstall[]::new);
    }

    private boolean updateJRESettings(IVMInstall[] jres, IVMInstall defaultJRE) {
        VMDefinitionsContainer vmContainer = new VMDefinitionsContainer();
        String defaultVMId = JavaRuntime.getCompositeIdFromVM((IVMInstall)defaultJRE);
        vmContainer.setDefaultVMInstallCompositeID(defaultVMId);
        int i = 0;
        while (i < jres.length) {
            vmContainer.addVM(jres[i]);
            ++i;
        }
        this.saveVMDefinitions(vmContainer);
        return true;
    }

    private void saveVMDefinitions(VMDefinitionsContainer container) {
        try {
            String vmDefXML = container.getAsXML();
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching");
            if (prefs != null) {
                prefs.put(JavaRuntime.PREF_VM_XML, vmDefXML);
            }
            JavaRuntime.savePreferences();
        }
        catch (CoreException e) {
            this.logger.error("Failed to save VM definitions", (Throwable)e);
        }
    }

    public void removeStudioEmbeddedJDK(int jdkVersion) {
        String targetName = String.format(EMBEDDED_JDK_NAME, jdkVersion);
        IVMInstall[] allVMs = this.getAllVMs();
        List<IVMInstall> updatedVMs = Arrays.stream(allVMs).filter(vm -> !vm.getName().equals(targetName)).collect(Collectors.toList());
        this.updateJRESettings(updatedVMs.toArray(new IVMInstall[0]), JavaRuntime.getDefaultVMInstall());
        this.logger.info("Removed JDK " + jdkVersion + " entry from Installed JREs.");
    }
}

