/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.css.engine;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.internal.theme.ThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.css.engine.StudioCSSSWTEngineImpl;

public class StudioThemeEngineManager
implements IThemeManager {
    private static final String KEY = "org.eclipse.e4.ui.css.swt.theme";

    public IThemeEngine getEngineForDisplay(Display display) {
        Object engine = (IThemeEngine)display.getData(KEY);
        if (engine == null) {
            engine = new StudioThemeEngine(display);
            engine.addCSSEngine(this.getCSSSWTEngine(display));
            display.setData(KEY, engine);
        }
        return engine;
    }

    private CSSEngine getCSSSWTEngine(Display display) {
        Object cssEngine = WidgetElement.getEngine((Display)display);
        if (cssEngine != null) {
            return cssEngine;
        }
        cssEngine = new StudioCSSSWTEngineImpl(display, true);
        cssEngine.setErrorHandler(new CSSErrorHandler(){

            public void error(Exception e) {
                e.printStackTrace();
            }
        });
        WidgetElement.setEngine((Display)display, (CSSEngine)cssEngine);
        return cssEngine;
    }

    private class StudioThemeEngine
    extends ThemeEngine {
        public StudioThemeEngine(Display display) {
            super(display);
        }

        public void restore(String alternateTheme) {
            String prefThemeId = InstanceScope.INSTANCE.getNode(StudioThemeEngineManager.KEY).get("themeid", null);
            if (prefThemeId != null) {
                for (ITheme theme : this.getThemes()) {
                    if (!prefThemeId.equals(theme.getId())) continue;
                    this.setTheme(theme, false);
                    return;
                }
            }
            String themeToRestore = Display.isSystemDarkTheme() ? "org.mule.tooling.ui.theme.dark" : "org.mule.tooling.ui.theme.light";
            this.setTheme(themeToRestore, false);
        }
    }
}

