/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.css.engine;

import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.engine.CSSElementContextImpl;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.css.events.CssEventTypes;
import org.mule.tooling.css.events.IFigureDisposedListener;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.w3c.dom.Element;

public class StudioCSSSWTEngineImpl
extends CSSSWTEngineImpl {
    private EventBusHelper eventBusHelper = new EventBusHelper();

    public StudioCSSSWTEngineImpl(Display display) {
        super(display);
        this.initEventBusEvents();
    }

    public StudioCSSSWTEngineImpl(Display display, boolean lazyApplyingStyles) {
        super(display, lazyApplyingStyles);
        this.initEventBusEvents();
    }

    private void initEventBusEvents() {
        this.eventBusHelper.registerListener(UtilsPlugin.getEventBus(), CssEventTypes.ON_FIGURE_DISPOSED, (IEventHandler)new IFigureDisposedListener(){

            @Override
            public void onIFigureDisposed(List<IFigure> figures) {
                for (IFigure figure : figures) {
                    StudioCSSSWTEngineImpl.this.handleWidgetDisposed(figure);
                }
            }
        });
    }

    public void handleWidgetDisposed(Object widget) {
        if (widget instanceof IFigure) {
            Element element;
            Map elementsContext = this.getElementsContext();
            CSSElementContext removedContext = (CSSElementContext)elementsContext.remove(widget);
            if (removedContext != null && (element = removedContext.getElement()) instanceof CSSStylableElement) {
                ((CSSStylableElement)element).dispose();
            }
        } else {
            super.handleWidgetDisposed(widget);
        }
    }

    public Element getElement(Object element) {
        Element elt = null;
        CSSElementContext elementContext = this.getCSSElementContext(element);
        if (elementContext != null && !elementContext.elementMustBeRefreshed(this.getElementProvider())) {
            return elementContext.getElement();
        }
        if (element instanceof Element) {
            elt = (Element)element;
        } else if (this.getElementProvider() != null) {
            elt = this.getElementProvider().getElement(element, (CSSEngine)this);
        }
        if (elt != null) {
            if (elementContext == null) {
                elementContext = new CSSElementContextImpl();
                Object nativeWidget = this.getNativeWidget(element);
                this.hookNativeWidget(nativeWidget);
                this.getElementsContext().put(nativeWidget, elementContext);
            }
            elementContext.setElementProvider(this.getElementProvider());
            elementContext.setElement(elt);
            if (elt instanceof CSSStylableElement) {
                ((CSSStylableElement)elt).initialize();
            }
        }
        return elt;
    }
}

