/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.encryption;

import com.googlecode.jsendnsca.encryption.Encryptor;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class TripleDESEncryptor
implements Encryptor {
    private static final String DES_ALGORITHM = "DESede";
    private static final String DES_TRANSFORMATION = "DESede/CFB8/PKCS5Padding";

    @Override
    public void encrypt(byte[] passiveCheckBytes, byte[] initVector, String password) {
        byte[] keyBytes = this.toFixedSizeByteArray(password.getBytes(), 24);
        byte[] initVectorBytes = this.toFixedSizeByteArray(initVector, 8);
        SecretKeySpec key = new SecretKeySpec(keyBytes, DES_ALGORITHM);
        IvParameterSpec iv = new IvParameterSpec(initVectorBytes);
        try {
            Cipher cipher = Cipher.getInstance(DES_TRANSFORMATION);
            cipher.init(1, (Key)key, iv);
            byte[] cipherText = cipher.doFinal(passiveCheckBytes);
            System.arraycopy(cipherText, 0, passiveCheckBytes, 0, passiveCheckBytes.length);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] toFixedSizeByteArray(byte[] source, int fixedLength) {
        byte[] result = new byte[fixedLength];
        for (int i = 0; i < fixedLength && i < source.length; ++i) {
            result[i] = i < source.length ? source[i] : (byte)0;
        }
        return result;
    }
}

