/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.osgi.services;

import org.mule.tooling.osgi.services.Activator;
import org.mule.tooling.osgi.services.maven.MavenJarFileInspectorService;
import org.mule.tooling.utils.TypeContainer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class ServicesRegistry {
    private static ServicesRegistry instance;
    private TypeContainer services = new TypeContainer();

    public static ServicesRegistry get() {
        if (instance == null) {
            instance = new ServicesRegistry();
        }
        return instance;
    }

    private ServicesRegistry() {
    }

    public MavenJarFileInspectorService getMavenJarInspectorService() {
        return this.getService(MavenJarFileInspectorService.class);
    }

    private <T> T getService(Class<T> serviceClass) {
        if (!this.services.getType(serviceClass).isPresent()) {
            this.initializeService(serviceClass);
        }
        return this.services.getType(serviceClass).orElse(null);
    }

    private <T> void initializeService(Class<T> serviceClass) {
        BundleContext context = Activator.getContext();
        ServiceReference serviceReference = context.getServiceReference(serviceClass);
        if (serviceReference != null) {
            this.services.putType(serviceClass, context.getService(serviceReference));
        }
    }
}

